/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem;

import asmodeuscore.api.IBodies;
import asmodeuscore.api.IBodiesHandler;
import asmodeuscore.api.dimension.IAdvancedSpace;
import asmodeuscore.core.astronomy.BodiesData;
import asmodeuscore.core.astronomy.BodiesRegistry;
import asmodeuscore.core.astronomy.dimension.world.OreGenerator;
import asmodeuscore.core.astronomy.dimension.world.gen.ACBiome;
import asmodeuscore.core.prefab.celestialbody.ExPlanet;
import galaxyspace.GalaxySpace;
import galaxyspace.core.GSBlocks;
import galaxyspace.core.GSItems;
import galaxyspace.core.configs.GSConfigCore;
import galaxyspace.core.configs.GSConfigDimensions;
import galaxyspace.core.util.GSDimensions;
import galaxyspace.systems.SolarSystem.moons.callisto.dimension.TeleportTypeCallisto;
import galaxyspace.systems.SolarSystem.moons.callisto.dimension.WorldProviderCallisto;
import galaxyspace.systems.SolarSystem.moons.enceladus.dimension.TeleportTypeEnceladus;
import galaxyspace.systems.SolarSystem.moons.enceladus.dimension.WorldProviderEnceladus;
import galaxyspace.systems.SolarSystem.moons.enceladus.dimension.WorldProviderEnceladus_WE;
import galaxyspace.systems.SolarSystem.moons.europa.dimension.TeleportTypeEuropa;
import galaxyspace.systems.SolarSystem.moons.europa.dimension.WorldProviderEuropa_WE;
import galaxyspace.systems.SolarSystem.moons.europa.recipes.CraftingRecipesEuropa;
import galaxyspace.systems.SolarSystem.moons.ganymede.dimension.TeleportTypeGanymede;
import galaxyspace.systems.SolarSystem.moons.ganymede.dimension.WorldProviderGanymede;
import galaxyspace.systems.SolarSystem.moons.ganymede.recipes.CraftingRecipesGanymede;
import galaxyspace.systems.SolarSystem.moons.io.dimension.TeleportTypeIo;
import galaxyspace.systems.SolarSystem.moons.io.dimension.WorldProviderIo;
import galaxyspace.systems.SolarSystem.moons.io.recipes.CraftingRecipesIo;
import galaxyspace.systems.SolarSystem.moons.miranda.dimension.TeleportTypeMiranda;
import galaxyspace.systems.SolarSystem.moons.miranda.dimension.WorldProviderMiranda;
import galaxyspace.systems.SolarSystem.moons.miranda.recipes.CraftingRecipesMiranda;
import galaxyspace.systems.SolarSystem.moons.titan.dimension.TeleportTypeTitan;
import galaxyspace.systems.SolarSystem.moons.titan.dimension.WorldProviderTitan;
import galaxyspace.systems.SolarSystem.moons.triton.dimenson.TeleportTypeTriton;
import galaxyspace.systems.SolarSystem.moons.triton.dimenson.WorldProviderTriton_WE;
import galaxyspace.systems.SolarSystem.planets.ceres.dimension.TeleportTypeCeres;
import galaxyspace.systems.SolarSystem.planets.ceres.dimension.WorldProviderCeres;
import galaxyspace.systems.SolarSystem.planets.haumea.dimension.TeleportTypeHaumea;
import galaxyspace.systems.SolarSystem.planets.haumea.dimension.WorldProviderHaumea_WE;
import galaxyspace.systems.SolarSystem.planets.haumea.recipes.CraftingRecipesHaumea;
import galaxyspace.systems.SolarSystem.planets.kuiperbelt.dimension.TeleportTypeKuiperBelt;
import galaxyspace.systems.SolarSystem.planets.kuiperbelt.dimension.WorldProviderKuiperBelt;
import galaxyspace.systems.SolarSystem.planets.mars.dimension.WorldProviderMars_WE;
import galaxyspace.systems.SolarSystem.planets.mars.recipes.CraftingRecipesMars;
import galaxyspace.systems.SolarSystem.planets.mercury.dimension.TeleportTypeMercury;
import galaxyspace.systems.SolarSystem.planets.mercury.dimension.WorldProviderMercury;
import galaxyspace.systems.SolarSystem.planets.mercury.recipes.CraftingRecipesMercury;
import galaxyspace.systems.SolarSystem.planets.overworld.blocks.BlockOres;
import galaxyspace.systems.SolarSystem.planets.overworld.items.ItemSchematics;
import galaxyspace.systems.SolarSystem.planets.overworld.recipes.CraftingRecipesOverworld;
import galaxyspace.systems.SolarSystem.planets.overworld.recipes.schematic.SchematicBodyRecipe;
import galaxyspace.systems.SolarSystem.planets.overworld.recipes.schematic.SchematicBoosterRecipe;
import galaxyspace.systems.SolarSystem.planets.overworld.recipes.schematic.SchematicConeRecipe;
import galaxyspace.systems.SolarSystem.planets.overworld.recipes.schematic.SchematicEngineRecipe;
import galaxyspace.systems.SolarSystem.planets.overworld.recipes.schematic.SchematicFinsRecipe;
import galaxyspace.systems.SolarSystem.planets.overworld.recipes.schematic.SchematicOxTankRecipe;
import galaxyspace.systems.SolarSystem.planets.overworld.recipes.schematic.SchematicTier2Recipe;
import galaxyspace.systems.SolarSystem.planets.overworld.schematics.SchematicBody;
import galaxyspace.systems.SolarSystem.planets.overworld.schematics.SchematicBooster;
import galaxyspace.systems.SolarSystem.planets.overworld.schematics.SchematicCone;
import galaxyspace.systems.SolarSystem.planets.overworld.schematics.SchematicEngine;
import galaxyspace.systems.SolarSystem.planets.overworld.schematics.SchematicFins;
import galaxyspace.systems.SolarSystem.planets.overworld.schematics.SchematicOxTank;
import galaxyspace.systems.SolarSystem.planets.overworld.schematics.SchematicTier2Rocket;
import galaxyspace.systems.SolarSystem.planets.pluto.dimension.TeleportTypePluto;
import galaxyspace.systems.SolarSystem.planets.pluto.dimension.WorldProviderPluto;
import galaxyspace.systems.SolarSystem.satellites.venus.dimension.TeleportTypeVenusSS;
import galaxyspace.systems.SolarSystem.satellites.venus.dimension.WorldProviderVenusSS;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.Satellite;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.item.EnumExtendedInventorySlot;
import micdoodle8.mods.galacticraft.api.recipe.ISchematicPage;
import micdoodle8.mods.galacticraft.api.recipe.SchematicRegistry;
import micdoodle8.mods.galacticraft.api.recipe.SpaceStationRecipe;
import micdoodle8.mods.galacticraft.api.world.AtmosphereInfo;
import micdoodle8.mods.galacticraft.api.world.EnumAtmosphericGas;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.api.world.SpaceStationType;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.util.CompatibilityManager;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.AsteroidsModule;
import micdoodle8.mods.galacticraft.planets.asteroids.schematic.SchematicTier3Rocket;
import micdoodle8.mods.galacticraft.planets.mars.ConfigManagerMars;
import micdoodle8.mods.galacticraft.planets.mars.MarsModule;
import micdoodle8.mods.galacticraft.planets.mars.dimension.TeleportTypeMars;
import micdoodle8.mods.galacticraft.planets.mars.items.MarsItems;
import micdoodle8.mods.galacticraft.planets.venus.ConfigManagerVenus;
import micdoodle8.mods.galacticraft.planets.venus.VenusModule;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;

@IBodiesHandler
public class SolarSystemBodies
implements IBodies {
    public static Planet planetMercury;
    public static Planet planetCeres;
    public static Planet planetJupiter;
    public static Planet planetSaturn;
    public static Planet planetUranus;
    public static Planet planetNeptune;
    public static Planet planetPluto;
    public static ExPlanet planetKuiperBelt;
    public static Planet planetHaumea;
    public static Planet planetMakemake;
    public static Planet planetEris;
    public static Planet planetDeeDee;
    public static Moon phobosMars;
    public static Moon deimosMars;
    public static Moon ioJupiter;
    public static Moon europaJupiter;
    public static Moon ganymedeJupiter;
    public static Moon callistoJupiter;
    public static Moon mimasSaturn;
    public static Moon enceladusSaturn;
    public static Moon tethysSaturn;
    public static Moon dioneSaturn;
    public static Moon rheyaSaturn;
    public static Moon titanSaturn;
    public static Moon iapetusSaturn;
    public static Moon mirandaUranus;
    public static Moon arielUranus;
    public static Moon umbrielUranus;
    public static Moon titaniaUranus;
    public static Moon oberonUranus;
    public static Moon proteusNeptune;
    public static Moon tritonNeptune;
    public static Moon charonPluto;
    public static Satellite marsSpaceStation;
    public static Satellite venusSpaceStation;

    public void preInit(FMLPreInitializationEvent event) {
        SolarSystem sol = GalacticraftCore.solarSystemSol;
        planetMercury = BodiesRegistry.registerExPlanet((SolarSystem)sol, (String)"mercury", (String)"galaxyspace", (float)0.5f);
        BodiesRegistry.setOrbitData((CelestialBody)planetMercury, (float)1.45f, (float)0.5f, (float)0.24f, (float)0.0f, (float)0.0f, (float)4.0f, (float)0.0f);
        BodiesRegistry.setPlanetData((CelestialBody)planetMercury, (float)0.0f, (long)176000L, (float)BodiesRegistry.calculateGravity((float)3.8f), (boolean)true);
        BodiesRegistry.setAtmosphere((CelestialBody)planetMercury, (boolean)false, (boolean)false, (boolean)false, (float)8.0f, (float)0.0f, (float)0.0f);
        BodiesRegistry.setProviderData((CelestialBody)planetMercury, WorldProviderMercury.class, (int)GSConfigDimensions.dimensionIDMercury, (int)3, (Biome[])new Biome[]{ACBiome.ACSpace});
        GalaxyRegistry.registerPlanet((Planet)planetMercury);
        planetCeres = BodiesRegistry.registerExPlanet((SolarSystem)sol, (String)"ceres", (String)"galaxyspace", (float)1.7f);
        planetCeres.setRingColorRGB(0.0f, 0.0f, 0.0f);
        BodiesRegistry.setOrbitData((CelestialBody)planetCeres, (float)2.0f, (float)0.5f, (float)15.0f);
        BodiesRegistry.setPlanetData((CelestialBody)planetCeres, (float)0.0f, (long)10000L, (float)BodiesRegistry.calculateGravity((float)2.37f), (boolean)true);
        BodiesRegistry.setAtmosphere((CelestialBody)planetCeres, (boolean)false, (boolean)false, (boolean)false, (float)-5.0f, (float)0.0f, (float)0.0f);
        BodiesRegistry.setProviderData((CelestialBody)planetCeres, WorldProviderCeres.class, (int)GSConfigDimensions.dimensionIDCeres, (int)3, (Biome[])new Biome[]{ACBiome.ACSpace});
        GalaxyRegistry.registerPlanet((Planet)planetCeres);
        planetJupiter = BodiesRegistry.registerExPlanet((SolarSystem)sol, (String)"jupiter", (String)"galaxyspace", (float)2.0f);
        BodiesRegistry.setOrbitData((CelestialBody)planetJupiter, (float)((float)Math.PI), (float)2.0f, (float)11.86f);
        GalaxyRegistry.registerPlanet((Planet)planetJupiter);
        planetSaturn = BodiesRegistry.registerExPlanet((SolarSystem)sol, (String)"saturn", (String)"galaxyspace", (float)2.25f);
        BodiesRegistry.setOrbitData((CelestialBody)planetSaturn, (float)1.5707964f, (float)1.5f, (float)29.46f);
        GalaxyRegistry.registerPlanet((Planet)planetSaturn);
        planetUranus = BodiesRegistry.registerExPlanet((SolarSystem)sol, (String)"uranus", (String)"galaxyspace", (float)2.5f);
        BodiesRegistry.setOrbitData((CelestialBody)planetUranus, (float)0.7853982f, (float)1.2f, (float)84.06f);
        GalaxyRegistry.registerPlanet((Planet)planetUranus);
        planetNeptune = BodiesRegistry.registerExPlanet((SolarSystem)sol, (String)"neptune", (String)"galaxyspace", (float)2.75f);
        BodiesRegistry.setOrbitData((CelestialBody)planetNeptune, (float)((float)Math.PI), (float)1.2f, (float)164.84f);
        GalaxyRegistry.registerPlanet((Planet)planetNeptune);
        planetPluto = BodiesRegistry.registerExPlanet((SolarSystem)sol, (String)"pluto", (String)"galaxyspace", (float)3.0f);
        planetPluto.atmosphereComponent(EnumAtmosphericGas.NITROGEN);
        BodiesRegistry.setOrbitData((CelestialBody)planetPluto, (float)0.0f, (float)0.5f, (float)250.0f, (float)0.0f, (float)0.0f, (float)25.0f, (float)0.0f);
        BodiesRegistry.setPlanetData((CelestialBody)planetPluto, (float)0.0f, (long)98000L, (float)BodiesRegistry.calculateGravity((float)2.62f), (boolean)true);
        BodiesRegistry.setAtmosphere((CelestialBody)planetPluto, (boolean)false, (boolean)false, (boolean)false, (float)-12.0f, (float)0.0f, (float)0.0f);
        BodiesRegistry.setProviderData((CelestialBody)planetPluto, WorldProviderPluto.class, (int)GSConfigDimensions.dimensionIDPluto, (int)6, (Biome[])new Biome[]{ACBiome.ACSpace, ACBiome.ACSpaceLowPlains, ACBiome.ACSpaceLowHills, ACBiome.ACSpaceMidPlains});
        GalaxyRegistry.registerPlanet((Planet)planetPluto);
        planetKuiperBelt = (ExPlanet)BodiesRegistry.registerExPlanet((SolarSystem)sol, (String)"kuiperbelt", (String)"galaxyspace", (float)3.25f).setRingColorRGB(1.1f, 0.0f, 0.0f);
        planetKuiperBelt.setClassPlanet(IAdvancedSpace.ClassBody.ASTEROID);
        planetKuiperBelt.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(3.5f, 3.2f));
        BodiesRegistry.setOrbitData((CelestialBody)planetKuiperBelt, (float)1.0f, (float)1.0f, (float)300.0f);
        BodiesRegistry.setAtmosphere((CelestialBody)planetKuiperBelt, (boolean)false, (boolean)false, (boolean)false, (float)-12.0f, (float)0.0f, (float)0.0f);
        BodiesRegistry.setPlanetData((CelestialBody)planetKuiperBelt, (float)0.0f, (long)0L, (float)0.0f, (boolean)true);
        BodiesRegistry.setProviderData((CelestialBody)planetKuiperBelt, WorldProviderKuiperBelt.class, (int)GSConfigDimensions.dimensionIDKuiperBelt, (int)6, (Biome[])new Biome[]{ACBiome.ACSpace});
        GalaxyRegistry.registerPlanet((Planet)planetKuiperBelt);
        planetHaumea = BodiesRegistry.registerExPlanet((SolarSystem)sol, (String)"haumea", (String)"galaxyspace", (float)3.75f);
        BodiesRegistry.setOrbitData((CelestialBody)planetHaumea, (float)4.781593f, (float)1.0f, (float)392.9f);
        BodiesRegistry.setAtmosphere((CelestialBody)planetHaumea, (boolean)false, (boolean)false, (boolean)false, (float)-12.0f, (float)0.0f, (float)0.0f);
        BodiesRegistry.setPlanetData((CelestialBody)planetHaumea, (float)0.0f, (long)12000L, (float)BodiesRegistry.calculateGravity((float)2.02f), (boolean)true);
        BodiesRegistry.setProviderData((CelestialBody)planetHaumea, WorldProviderHaumea_WE.class, (int)GSConfigDimensions.dimensionIDHaumea, (int)6, (Biome[])new Biome[]{ACBiome.ACSpace});
        GalaxyRegistry.registerPlanet((Planet)planetHaumea);
        phobosMars = BodiesRegistry.registerExMoon((Planet)MarsModule.planetMars, (String)"phobos", (String)"galaxyspace", (float)8.0f);
        BodiesRegistry.setOrbitData((CelestialBody)phobosMars, (float)1.0f, (float)0.0017f, (float)100.0f);
        GalaxyRegistry.registerMoon((Moon)phobosMars);
        deimosMars = BodiesRegistry.registerExMoon((Planet)MarsModule.planetMars, (String)"deimos", (String)"galaxyspace", (float)16.0f);
        BodiesRegistry.setOrbitData((CelestialBody)deimosMars, (float)1.0f, (float)0.0017f, (float)300.0f);
        GalaxyRegistry.registerMoon((Moon)deimosMars);
        ioJupiter = BodiesRegistry.registerExMoon((Planet)planetJupiter, (String)"io", (String)"galaxyspace", (float)10.0f);
        BodiesRegistry.setOrbitData((CelestialBody)ioJupiter, (float)1.0f, (float)0.0017f, (float)50.0f);
        BodiesRegistry.setAtmosphere((CelestialBody)ioJupiter, (boolean)false, (boolean)false, (boolean)false, (float)-4.2f, (float)0.0f, (float)0.0f);
        BodiesRegistry.setPlanetData((CelestialBody)ioJupiter, (float)0.0f, (long)42000L, (float)0.052f, (boolean)true);
        BodiesRegistry.setProviderData((CelestialBody)ioJupiter, WorldProviderIo.class, (int)GSConfigDimensions.dimensionIDIo, (int)4, (Biome[])new Biome[]{ACBiome.ACSpace, ACBiome.ACSpaceLowHills, ACBiome.ACSpaceLowPlains});
        GalaxyRegistry.registerMoon((Moon)ioJupiter);
        europaJupiter = BodiesRegistry.registerExMoon((Planet)planetJupiter, (String)"europa", (String)"galaxyspace", (float)15.0f);
        BodiesRegistry.setOrbitData((CelestialBody)europaJupiter, (float)((float)Math.PI), (float)0.0017f, (float)100.0f);
        BodiesRegistry.setAtmosphere((CelestialBody)europaJupiter, (boolean)false, (boolean)false, (boolean)false, (float)-2.0f, (float)0.0f, (float)0.0f);
        BodiesRegistry.setPlanetData((CelestialBody)europaJupiter, (float)0.2f, (float)0.0f, (long)58000L, (float)0.062f, (boolean)true);
        BodiesRegistry.setProviderData((CelestialBody)europaJupiter, WorldProviderEuropa_WE.class, (int)GSConfigDimensions.dimensionIDEuropa, (int)4, (Biome[])new Biome[0]);
        GalaxyRegistry.registerMoon((Moon)europaJupiter);
        ganymedeJupiter = BodiesRegistry.registerExMoon((Planet)planetJupiter, (String)"ganymede", (String)"galaxyspace", (float)20.0f);
        BodiesRegistry.setOrbitData((CelestialBody)ganymedeJupiter, (float)1.5707964f, (float)0.0017f, (float)150.0f);
        BodiesRegistry.setAtmosphere((CelestialBody)ganymedeJupiter, (boolean)false, (boolean)false, (boolean)false, (float)-2.0f, (float)0.0f, (float)0.0f);
        BodiesRegistry.setPlanetData((CelestialBody)ganymedeJupiter, (float)0.0f, (long)102000L, (float)0.057f, (boolean)false);
        BodiesRegistry.setProviderData((CelestialBody)ganymedeJupiter, WorldProviderGanymede.class, (int)GSConfigDimensions.dimensionIDGanymede, (int)4, (Biome[])new Biome[0]);
        GalaxyRegistry.registerMoon((Moon)ganymedeJupiter);
        callistoJupiter = BodiesRegistry.registerExMoon((Planet)planetJupiter, (String)"callisto", (String)"galaxyspace", (float)30.0f);
        BodiesRegistry.setOrbitData((CelestialBody)callistoJupiter, (float)1.0471976f, (float)0.0017f, (float)200.0f);
        BodiesRegistry.setAtmosphere((CelestialBody)callistoJupiter, (boolean)false, (boolean)false, (boolean)false, (float)-2.0f, (float)0.0f, (float)0.0f);
        BodiesRegistry.setPlanetData((CelestialBody)callistoJupiter, (float)0.0f, (long)154000L, (float)0.054f, (boolean)false);
        BodiesRegistry.setProviderData((CelestialBody)callistoJupiter, WorldProviderCallisto.class, (int)GSConfigDimensions.dimensionIDCallisto, (int)4, (Biome[])new Biome[0]);
        GalaxyRegistry.registerMoon((Moon)callistoJupiter);
        mimasSaturn = BodiesRegistry.registerExMoon((Planet)planetSaturn, (String)"mimas", (String)"galaxyspace", (float)10.0f);
        BodiesRegistry.setOrbitData((CelestialBody)mimasSaturn, (float)1.5707964f, (float)0.0017f, (float)20.0f);
        GalaxyRegistry.registerMoon((Moon)mimasSaturn);
        enceladusSaturn = BodiesRegistry.registerExMoon((Planet)planetSaturn, (String)"enceladus", (String)"galaxyspace", (float)15.0f);
        BodiesRegistry.setOrbitData((CelestialBody)enceladusSaturn, (float)1.0471976f, (float)0.0017f, (float)50.0f);
        BodiesRegistry.setAtmosphere((CelestialBody)enceladusSaturn, (boolean)false, (boolean)false, (boolean)false, (float)-4.0f, (float)0.0f, (float)0.0f);
        BodiesRegistry.setPlanetData((CelestialBody)enceladusSaturn, (float)0.0f, (long)32000L, (float)0.058f, (boolean)false);
        BodiesRegistry.setProviderData((CelestialBody)enceladusSaturn, GSConfigCore.enableWorldEngine ? WorldProviderEnceladus_WE.class : WorldProviderEnceladus.class, (int)GSConfigDimensions.dimensionIDEnceladus, (int)5, (Biome[])new Biome[0]);
        GalaxyRegistry.registerMoon((Moon)enceladusSaturn);
        tethysSaturn = BodiesRegistry.registerExMoon((Planet)planetSaturn, (String)"tethys", (String)"galaxyspace", (float)20.0f);
        BodiesRegistry.setOrbitData((CelestialBody)tethysSaturn, (float)((float)Math.PI), (float)0.0017f, (float)120.0f);
        GalaxyRegistry.registerMoon((Moon)tethysSaturn);
        dioneSaturn = BodiesRegistry.registerExMoon((Planet)planetSaturn, (String)"dione", (String)"galaxyspace", (float)25.0f);
        BodiesRegistry.setOrbitData((CelestialBody)dioneSaturn, (float)0.7853982f, (float)0.0017f, (float)180.0f);
        GalaxyRegistry.registerMoon((Moon)dioneSaturn);
        rheyaSaturn = BodiesRegistry.registerExMoon((Planet)planetSaturn, (String)"rheya", (String)"galaxyspace", (float)30.0f);
        BodiesRegistry.setOrbitData((CelestialBody)rheyaSaturn, (float)1.0471976f, (float)0.0017f, (float)220.0f);
        GalaxyRegistry.registerMoon((Moon)rheyaSaturn);
        titanSaturn = BodiesRegistry.registerExMoon((Planet)planetSaturn, (String)"titan", (String)"galaxyspace", (float)35.0f);
        titanSaturn.atmosphereComponent(EnumAtmosphericGas.NITROGEN);
        BodiesRegistry.setClassBody((CelestialBody)titanSaturn, (IAdvancedSpace.ClassBody)IAdvancedSpace.ClassBody.TITAN);
        BodiesRegistry.setOrbitData((CelestialBody)titanSaturn, (float)0.62831855f, (float)0.0017f, (float)280.0f);
        BodiesRegistry.setAtmosphere((CelestialBody)titanSaturn, (boolean)false, (boolean)false, (boolean)false, (float)-4.0f, (float)1.0f, (float)0.0f);
        BodiesRegistry.setPlanetData((CelestialBody)titanSaturn, (float)0.0f, (long)105500L, (float)0.058f, (boolean)false);
        BodiesRegistry.setProviderData((CelestialBody)titanSaturn, WorldProviderTitan.class, (int)GSConfigDimensions.dimensionIDTitan, (int)5, (Biome[])new Biome[0]);
        GalaxyRegistry.registerMoon((Moon)titanSaturn);
        iapetusSaturn = BodiesRegistry.registerExMoon((Planet)planetSaturn, (String)"iapetus", (String)"galaxyspace", (float)40.0f);
        BodiesRegistry.setOrbitData((CelestialBody)iapetusSaturn, (float)((float)Math.PI), (float)0.0017f, (float)350.0f);
        GalaxyRegistry.registerMoon((Moon)iapetusSaturn);
        mirandaUranus = BodiesRegistry.registerExMoon((Planet)planetUranus, (String)"miranda", (String)"galaxyspace", (float)10.0f);
        BodiesRegistry.setOrbitData((CelestialBody)mirandaUranus, (float)((float)Math.PI), (float)0.0017f, (float)20.0f);
        BodiesRegistry.setAtmosphere((CelestialBody)mirandaUranus, (boolean)false, (boolean)false, (boolean)false, (float)-5.0f, (float)0.0f, (float)0.0f);
        BodiesRegistry.setPlanetData((CelestialBody)mirandaUranus, (float)0.0f, (long)33500L, (float)0.057f, (boolean)true);
        BodiesRegistry.setProviderData((CelestialBody)mirandaUranus, WorldProviderMiranda.class, (int)GSConfigDimensions.dimensionIDMiranda, (int)5, (Biome[])new Biome[]{ACBiome.ACSpace, ACBiome.ACSpaceLowPlains, ACBiome.ACSpaceMidHills});
        GalaxyRegistry.registerMoon((Moon)mirandaUranus);
        arielUranus = BodiesRegistry.registerExMoon((Planet)planetUranus, (String)"ariel", (String)"galaxyspace", (float)15.0f);
        BodiesRegistry.setOrbitData((CelestialBody)arielUranus, (float)1.5707964f, (float)0.0017f, (float)50.0f);
        GalaxyRegistry.registerMoon((Moon)arielUranus);
        umbrielUranus = BodiesRegistry.registerExMoon((Planet)planetUranus, (String)"umbriel", (String)"galaxyspace", (float)20.0f);
        BodiesRegistry.setOrbitData((CelestialBody)umbrielUranus, (float)1.0471976f, (float)0.0017f, (float)120.0f);
        GalaxyRegistry.registerMoon((Moon)umbrielUranus);
        titaniaUranus = BodiesRegistry.registerExMoon((Planet)planetUranus, (String)"titania", (String)"galaxyspace", (float)25.0f);
        BodiesRegistry.setOrbitData((CelestialBody)titaniaUranus, (float)0.7853982f, (float)0.0017f, (float)180.0f);
        GalaxyRegistry.registerMoon((Moon)titaniaUranus);
        oberonUranus = BodiesRegistry.registerExMoon((Planet)planetUranus, (String)"oberon", (String)"galaxyspace", (float)30.0f);
        BodiesRegistry.setOrbitData((CelestialBody)oberonUranus, (float)0.7853982f, (float)0.0017f, (float)220.0f);
        GalaxyRegistry.registerMoon((Moon)oberonUranus);
        proteusNeptune = BodiesRegistry.registerExMoon((Planet)planetNeptune, (String)"proteus", (String)"galaxyspace", (float)10.0f);
        BodiesRegistry.setOrbitData((CelestialBody)proteusNeptune, (float)((float)Math.PI), (float)0.0017f, (float)50.0f);
        GalaxyRegistry.registerMoon((Moon)proteusNeptune);
        tritonNeptune = BodiesRegistry.registerExMoon((Planet)planetNeptune, (String)"triton", (String)"galaxyspace", (float)25.0f);
        BodiesRegistry.setOrbitData((CelestialBody)tritonNeptune, (float)((float)Math.PI), (float)0.0017f, (float)-200.0f);
        BodiesRegistry.setAtmosphere((CelestialBody)tritonNeptune, (boolean)false, (boolean)false, (boolean)false, (float)-11.2f, (float)0.0f, (float)0.0f);
        BodiesRegistry.setPlanetData((CelestialBody)tritonNeptune, (float)0.0f, (long)145200L, (float)0.059f, (boolean)true);
        BodiesRegistry.setProviderData((CelestialBody)tritonNeptune, WorldProviderTriton_WE.class, (int)GSConfigDimensions.dimensionIDTriton, (int)6, (Biome[])new Biome[0]);
        GalaxyRegistry.registerMoon((Moon)tritonNeptune);
        charonPluto = BodiesRegistry.registerExMoon((Planet)planetPluto, (String)"charon", (String)"galaxyspace", (float)15.0f);
        BodiesRegistry.setOrbitData((CelestialBody)charonPluto, (float)((float)Math.PI), (float)0.0017f, (float)50.0f);
        GalaxyRegistry.registerMoon((Moon)charonPluto);
        venusSpaceStation = new Satellite("spacestation.venus").setParentBody(VenusModule.planetVenus);
        venusSpaceStation.setRelativeSize(0.2667f);
        venusSpaceStation.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(5.5f, 5.5f));
        venusSpaceStation.setRelativeOrbitTime(20.0f);
        if (GSConfigDimensions.enableVenusSpaceStation) {
            venusSpaceStation.setTierRequired(VenusModule.planetVenus.getTierRequirement());
            venusSpaceStation.setDimensionInfo(GSConfigDimensions.idDimensionVenusOrbit, GSConfigDimensions.idDimensionVenusOrbitStatic, WorldProviderVenusSS.class);
            venusSpaceStation.setBodyIcon(new ResourceLocation("galacticraftcore:textures/gui/celestialbodies/space_station.png"));
            venusSpaceStation.addChecklistKeys(new String[]{"equip_oxygen_suit", "equip_parachute"});
            venusSpaceStation.setBiomeInfo(new Biome[]{ACBiome.ACSpace});
            venusSpaceStation.atmosphereComponent(EnumAtmosphericGas.CO2).atmosphereComponent(EnumAtmosphericGas.NITROGEN);
            venusSpaceStation.setAtmosphere(new AtmosphereInfo(Boolean.valueOf(false), false, false, 0.8f, 0.4f, 0.0f));
        }
        SolarSystemBodies.registryteleport();
        SolarSystemBodies.registrycelestial();
    }

    public void init(FMLInitializationEvent event) {
        VenusModule.planetVenus.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(0.745f, 0.74f)).setRingColorRGB(0.0f, 0.4f, 0.9f);
        GalacticraftCore.satelliteSpaceStation.setRingColorRGB(0.0f, 0.4f, 0.9f);
        GalacticraftCore.planetOverworld.setRingColorRGB(0.0f, 1.1f, 0.0f);
        GalacticraftCore.moonMoon.setRingColorRGB(0.0f, 0.4f, 0.9f);
        MarsModule.planetMars.setRingColorRGB(0.0f, 0.4f, 0.9f);
        if (GSConfigCore.enableWorldEngine && GSConfigCore.enableMarsWorldEngine) {
            MarsModule.planetMars.setDimensionInfo(ConfigManagerMars.dimensionIDMars, WorldProviderMars_WE.class, true);
            MarsModule.planetMars.setAtmosphere(new AtmosphereInfo(Boolean.valueOf(false), false, false, -2.0f, 1.0f, 0.1f));
            MarsModule.planetMars.atmosphereComponent(EnumAtmosphericGas.CO2).atmosphereComponent(EnumAtmosphericGas.ARGON).atmosphereComponent(EnumAtmosphericGas.NITROGEN);
        }
        AsteroidsModule.planetAsteroids.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.75f, 1.75f));
        if (GSConfigCore.enableOverworldOres) {
            if (!CompatibilityManager.isTConstructLoaded) {
                GameRegistry.registerWorldGenerator((IWorldGenerator)new OreGenerator(GSBlocks.OVERWORLD_ORES.func_176223_P().func_177226_a(BlockOres.BASIC_TYPE, (Comparable)((Object)BlockOres.EnumBlockOres.COBALT)), 6, 0, 60, 5, Blocks.field_150348_b.func_176223_P(), 0), (int)0);
            }
            GameRegistry.registerWorldGenerator((IWorldGenerator)new OreGenerator(GSBlocks.OVERWORLD_ORES.func_176223_P().func_177226_a(BlockOres.BASIC_TYPE, (Comparable)((Object)BlockOres.EnumBlockOres.NICKEL)), 6, 0, 45, 4, Blocks.field_150348_b.func_176223_P(), 0), (int)1);
        }
        SolarSystemBodies.registerDungeonLoot();
        SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicCone());
        SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicBody());
        SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicEngine());
        SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicBooster());
        SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicFins());
        SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicOxTank());
        if (GSConfigCore.enableAdvancedRocketCraft) {
            for (ISchematicPage page : SchematicRegistry.schematicRecipes) {
                if (!(page instanceof micdoodle8.mods.galacticraft.planets.mars.schematic.SchematicTier2Rocket)) continue;
                SchematicRegistry.schematicRecipes.remove(page);
                break;
            }
            for (ISchematicPage page : SchematicRegistry.schematicRecipes) {
                if (!(page instanceof SchematicTier3Rocket)) continue;
                SchematicRegistry.schematicRecipes.remove(page);
                break;
            }
            SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicTier2Rocket());
            GCItems.hiddenItems.add(new ItemStack(MarsItems.schematic, 1, 0).func_77973_b());
        }
        GalacticraftRegistry.registerGear((int)40, (EnumExtendedInventorySlot)EnumExtendedInventorySlot.LEFT_TANK, (Item)GSItems.OXYGENTANK_TIER_4);
        GalacticraftRegistry.registerGear((int)40, (EnumExtendedInventorySlot)EnumExtendedInventorySlot.RIGHT_TANK, (Item)GSItems.OXYGENTANK_TIER_4);
        GalacticraftRegistry.registerGear((int)41, (EnumExtendedInventorySlot)EnumExtendedInventorySlot.LEFT_TANK, (Item)GSItems.OXYGENTANK_TIER_5);
        GalacticraftRegistry.registerGear((int)41, (EnumExtendedInventorySlot)EnumExtendedInventorySlot.RIGHT_TANK, (Item)GSItems.OXYGENTANK_TIER_5);
        GalacticraftRegistry.registerGear((int)42, (EnumExtendedInventorySlot)EnumExtendedInventorySlot.LEFT_TANK, (Item)GSItems.OXYGENTANK_TIER_6);
        GalacticraftRegistry.registerGear((int)42, (EnumExtendedInventorySlot)EnumExtendedInventorySlot.RIGHT_TANK, (Item)GSItems.OXYGENTANK_TIER_6);
        GalacticraftRegistry.registerGear((int)43, (EnumExtendedInventorySlot)EnumExtendedInventorySlot.LEFT_TANK, (Item)GSItems.OXYGENTANK_TIER_EPP);
        GalacticraftRegistry.registerGear((int)43, (EnumExtendedInventorySlot)EnumExtendedInventorySlot.RIGHT_TANK, (Item)GSItems.OXYGENTANK_TIER_EPP);
        GalacticraftRegistry.registerGear((int)44, (EnumExtendedInventorySlot)EnumExtendedInventorySlot.SHIELD_CONTROLLER, (ItemStack)new ItemStack(GSItems.BASIC, 1, 16));
        GalacticraftRegistry.registerGear((int)45, (EnumExtendedInventorySlot)EnumExtendedInventorySlot.THERMAL_HELMET, (ItemStack)new ItemStack(GSItems.THERMAL_PADDING_3, 1, 0));
        GalacticraftRegistry.registerGear((int)46, (EnumExtendedInventorySlot)EnumExtendedInventorySlot.THERMAL_CHESTPLATE, (ItemStack)new ItemStack(GSItems.THERMAL_PADDING_3, 1, 1));
        GalacticraftRegistry.registerGear((int)47, (EnumExtendedInventorySlot)EnumExtendedInventorySlot.THERMAL_LEGGINGS, (ItemStack)new ItemStack(GSItems.THERMAL_PADDING_3, 1, 2));
        GalacticraftRegistry.registerGear((int)48, (EnumExtendedInventorySlot)EnumExtendedInventorySlot.THERMAL_BOOTS, (ItemStack)new ItemStack(GSItems.THERMAL_PADDING_3, 1, 3));
        GalacticraftRegistry.registerGear((int)49, (EnumExtendedInventorySlot)EnumExtendedInventorySlot.THERMAL_HELMET, (ItemStack)new ItemStack(GSItems.THERMAL_PADDING_4, 1, 0));
        GalacticraftRegistry.registerGear((int)50, (EnumExtendedInventorySlot)EnumExtendedInventorySlot.THERMAL_CHESTPLATE, (ItemStack)new ItemStack(GSItems.THERMAL_PADDING_4, 1, 1));
        GalacticraftRegistry.registerGear((int)51, (EnumExtendedInventorySlot)EnumExtendedInventorySlot.THERMAL_LEGGINGS, (ItemStack)new ItemStack(GSItems.THERMAL_PADDING_4, 1, 2));
        GalacticraftRegistry.registerGear((int)52, (EnumExtendedInventorySlot)EnumExtendedInventorySlot.THERMAL_BOOTS, (ItemStack)new ItemStack(GSItems.THERMAL_PADDING_4, 1, 3));
        if (GSConfigDimensions.enableVenusSpaceStation) {
            GSDimensions.VENUS_SS = GalacticraftRegistry.registerDimension((String)"Venus Space Station", (String)"_venus_orbit", (int)GSConfigDimensions.idDimensionVenusOrbit, WorldProviderVenusSS.class, (boolean)false);
            if (GSDimensions.VENUS_SS == null) {
                GalaxySpace.instance.debug("Failed to register space station dimension type with ID " + GSConfigDimensions.idDimensionVenusOrbit);
            }
            GSDimensions.VENUS_SS_KEEPLOADED = GalacticraftRegistry.registerDimension((String)"Venus Space Station", (String)"_venus_orbit", (int)GSConfigDimensions.idDimensionVenusOrbitStatic, WorldProviderVenusSS.class, (boolean)true);
        }
    }

    private static void registerDungeonLoot() {
        GalacticraftRegistry.addDungeonLoot((int)1, (ItemStack)new ItemStack(GSItems.BASIC, 1, 10));
        GalacticraftRegistry.addDungeonLoot((int)1, (ItemStack)new ItemStack(GSItems.SCHEMATICS, 1, 5));
        GalacticraftRegistry.getDungeonLoot((int)2).clear();
        GalacticraftRegistry.addDungeonLoot((int)2, (ItemStack)new ItemStack(MarsItems.schematic, 1, 1));
        GalacticraftRegistry.addDungeonLoot((int)2, (ItemStack)new ItemStack(MarsItems.schematic, 1, 2));
        GalacticraftRegistry.addDungeonLoot((int)2, (ItemStack)new ItemStack(GSItems.BASIC, 1, 10));
        GalacticraftRegistry.addDungeonLoot((int)4, (ItemStack)new ItemStack(GSItems.BASIC, 1, 16));
        GalacticraftRegistry.addDungeonLoot((int)4, (ItemStack)new ItemStack(GSItems.BASIC, 1, 18));
        GalacticraftRegistry.addDungeonLoot((int)4, (ItemStack)new ItemStack(GSItems.GEOLOGICAL_SCANNER, 1, 100));
        GalacticraftRegistry.addDungeonLoot((int)5, (ItemStack)new ItemStack(GSItems.ROCKET_MODULES, 1, 4));
        GalacticraftRegistry.addDungeonLoot((int)5, (ItemStack)new ItemStack(GSItems.ROCKET_MODULES, 1, 6));
    }

    private static void registrycelestial() {
        BodiesData data = new BodiesData(IAdvancedSpace.TypeBody.STAR, IAdvancedSpace.ClassBody.DWARF).setStarColor(IAdvancedSpace.StarColor.YELLOW);
        BodiesRegistry.registerBodyData((CelestialBody)GalacticraftCore.solarSystemSol.getMainStar(), (BodiesData)data);
        data = new BodiesData(null, BodiesRegistry.calculateGravity((float)8.88f), 92, 182000L, false);
        BodiesRegistry.registerBodyData((CelestialBody)VenusModule.planetVenus, (BodiesData)data);
        data = new BodiesData(null, BodiesRegistry.calculateGravity((float)10.0f), 1, 24000L, false);
        BodiesRegistry.registerBodyData((CelestialBody)GalacticraftCore.planetOverworld, (BodiesData)data);
        data = new BodiesData(null, BodiesRegistry.calculateGravity((float)5.37f), 0, 24660L, false);
        BodiesRegistry.registerBodyData((CelestialBody)MarsModule.planetMars, (BodiesData)data);
        data = new BodiesData(IAdvancedSpace.ClassBody.ASTEROID, 0.0f, 0, 0L, true);
        BodiesRegistry.registerBodyData((CelestialBody)AsteroidsModule.planetAsteroids, (BodiesData)data);
        data = new BodiesData(null, 0.062f, 0, 192000L, false);
        BodiesRegistry.registerBodyData((CelestialBody)GalacticraftCore.moonMoon, (BodiesData)data);
        BodiesData unreachableData = new BodiesData(null, 0.0f, 0, 0L, false);
        BodiesRegistry.registerBodyData((CelestialBody)oberonUranus, (BodiesData)unreachableData);
        BodiesRegistry.registerBodyData((CelestialBody)proteusNeptune, (BodiesData)unreachableData);
        BodiesRegistry.registerBodyData((CelestialBody)mimasSaturn, (BodiesData)unreachableData);
        BodiesRegistry.registerBodyData((CelestialBody)tethysSaturn, (BodiesData)unreachableData);
        BodiesRegistry.registerBodyData((CelestialBody)dioneSaturn, (BodiesData)unreachableData);
        BodiesRegistry.registerBodyData((CelestialBody)rheyaSaturn, (BodiesData)unreachableData);
        BodiesRegistry.registerBodyData((CelestialBody)iapetusSaturn, (BodiesData)unreachableData);
        BodiesRegistry.registerBodyData((CelestialBody)arielUranus, (BodiesData)unreachableData);
        BodiesRegistry.registerBodyData((CelestialBody)umbrielUranus, (BodiesData)unreachableData);
        BodiesRegistry.registerBodyData((CelestialBody)titaniaUranus, (BodiesData)unreachableData);
        BodiesRegistry.registerBodyData((CelestialBody)charonPluto, (BodiesData)unreachableData);
    }

    private static void registryteleport() {
        GalacticraftRegistry.registerTeleportType(WorldProviderMercury.class, (ITeleportType)new TeleportTypeMercury());
        if (GSConfigCore.enableWorldEngine && GSConfigCore.enableMarsWorldEngine) {
            GalacticraftRegistry.registerTeleportType(WorldProviderMars_WE.class, (ITeleportType)new TeleportTypeMars());
        }
        GalacticraftRegistry.registerTeleportType(WorldProviderCeres.class, (ITeleportType)new TeleportTypeCeres());
        GalacticraftRegistry.registerTeleportType(WorldProviderPluto.class, (ITeleportType)new TeleportTypePluto());
        GalacticraftRegistry.registerTeleportType(WorldProviderKuiperBelt.class, (ITeleportType)new TeleportTypeKuiperBelt());
        GalacticraftRegistry.registerTeleportType(WorldProviderHaumea_WE.class, (ITeleportType)new TeleportTypeHaumea());
        GalacticraftRegistry.registerTeleportType(WorldProviderIo.class, (ITeleportType)new TeleportTypeIo());
        GalacticraftRegistry.registerTeleportType(WorldProviderEuropa_WE.class, (ITeleportType)new TeleportTypeEuropa());
        GalacticraftRegistry.registerTeleportType(WorldProviderGanymede.class, (ITeleportType)new TeleportTypeGanymede());
        GalacticraftRegistry.registerTeleportType(WorldProviderCallisto.class, (ITeleportType)new TeleportTypeCallisto());
        GalacticraftRegistry.registerTeleportType(GSConfigCore.enableWorldEngine ? WorldProviderEnceladus_WE.class : WorldProviderEnceladus.class, (ITeleportType)new TeleportTypeEnceladus());
        GalacticraftRegistry.registerTeleportType(WorldProviderTitan.class, (ITeleportType)new TeleportTypeTitan());
        GalacticraftRegistry.registerTeleportType(WorldProviderMiranda.class, (ITeleportType)new TeleportTypeMiranda());
        GalacticraftRegistry.registerTeleportType(WorldProviderTriton_WE.class, (ITeleportType)new TeleportTypeTriton());
        if (GSConfigDimensions.enableVenusSpaceStation) {
            GalaxyRegistry.registerSatellite((Satellite)venusSpaceStation);
            GalacticraftRegistry.registerTeleportType(WorldProviderVenusSS.class, (ITeleportType)new TeleportTypeVenusSS());
        }
    }

    public void postInit(FMLPostInitializationEvent event) {
        ItemSchematics.registerSchematicItems();
        GSDimensions.MERCURY = WorldUtil.getDimensionTypeById((int)GSConfigDimensions.dimensionIDMercury);
        GSDimensions.CERES = WorldUtil.getDimensionTypeById((int)GSConfigDimensions.dimensionIDCeres);
        GSDimensions.PLUTO = WorldUtil.getDimensionTypeById((int)GSConfigDimensions.dimensionIDPluto);
        GSDimensions.IO = WorldUtil.getDimensionTypeById((int)GSConfigDimensions.dimensionIDIo);
        GSDimensions.EUROPA = WorldUtil.getDimensionTypeById((int)GSConfigDimensions.dimensionIDEuropa);
        GSDimensions.GANYMEDE = WorldUtil.getDimensionTypeById((int)GSConfigDimensions.dimensionIDGanymede);
        GSDimensions.CALLISTO = WorldUtil.getDimensionTypeById((int)GSConfigDimensions.dimensionIDCallisto);
        GSDimensions.ENCELADUS = WorldUtil.getDimensionTypeById((int)GSConfigDimensions.dimensionIDEnceladus);
        GSDimensions.TITAN = WorldUtil.getDimensionTypeById((int)GSConfigDimensions.dimensionIDTitan);
        GSDimensions.MIRANDA = WorldUtil.getDimensionTypeById((int)GSConfigDimensions.dimensionIDMiranda);
        GSDimensions.TRITON = WorldUtil.getDimensionTypeById((int)GSConfigDimensions.dimensionIDTriton);
        GSDimensions.KUIPER_BELT = WorldUtil.getDimensionTypeById((int)GSConfigDimensions.dimensionIDKuiperBelt);
        GSDimensions.HAUMEA = WorldUtil.getDimensionTypeById((int)GSConfigDimensions.dimensionIDHaumea);
        if (event.getSide() == Side.CLIENT) {
            ResourceLocation img;
            for (Map.Entry bodies : GalaxyRegistry.getRegisteredPlanets().entrySet()) {
                img = new ResourceLocation("galaxyspace:textures/gui/backgrounds/bg_" + ((Planet)bodies.getValue()).getName() + ".png");
                try {
                    if (Minecraft.func_71410_x().func_110442_L().func_110536_a(img) == null) continue;
                    BodiesRegistry.addTeleportData((int)((Planet)bodies.getValue()).getDimensionID(), (ResourceLocation)img);
                }
                catch (IOException iOException) {}
            }
            for (Map.Entry bodies : GalaxyRegistry.getRegisteredMoons().entrySet()) {
                img = new ResourceLocation("galaxyspace:textures/gui/backgrounds/bg_" + ((Moon)bodies.getValue()).getName() + ".png");
                try {
                    if (Minecraft.func_71410_x().func_110442_L().func_110536_a(img) == null) continue;
                    BodiesRegistry.addTeleportData((int)((Moon)bodies.getValue()).getDimensionID(), (ResourceLocation)img);
                }
                catch (IOException iOException) {}
            }
        }
        GalaxyRegistry.refreshGalaxies();
    }

    private static void registerRecipesWorkBench() {
        SchematicConeRecipe.registerRecipeWorkBench();
        SchematicBodyRecipe.registerRecipeWorkBench();
        SchematicEngineRecipe.registerRecipeWorkBench();
        SchematicBoosterRecipe.registerRecipeWorkBench();
        SchematicFinsRecipe.registerRecipeWorkBench();
        SchematicOxTankRecipe.registerRecipeWorkBench();
        SchematicTier2Recipe.registerRecipeWorkBench();
    }

    public void registerRender() {
    }

    public void registerVariant() {
    }

    public void registerRecipes() {
        CraftingRecipesMercury.loadRecipes();
        CraftingRecipesOverworld.loadRecipes();
        CraftingRecipesMars.loadRecipes();
        CraftingRecipesHaumea.loadRecipes();
        CraftingRecipesIo.loadRecipes();
        CraftingRecipesEuropa.loadRecipes();
        CraftingRecipesGanymede.loadRecipes();
        CraftingRecipesMiranda.loadRecipes();
        SolarSystemBodies.registerRecipesWorkBench();
        HashMap<String, Integer> spaceStationRequirements = new HashMap<String, Integer>(6, 1.0f);
        spaceStationRequirements.put("ingotTin", 32);
        spaceStationRequirements.put("ingotCopper", 64);
        spaceStationRequirements.put((String)new ItemStack(GCItems.basicItem, 1, 14), 1);
        spaceStationRequirements.put((String)Items.field_151042_j, 24);
        spaceStationRequirements.put((String)new ItemStack(GSItems.HDP, 1, 0), 10);
        spaceStationRequirements.put((String)new ItemStack(GSItems.BASIC, 1, 6), 10);
        if (GSConfigDimensions.enableVenusSpaceStation) {
            GalacticraftRegistry.registerSpaceStation((SpaceStationType)new SpaceStationType(GSConfigDimensions.idDimensionVenusOrbit, ConfigManagerVenus.dimensionIDVenus, new SpaceStationRecipe(spaceStationRequirements)));
        }
    }

    public boolean canRegister() {
        return true;
    }

    public int getPriority() {
        return 100;
    }

    static {
        planetJupiter = GalacticraftCore.planetJupiter;
        planetSaturn = GalacticraftCore.planetSaturn;
        planetUranus = GalacticraftCore.planetUranus;
        planetNeptune = GalacticraftCore.planetNeptune;
    }
}

