/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blast;

import icbm.classic.ICBMClassic;
import icbm.classic.api.caps.IMissile;
import icbm.classic.api.events.BlastBuildEvent;
import icbm.classic.api.explosion.BlastState;
import icbm.classic.api.explosion.IBlastInit;
import icbm.classic.api.explosion.IBlastRestore;
import icbm.classic.api.explosion.IBlastTickable;
import icbm.classic.api.reg.IExplosiveData;
import icbm.classic.config.ConfigBlast;
import icbm.classic.config.ConfigDebug;
import icbm.classic.content.blast.BlastRedmatter;
import icbm.classic.content.blast.thread.ThreadExplosion;
import icbm.classic.content.blast.threaded.BlastAntimatter;
import icbm.classic.content.entity.EntityExplosion;
import icbm.classic.lib.explosive.ExplosiveHandler;
import icbm.classic.lib.transform.vector.Location;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class Blast
extends Explosion
implements IBlastInit,
IBlastRestore {
    private ThreadExplosion thread;
    private ConcurrentLinkedQueue<BlockPos> threadResults;
    private boolean threadComplete = false;
    public Location location;
    public Entity controller = null;
    public boolean isAlive = true;
    protected int callCount = 0;
    private boolean hasSetupBlast = false;
    private boolean hasBuilt = false;
    private IExplosiveData explosiveData;

    public Blast() {
        super(null, null, 0.0, 0.0, 0.0, 0.0f, false, false);
    }

    @Override
    public IExplosiveData getExplosiveData() {
        return this.explosiveData;
    }

    @Override
    public BlastState runBlast() {
        try {
            if (!this.world().field_72995_K) {
                if (ForgeEventFactory.onExplosionStart((World)this.field_77287_j, (Explosion)this)) {
                    return BlastState.FORGE_EVENT_CANCEL;
                }
                this.playExplodeSound();
                if (this instanceof IBlastTickable) {
                    if (!this.world().func_72838_d((Entity)new EntityExplosion(this))) {
                        ICBMClassic.logger().error(this + " Failed to spawn explosion entity to control blast.");
                        this.isAlive = false;
                        return BlastState.ERROR;
                    }
                    return BlastState.TRIGGERED;
                }
                if (!this.doFirstSetup()) {
                    return BlastState.FORGE_EVENT_CANCEL;
                }
                if (this.doExplode(-1)) {
                    this.completeBlast();
                }
            } else {
                this.clientRunBlast();
            }
            return BlastState.TRIGGERED;
        }
        catch (Exception e) {
            ICBMClassic.logger().error(this + ": Unexpected error running blast", (Throwable)e);
            return BlastState.ERROR;
        }
    }

    protected void clientRunBlast() {
    }

    public boolean onBlastTick(int ticksExisted) {
        if (!this.field_77287_j.field_72995_K) {
            if (!this.doFirstSetup()) {
                return false;
            }
            if (this.isAlive && (this.isCompleted() || this.doExplode(this.callCount++))) {
                this.completeBlast();
                return true;
            }
        }
        return false;
    }

    public final boolean doFirstSetup() {
        if (this.isAlive && !this.hasSetupBlast) {
            this.hasSetupBlast = true;
            ExplosiveHandler.add(this);
            return this.setupBlast();
        }
        return true;
    }

    protected boolean setupBlast() {
        return true;
    }

    protected boolean doExplode(int callCount) {
        return false;
    }

    public final void completeBlast() {
        if (this.isAlive) {
            this.isAlive = false;
            ExplosiveHandler.remove(this);
            this.onBlastCompleted();
        }
    }

    protected void onBlastCompleted() {
    }

    public void onPositionUpdate(double posX, double posY, double posZ) {
        this.setPosition(posX, posY, posZ);
    }

    public Blast setPosition(double posX, double posY, double posZ) {
        this.field_77284_b = posX;
        this.field_77285_c = posY;
        this.field_77282_d = posZ;
        this.location = new Location(this.field_77287_j, posX, posY, posZ);
        return this;
    }

    public Vec3d getPosition() {
        return this.location.toVec3d();
    }

    public void func_77278_a() {
        ICBMClassic.logger().error("Blast#doExplosionA() -> Something called the vanilla explosion method. This is not a supported behavior for ICBM explosions. Blast: " + this, (Throwable)new RuntimeException());
    }

    public void func_77279_a(boolean par1) {
        ICBMClassic.logger().error("Blast#doExplosionB(" + par1 + ") -> Something called the vanilla explosion method. This is not a supported behavior for ICBM explosions. Blast: " + this, (Throwable)new RuntimeException());
    }

    protected void playExplodeSound() {
        this.field_77287_j.func_184148_a((EntityPlayer)null, this.field_77284_b, this.field_77285_c, this.field_77282_d, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.field_77287_j.field_73012_v.nextFloat() - this.field_77287_j.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
    }

    @Override
    public float getBlastRadius() {
        return Math.max(3.0f, this.field_77280_f);
    }

    protected boolean doDamageEntities(float radius, float power) {
        return this.doDamageEntities(radius, power, true);
    }

    protected boolean doDamageEntities(float radius, float power, boolean destroyItem) {
        Location minCoord = (Location)this.location.add(-(radius *= 2.0f) - 1.0f);
        Location maxCoord = (Location)this.location.add(radius + 1.0f);
        List allEntities = this.world().func_72872_a(Entity.class, new AxisAlignedBB((double)minCoord.xi(), (double)minCoord.yi(), (double)minCoord.zi(), (double)maxCoord.xi(), (double)maxCoord.yi(), (double)maxCoord.zi()));
        Vec3d var31 = new Vec3d(this.location.x(), this.location.y(), this.location.z());
        if (!ConfigBlast.ANTIMATTER_BLOCK_AND_ENT_DAMAGE_ON_REDMATTER && this instanceof BlastAntimatter) {
            allEntities.sort((e1, e2) -> {
                if (e2 instanceof EntityExplosion && ((EntityExplosion)((Object)e2)).getBlast() instanceof BlastRedmatter) {
                    return 1;
                }
                return -1;
            });
            if (this.onDamageEntity((Entity)allEntities.get(0))) {
                return false;
            }
        }
        for (int i = 0; i < allEntities.size(); ++i) {
            double distance;
            Entity entity = (Entity)allEntities.get(i);
            if (this.onDamageEntity(entity)) continue;
            if (entity instanceof IMissile) {
                ((IMissile)entity).destroyMissile(true);
                continue;
            }
            if (entity instanceof EntityItem && !destroyItem || !((distance = entity.func_70011_f(this.location.x(), this.location.y(), this.location.z()) / (double)radius) <= 1.0)) continue;
            double xDifference = entity.field_70165_t - this.location.x();
            double yDifference = entity.field_70163_u - this.location.y();
            double zDifference = entity.field_70161_v - this.location.z();
            double var35 = MathHelper.func_76133_a((double)(xDifference * xDifference + yDifference * yDifference + zDifference * zDifference));
            xDifference /= var35;
            yDifference /= var35;
            zDifference /= var35;
            double var34 = this.world().func_72842_a(var31, entity.func_174813_aQ());
            double var36 = (1.0 - distance) * var34;
            int damage = 0;
            damage = (int)((var36 * var36 + var36) / 2.0 * 8.0 * (double)power + 1.0);
            entity.func_70097_a(DamageSource.func_94539_a((Explosion)this), (float)damage);
            entity.field_70159_w += xDifference * var36;
            entity.field_70181_x += yDifference * var36;
            entity.field_70179_y += zDifference * var36;
        }
        return true;
    }

    protected boolean onDamageEntity(Entity entity) {
        return false;
    }

    @Override
    public void load(NBTTagCompound nbt) {
        this.callCount = nbt.func_74762_e("callCount");
        this.field_77280_f = nbt.func_74760_g("explosionSize");
        if (this.field_77287_j instanceof WorldServer) {
            this.field_77283_e = ((WorldServer)this.field_77287_j).func_175733_a(nbt.func_186857_a("blastExpEntId"));
        }
    }

    @Override
    public void save(NBTTagCompound nbt) {
        nbt.func_74768_a("callCount", this.callCount);
        nbt.func_74776_a("explosionSize", this.field_77280_f);
        if (this.field_77287_j instanceof WorldServer) {
            nbt.func_186854_a("blastExpEntId", this.field_77283_e.func_110124_au());
        }
    }

    public boolean isMovable() {
        return false;
    }

    @Override
    public World world() {
        return this.field_77287_j;
    }

    @Override
    public double x() {
        return this.location.x();
    }

    @Override
    public double y() {
        return this.location.y();
    }

    @Override
    public double z() {
        return this.location.z();
    }

    @Override
    public Entity getBlastSource() {
        return this.getBlastSource();
    }

    protected void createAndStartThread(ThreadExplosion thread) {
        if (ConfigDebug.DEBUG_THREADS) {
            ICBMClassic.logger().info("Blast#createAndStartThread(" + thread + ") -> Thread set");
        }
        if (this.thread != null && !this.thread.isComplete) {
            ICBMClassic.logger().info("Blast#createAndStartThread(" + thread + ") -> Error new thread was set before last finished\nLast: " + thread);
        }
        this.thread = thread;
        this.threadComplete = false;
        this.thread.start();
        if (ConfigDebug.DEBUG_THREADS) {
            ICBMClassic.logger().info("Blast#createAndStartThread(" + thread + ") -> Thread started: " + thread.isAlive());
        }
    }

    protected boolean isThreadCompleted() {
        return this.threadComplete || this.thread != null && this.thread.isComplete;
    }

    public synchronized void markThreadCompleted(ThreadExplosion exThread) {
        if (ConfigDebug.DEBUG_THREADS) {
            ICBMClassic.logger().info("Blast#markThreadCompleted(" + exThread + ") -> Thread responded that is has completed, Blast: " + this);
        }
        if (this.thread == null || this.thread == exThread) {
            this.threadComplete = true;
        } else {
            ICBMClassic.logger().info("Blast#markThreadCompleted(" + exThread + ") -> Error thread attempted to mark for complete but did not match current thread \nCurrent: " + this.thread + "\nBlast: " + this);
        }
    }

    public void addThreadResult(BlockPos pos) {
        this.getThreadResults().add(pos);
    }

    protected ConcurrentLinkedQueue getThreadResults() {
        if (this.threadResults == null) {
            this.threadResults = new ConcurrentLinkedQueue();
        }
        return this.threadResults;
    }

    public ThreadExplosion getThread() {
        return this.thread;
    }

    @Override
    public IBlastInit setBlastSource(Entity entity) {
        this.checkBuilt();
        this.field_77283_e = entity;
        return this;
    }

    @Override
    public Blast setBlastSize(double power) {
        this.checkBuilt();
        this.field_77280_f = (float)power;
        return this;
    }

    @Override
    public Blast scaleBlast(double scale) {
        this.checkBuilt();
        this.field_77280_f = (float)((double)this.field_77280_f * scale);
        return this;
    }

    @Override
    public Blast setBlastWorld(World world) {
        this.checkBuilt();
        this.field_77287_j = world;
        return this;
    }

    @Override
    public Blast setBlastPosition(double posX, double posY, double posZ) {
        this.checkBuilt();
        this.setPosition(posX, posY, posZ);
        return this;
    }

    @Override
    public IBlastInit setExplosiveData(IExplosiveData data) {
        this.checkBuilt();
        this.explosiveData = data;
        return this;
    }

    @Override
    public IBlastInit setCustomData(@Nonnull NBTTagCompound customData) {
        return this;
    }

    @Override
    public boolean isCompleted() {
        return !this.isAlive;
    }

    @Override
    public IBlastInit setEntityController(Entity entityController) {
        this.controller = entityController;
        return this;
    }

    @Override
    @Nullable
    public Entity getController() {
        return this.controller;
    }

    private final void checkBuilt() {
        if (this.hasBuilt) {
            throw new RuntimeException("Can not init properties of a blast after it has built");
        }
    }

    @Override
    public Blast buildBlast() {
        if (this.hasBuilt) {
            throw new RuntimeException("Blast has already been built");
        }
        MinecraftForge.EVENT_BUS.post((Event)new BlastBuildEvent(this));
        this.hasBuilt = true;
        return this;
    }

    @Override
    public void clearBlast() {
        if (this.getThread() != null) {
            this.getThread().kill();
        }
        this.isAlive = false;
    }
}

