/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blast.threaded;

import icbm.classic.content.blast.Blast;
import icbm.classic.lib.explosive.ThreadWorkBlast;
import icbm.classic.lib.thread.IThreadWork;
import icbm.classic.lib.thread.WorkerThreadManager;
import icbm.classic.lib.transform.BlockEditHandler;
import icbm.classic.lib.transform.PosDistanceSorter;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;

public abstract class BlastThreaded
extends Blast {
    private boolean hasThreadStarted = false;

    protected IThreadWork getWorkerTask() {
        return new ThreadWorkBlast((steps, edits) -> this.doRun((int)steps, (Consumer<BlockPos>)edits), edits -> this.onWorkerThreadComplete((List<BlockPos>)edits));
    }

    public abstract boolean doRun(int var1, Consumer<BlockPos> var2);

    protected Comparator<BlockPos> buildSorter() {
        return new PosDistanceSorter(this.location, false);
    }

    protected void onPostThreadJoinWorld() {
        this.doExplode(-1);
        this.onBlastCompleted();
    }

    protected void onWorkerThreadComplete(List<BlockPos> edits) {
        if (this.field_77287_j instanceof WorldServer) {
            edits.sort(this.buildSorter());
            ((WorldServer)this.field_77287_j).func_152344_a(() -> {
                if (this.skipQueue()) {
                    edits.forEach(blockPos -> this.destroyBlock((BlockPos)blockPos));
                } else {
                    BlockEditHandler.queue(this.field_77287_j, edits, blockPos -> this.destroyBlock((BlockPos)blockPos));
                }
                this.onPostThreadJoinWorld();
            });
        }
    }

    protected boolean skipQueue() {
        return false;
    }

    @Override
    protected boolean doExplode(int callCount) {
        if (!this.hasThreadStarted) {
            this.hasThreadStarted = true;
            WorkerThreadManager.INSTANCE.addWork(this.getWorkerTask());
        }
        return false;
    }

    @Override
    protected void onBlastCompleted() {
    }

    public void destroyBlock(BlockPos pos) {
        IBlockState state = this.world().func_180495_p(pos);
        if (!state.func_177230_c().isAir(state, (IBlockAccess)this.world(), pos)) {
            state.func_177230_c().onBlockExploded(this.world(), pos, (Explosion)this);
        }
    }
}

