/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blocks.launcher.screen;

import com.builtbroken.jlib.data.vector.IPos3D;
import icbm.classic.api.EnumTier;
import icbm.classic.api.tile.IRadioWaveSender;
import icbm.classic.config.ConfigLauncher;
import icbm.classic.content.blocks.launcher.TileLauncherPrefab;
import icbm.classic.content.blocks.launcher.base.TileLauncherBase;
import icbm.classic.content.blocks.launcher.screen.ContainerLaunchScreen;
import icbm.classic.content.blocks.launcher.screen.GuiLauncherScreen;
import icbm.classic.lib.LanguageUtility;
import icbm.classic.lib.network.IPacket;
import icbm.classic.lib.network.IPacketIDReceiver;
import icbm.classic.lib.network.packet.PacketTile;
import icbm.classic.lib.transform.vector.Pos;
import icbm.classic.prefab.FakeRadioSender;
import icbm.classic.prefab.inventory.ExternalInventory;
import icbm.classic.prefab.inventory.IInventoryProvider;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;

public class TileLauncherScreen
extends TileLauncherPrefab
implements IPacketIDReceiver,
IInventoryProvider<ExternalInventory> {
    public TileLauncherBase launcherBase = null;
    public static final int DESCRIPTION_PACKET_ID = 0;
    public static final int SET_FREQUENCY_PACKET_ID = 1;
    public static final int SET_TARGET_PACKET_ID = 2;
    public static final int LOCK_HEIGHT_PACKET_ID = 3;
    public static final int LAUNCH_PACKET_ID = 4;
    public short lockHeight = (short)3;
    public ExternalInventory inventory;
    public int launchDelay = 0;

    @Override
    public ExternalInventory getInventory() {
        if (this.inventory == null) {
            this.inventory = new ExternalInventory(this, 2);
        }
        return this.inventory;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.launcherBase == null || this.launcherBase.func_145837_r()) {
            this.launcherBase = null;
            for (EnumFacing rotation : EnumFacing.field_176754_o) {
                Pos position = (Pos)new Pos((IPos3D)this).add(rotation);
                TileEntity tileEntity = position.getTileEntity((IBlockAccess)this.field_145850_b);
                if (tileEntity == null || !(tileEntity instanceof TileLauncherBase)) continue;
                this.launcherBase = (TileLauncherBase)tileEntity;
                if (!this.isServer()) continue;
                this.setRotation(rotation.func_176734_d());
                this.updateClient = true;
            }
        }
        if (this.isServer()) {
            if (this.launchDelay > 0) {
                --this.launchDelay;
            } else if (this.ticks % 10 == 0 && this.field_145850_b.func_175687_A(this.func_174877_v()) > 0) {
                this.launch();
            }
            if (this.ticks % 3 == 0) {
                this.sendDescPacket();
            }
        }
    }

    @Override
    public PacketTile getDescPacket() {
        return (PacketTile)new PacketTile("desc", 0, this).addData(new Object[]{this.getEnergy(), this.getFrequency(), this.lockHeight, this.getTarget().xi(), this.getTarget().yi(), this.getTarget().zi()});
    }

    @Override
    public PacketTile getGUIPacket() {
        return this.getDescPacket();
    }

    @Override
    public boolean read(ByteBuf data, int id, EntityPlayer player, IPacket packet) {
        if (!super.read(data, id, player, packet)) {
            switch (id) {
                case 0: {
                    if (!this.isClient()) break;
                    this.setEnergy(data.readInt());
                    this.setFrequency(data.readInt());
                    this.lockHeight = data.readShort();
                    this.setTarget(new Pos(data.readInt(), data.readInt(), data.readInt()));
                    return true;
                }
                case 1: {
                    this.setFrequency(data.readInt());
                    return true;
                }
                case 2: {
                    this.setTarget(new Pos(data.readInt(), data.readInt(), data.readInt()));
                    return true;
                }
                case 3: {
                    this.lockHeight = (short)Math.max(Math.min(data.readShort(), Short.MAX_VALUE), 3);
                    return true;
                }
                case 4: {
                    this.launch();
                }
            }
            return false;
        }
        return true;
    }

    public boolean canLaunch() {
        if (this.launcherBase != null && this.launcherBase.getMissileStack() != null && this.checkExtract()) {
            return this.launcherBase.isInRange(this.getTarget());
        }
        return false;
    }

    public boolean launch() {
        if (this.canLaunch() && this.launcherBase.launchMissile(this.getTarget(), this.lockHeight)) {
            switch (this.getTier()) {
                case ONE: {
                    this.launchDelay = ConfigLauncher.LAUNCHER_DELAY_TIER1;
                    break;
                }
                case TWO: {
                    this.launchDelay = ConfigLauncher.LAUNCHER_DELAY_TIER2;
                    break;
                }
                case THREE: {
                    this.launchDelay = ConfigLauncher.LAUNCHER_DELAY_TIER3;
                }
            }
            this.extractEnergy();
            this.updateClient = true;
            return true;
        }
        return false;
    }

    @Override
    public String getStatus() {
        String color = "\u00a74";
        String status = LanguageUtility.getLocal("gui.misc.idle");
        if (this.launcherBase == null) {
            status = LanguageUtility.getLocal("gui.launcherscreen.statusMissing");
        } else if (!this.checkExtract()) {
            status = LanguageUtility.getLocal("gui.launcherscreen.statusNoPower");
        } else if (this.launcherBase.getMissileStack().func_190926_b()) {
            status = LanguageUtility.getLocal("gui.launcherscreen.statusEmpty");
        } else if (this.getTarget() == null) {
            status = LanguageUtility.getLocal("gui.launcherscreen.statusInvalid");
        } else if (this.launcherBase.isTargetTooClose(this.getTarget())) {
            status = LanguageUtility.getLocal("gui.launcherscreen.statusClose");
        } else if (this.launcherBase.isTargetTooFar(this.getTarget())) {
            status = LanguageUtility.getLocal("gui.launcherscreen.statusFar");
        } else {
            color = "\u00a72";
            status = LanguageUtility.getLocal("gui.launcherscreen.statusReady");
        }
        return color + status;
    }

    @Override
    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.lockHeight = par1NBTTagCompound.func_74765_d("targetHeight");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound par1NBTTagCompound) {
        par1NBTTagCompound.func_74777_a("targetHeight", this.lockHeight);
        return super.func_189515_b(par1NBTTagCompound);
    }

    @Override
    public int getEnergyConsumption() {
        switch (this.getTier()) {
            case ONE: {
                return ConfigLauncher.LAUNCHER_POWER_USAGE_TIER1;
            }
            case TWO: {
                return ConfigLauncher.LAUNCHER_POWER_USAGE_TIER2;
            }
        }
        return ConfigLauncher.LAUNCHER_POWER_USAGE_TIER3;
    }

    @Override
    public int getEnergyBufferSize() {
        switch (this.getTier()) {
            case ONE: {
                return ConfigLauncher.LAUNCHER_POWER_CAP_TIER1;
            }
            case TWO: {
                return ConfigLauncher.LAUNCHER_POWER_CAP_TIER2;
            }
        }
        return ConfigLauncher.LAUNCHER_POWER_CAP_TIER3;
    }

    @Override
    public Object getServerGuiElement(int ID, EntityPlayer player) {
        return new ContainerLaunchScreen(player, this);
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player) {
        return new GuiLauncherScreen(player, this);
    }

    @Override
    public void receiveRadioWave(float hz, IRadioWaveSender sender, String messageHeader, Object[] data) {
        if (this.isServer()) {
            int frequency = (int)Math.floor(hz);
            if (this.getTier() == EnumTier.THREE && frequency == this.getFrequency() && this.launcherBase != null) {
                if (messageHeader.equals("activateLauncherWithTarget")) {
                    Pos pos = (Pos)data[0];
                    Pos pos2 = new Pos((IPos3D)this);
                    if (pos2.distance(pos) < this.launcherBase.getRange()) {
                        this.setTarget(pos);
                        this.launch();
                        ((FakeRadioSender)sender).player.func_145747_a((ITextComponent)new TextComponentString("Firing missile at " + pos));
                    }
                } else if (messageHeader.equals("activateLauncher")) {
                    ((FakeRadioSender)sender).player.func_145747_a((ITextComponent)new TextComponentString("Firing missile at " + this.getTarget()));
                    this.launch();
                }
            }
        }
    }
}

