/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blocks.radarstation;

import icbm.classic.api.ICBMClassicHelpers;
import icbm.classic.api.caps.IMissile;
import icbm.classic.api.tile.IRadioWaveSender;
import icbm.classic.content.blocks.radarstation.BlockRadarStation;
import icbm.classic.content.blocks.radarstation.ContainerRadarStation;
import icbm.classic.content.blocks.radarstation.GuiRadarStation;
import icbm.classic.content.blocks.radarstation.RadarObjectType;
import icbm.classic.content.entity.missile.EntityMissile;
import icbm.classic.content.reg.BlockReg;
import icbm.classic.lib.network.IPacket;
import icbm.classic.lib.network.IPacketIDReceiver;
import icbm.classic.lib.network.packet.PacketTile;
import icbm.classic.lib.radar.RadarRegistry;
import icbm.classic.lib.radio.RadioRegistry;
import icbm.classic.lib.transform.region.Cube;
import icbm.classic.lib.transform.vector.Point;
import icbm.classic.lib.transform.vector.Pos;
import icbm.classic.prefab.inventory.ExternalInventory;
import icbm.classic.prefab.inventory.IInventoryProvider;
import icbm.classic.prefab.tile.IGuiTile;
import icbm.classic.prefab.tile.TileFrequency;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class TileRadarStation
extends TileFrequency
implements IPacketIDReceiver,
IRadioWaveSender,
IGuiTile,
IInventoryProvider<ExternalInventory> {
    public static final int MAX_DETECTION_RANGE = 500;
    public static final int GUI_PACKET_ID = 1;
    public static final int SET_SAFETY_RANGE_PACKET_ID = 2;
    public static final int SET_ALARM_RANGE_PACKET_ID = 3;
    public static final int SET_FREQUENCY_PACKET_ID = 4;
    public float rotation = 0.0f;
    public int alarmRange = 100;
    public int safetyRange = 50;
    public boolean emitAll = true;
    public List<Entity> detectedEntities = new ArrayList<Entity>();
    private List<IMissile> incomingMissiles = new ArrayList<IMissile>();
    ExternalInventory inventory;
    protected List<Pos> guiDrawPoints = new ArrayList<Pos>();
    protected RadarObjectType[] types;
    protected boolean updateDrawList = true;

    @Override
    public ExternalInventory getInventory() {
        if (this.inventory == null) {
            this.inventory = new ExternalInventory(this, 2);
        }
        return this.inventory;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.isServer()) {
            boolean shouldBeOn;
            if (this.ticks % 20 == 0) {
                this.sendDescPacket();
            }
            if (this.checkExtract()) {
                if (this.ticks % 3 == 0) {
                    this.doScan();
                }
                if (this.ticks % 20 == 0 && this.incomingMissiles.size() > 0) {
                    RadioRegistry.popMessage(this.field_145850_b, this, this.getFrequency(), "fireAntiMissile", this.incomingMissiles.get(0));
                }
            } else {
                if (this.detectedEntities.size() > 0) {
                    this.field_145850_b.func_175656_a(this.func_174877_v(), this.getBlockState().func_177226_a((IProperty)BlockRadarStation.REDSTONE_PROPERTY, (Comparable)Boolean.valueOf(false)));
                }
                this.incomingMissiles.clear();
                this.detectedEntities.clear();
            }
            boolean bl = shouldBeOn = this.checkExtract() && this.detectedEntities.size() > 0;
            if ((Boolean)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockRadarStation.REDSTONE_PROPERTY) != shouldBeOn) {
                this.field_145850_b.func_175656_a(this.func_174877_v(), this.getBlockState().func_177226_a((IProperty)BlockRadarStation.REDSTONE_PROPERTY, (Comparable)Boolean.valueOf(shouldBeOn)));
                for (EnumFacing facing : EnumFacing.field_176754_o) {
                    BlockPos pos = this.func_174877_v().func_177982_a(facing.func_82601_c(), facing.func_96559_d(), facing.func_82599_e());
                    for (EnumFacing enumfacing : EnumFacing.values()) {
                        this.field_145850_b.func_175685_c(pos.func_177972_a(enumfacing), this.func_145838_q(), false);
                    }
                }
            }
        } else if (this.checkExtract()) {
            if (this.updateDrawList) {
                this.guiDrawPoints.clear();
                for (int i = 0; i < this.detectedEntities.size(); ++i) {
                    Entity entity = this.detectedEntities.get(i);
                    if (entity == null) continue;
                    this.guiDrawPoints.add(new Pos(entity.field_70165_t, entity.field_70161_v, this.types[i].ordinal()));
                }
            }
            this.rotation += 0.08f;
            if (this.rotation > 360.0f) {
                this.rotation = 0.0f;
            }
        } else {
            this.guiDrawPoints.clear();
        }
    }

    @Override
    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != BlockReg.blockRadarStation || newState.func_177230_c() != BlockReg.blockRadarStation;
    }

    private void doScan() {
        this.incomingMissiles.clear();
        this.detectedEntities.clear();
        List<Entity> entities = RadarRegistry.getAllLivingObjectsWithin(this.field_145850_b, (double)this.xi() + 1.5, (double)this.yi() + 0.5, (double)this.zi() + 0.5, Math.min(this.alarmRange, 500));
        block0: for (Entity entity : entities) {
            IMissile newMissile;
            if (!ICBMClassicHelpers.isMissile(entity) || (newMissile = ICBMClassicHelpers.getMissile(entity)) == null || newMissile.getTicksInAir() <= 1) continue;
            if (!this.detectedEntities.contains(entity)) {
                this.detectedEntities.add(entity);
            }
            if (!this.isMissileGoingToHit((EntityMissile)entity)) continue;
            if (this.incomingMissiles.size() > 0) {
                double dist = new Pos(this).distance(newMissile);
                for (int i = 0; i < this.incomingMissiles.size(); ++i) {
                    IMissile missile = this.incomingMissiles.get(i);
                    Pos pos = new Pos(this);
                    if (dist < pos.distance(missile)) {
                        this.incomingMissiles.add(i, missile);
                        continue block0;
                    }
                    if (i != this.incomingMissiles.size() - 1) continue;
                    this.incomingMissiles.add(missile);
                    continue block0;
                }
                continue;
            }
            this.incomingMissiles.add(newMissile);
        }
    }

    public boolean isMissileGoingToHit(EntityMissile missile) {
        if (missile == null) {
            return false;
        }
        if (missile.targetPos == null) {
            double currentDistance;
            Vec3d mpos = new Vec3d((double)missile.xf(), (double)missile.yf(), (double)missile.zf());
            Vec3d rpos = new Vec3d((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p());
            double nextDistance = mpos.func_178787_e(missile.getVelocity().toVec3d()).func_72438_d(rpos);
            return nextDistance < (currentDistance = mpos.func_72438_d(rpos));
        }
        double d = missile.targetPos.distance(this);
        return d < (double)this.safetyRange;
    }

    @Override
    protected PacketTile getGUIPacket() {
        PacketTile packet = new PacketTile("gui", 1, this);
        packet.write(this.alarmRange);
        packet.write(this.safetyRange);
        packet.write(this.getFrequency());
        packet.write(this.detectedEntities.size());
        if (this.detectedEntities.size() > 0) {
            for (Entity entity : this.detectedEntities) {
                if (entity != null && entity.func_70089_S()) {
                    packet.write(entity.func_145782_y());
                    int type = RadarObjectType.OTHER.ordinal();
                    if (entity instanceof EntityMissile) {
                        type = this.isMissileGoingToHit((EntityMissile)entity) ? RadarObjectType.MISSILE_IMPACT.ordinal() : RadarObjectType.MISSILE.ordinal();
                    }
                    packet.write(type);
                    continue;
                }
                packet.write(-1);
                packet.write(0);
            }
        }
        return packet;
    }

    @Override
    public void readDescPacket(ByteBuf buf) {
        super.readDescPacket(buf);
        this.setEnergy(buf.readInt());
    }

    @Override
    public void writeDescPacket(ByteBuf buf) {
        super.writeDescPacket(buf);
        buf.writeInt(this.getEnergy());
    }

    @Override
    public boolean read(ByteBuf data, int ID, EntityPlayer player, IPacket type) {
        if (!super.read(data, ID, player, type)) {
            if (this.field_145850_b.field_72995_K) {
                if (ID == 1) {
                    this.alarmRange = data.readInt();
                    this.safetyRange = data.readInt();
                    this.setFrequency(data.readInt());
                    this.updateDrawList = true;
                    this.types = null;
                    this.detectedEntities.clear();
                    int entityListSize = data.readInt();
                    this.types = new RadarObjectType[entityListSize];
                    for (int i = 0; i < entityListSize; ++i) {
                        Entity entity;
                        int id = data.readInt();
                        if (id != -1 && (entity = this.field_145850_b.func_73045_a(id)) != null) {
                            this.detectedEntities.add(entity);
                        }
                        this.types[i] = RadarObjectType.get(data.readInt());
                    }
                    return true;
                }
            } else if (!this.field_145850_b.field_72995_K) {
                if (ID == 2) {
                    this.safetyRange = data.readInt();
                    return true;
                }
                if (ID == 3) {
                    this.alarmRange = data.readInt();
                    return true;
                }
                if (ID == 4) {
                    this.setFrequency(data.readInt());
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public int getStrongRedstonePower(EnumFacing side) {
        if (this.incomingMissiles.size() > 0) {
            if (this.emitAll) {
                return Math.min(15, 5 + this.incomingMissiles.size());
            }
            for (IMissile incomingMissile : this.incomingMissiles) {
                Point position = new Point(incomingMissile.x(), incomingMissile.y());
                EnumFacing missileTravelDirection = EnumFacing.DOWN;
                double closest = -1.0;
                for (EnumFacing rotation : EnumFacing.field_176754_o) {
                    double dist = position.distance(new Point(this.func_174877_v().func_177958_n() + rotation.func_82601_c(), this.func_174877_v().func_177952_p() + rotation.func_82599_e()));
                    if (!(dist < closest) && !(closest < 0.0)) continue;
                    missileTravelDirection = rotation;
                    closest = dist;
                }
                if (missileTravelDirection.func_176734_d().ordinal() != side.ordinal()) continue;
                return Math.min(15, 5 + this.incomingMissiles.size());
            }
        }
        return 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.safetyRange = nbt.func_74762_e("safetyRadius");
        this.alarmRange = nbt.func_74762_e("alarmRadius");
        this.emitAll = nbt.func_74767_n("emitAll");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74768_a("safetyRadius", this.safetyRange);
        nbt.func_74768_a("alarmRadius", this.alarmRange);
        nbt.func_74757_a("emitAll", this.emitAll);
        return super.func_189515_b(nbt);
    }

    @Override
    public void sendRadioMessage(float hz, String header, Object ... data) {
        RadioRegistry.popMessage(this.field_145850_b, this, hz, header, data);
    }

    @Override
    public Cube getRadioSenderRange() {
        return null;
    }

    @Override
    public Object getServerGuiElement(int ID, EntityPlayer player) {
        return new ContainerRadarStation(player, this);
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player) {
        return new GuiRadarStation(player, this);
    }
}

