/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.items;

import icbm.classic.api.ICBMClassicHelpers;
import icbm.classic.api.reg.IExplosiveData;
import icbm.classic.config.ConfigMain;
import icbm.classic.content.entity.missile.EntityMissile;
import icbm.classic.content.entity.missile.MissileFlightType;
import icbm.classic.content.items.ItemMissile;
import icbm.classic.lib.LanguageUtility;
import icbm.classic.prefab.item.ItemICBMElectrical;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemRocketLauncher
extends ItemICBMElectrical {
    private static final int ENERGY = 1000000;
    private static final int firingDelay = 1000;
    private HashMap<String, Long> clickTimePlayer = new HashMap();

    public ItemRocketLauncher() {
        super("rocketLauncher");
        this.func_185043_a(new ResourceLocation("pulling"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
    }

    public int func_77626_a(ItemStack stack) {
        return Integer.MAX_VALUE;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.BOW;
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            if (this.getEnergy(stack) >= 1000000 || player.field_71075_bZ.field_75098_d) {
                for (int slot = 0; slot < player.field_71071_by.func_70302_i_(); ++slot) {
                    int explosiveID;
                    IExplosiveData exData;
                    ItemStack inventoryStack = player.field_71071_by.func_70301_a(slot);
                    if (inventoryStack == null || !(inventoryStack.func_77973_b() instanceof ItemMissile) || (exData = ICBMClassicHelpers.getExplosive(explosiveID = inventoryStack.func_77952_i(), true)) == null || exData.getTier().ordinal() + 1 > ConfigMain.ROCKET_LAUNCHER_TIER_FIRE_LIMIT && !player.field_71075_bZ.field_75098_d) continue;
                    if (!world.field_72995_K) {
                        EntityMissile entityMissile = new EntityMissile((EntityLivingBase)player);
                        entityMissile.missileType = MissileFlightType.HAND_LAUNCHER;
                        entityMissile.explosiveID = explosiveID;
                        entityMissile.acceleration = 1.0f;
                        entityMissile.capabilityMissile.launchNoTarget();
                        world.func_72838_d((Entity)entityMissile);
                        if (player.func_70093_af()) {
                            player.func_184220_m((Entity)entityMissile);
                            player.func_70095_a(false);
                        }
                        if (!player.field_71075_bZ.field_75098_d) {
                            player.field_71071_by.func_70299_a(slot, ItemStack.field_190927_a);
                            player.field_71069_bz.func_75142_b();
                            this.discharge(stack, 1000000, true);
                        }
                    }
                    this.clickTimePlayer.put(player.func_70005_c_(), System.currentTimeMillis());
                    return;
                }
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand handIn) {
        ItemStack itemstack = player.func_184586_b(handIn);
        long clickMs = System.currentTimeMillis();
        if (this.clickTimePlayer.containsKey(player.func_70005_c_()) && clickMs - this.clickTimePlayer.get(player.func_70005_c_()) < 1000L) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        player.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> list, ITooltipFlag flag) {
        String key = "item.icbmclassic:rocketLauncher.info";
        String translation = LanguageUtility.getLocal("item.icbmclassic:rocketLauncher.info");
        if (translation.contains("%s")) {
            String str = String.format(translation, String.valueOf(ConfigMain.ROCKET_LAUNCHER_TIER_FIRE_LIMIT));
            this.splitAdd(str, list, false, false);
        }
        if (Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.func_184812_l_()) {
            list.add(new TextComponentTranslation("item.icbmclassic:rocketLauncher.info.creative", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.LIGHT_PURPLE)).func_150254_d());
        }
    }
}

