/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item.sigil;

import WayofTime.bloodmagic.core.RegistrarBloodMagicBlocks;
import WayofTime.bloodmagic.item.sigil.ItemSigilHolding;
import WayofTime.bloodmagic.item.sigil.ItemSigilToggleableBase;
import WayofTime.bloodmagic.util.helper.NBTHelper;
import WayofTime.bloodmagic.util.helper.PlayerHelper;
import com.google.common.base.Predicate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class ItemSigilPhantomBridge
extends ItemSigilToggleableBase {
    public static final Predicate<Entity> IS_PHANTOM_ACTIVE = entity -> entity instanceof EntityPlayer && ItemSigilPhantomBridge.isPhantomActive((EntityPlayer)entity);
    public static final String[] CIRCLE7X7 = new String[]{"  XXX  ", " XXXXX ", "XXXXXXX", "XXXXXXX", "XXXXXXX", " XXXXX ", "  XXX  "};
    public static final String[] CIRCLE9X9 = new String[]{"  XXXXX  ", " XXXXXXX ", "XXXXXXXXX", "XXXXXXXXX", "XXXXXXXXX", "XXXXXXXXX", "XXXXXXXXX", " XXXXXXX ", "  XXXXX  "};
    public static final String[] DIAG = new String[]{"XXX   ", "XXXX  ", "XXXXX ", " XXXXX", "  XXXX", "   XXX"};
    private Map<EntityPlayer, Pair<Double, Double>> prevPositionMap = new HashMap<EntityPlayer, Pair<Double, Double>>();

    public ItemSigilPhantomBridge() {
        super("phantom_bridge", 100);
    }

    @Override
    public void onSigilUpdate(ItemStack stack, World world, EntityPlayer player, int itemSlot, boolean isSelected) {
        double playerVelZ;
        Pair<Double, Double> prevPosition;
        double playerVelX;
        double totalVel;
        if (PlayerHelper.isFakePlayer(player)) {
            return;
        }
        if (!this.prevPositionMap.containsKey(player)) {
            this.prevPositionMap.put(player, (Pair<Double, Double>)Pair.of((Object)player.field_70165_t, (Object)player.field_70161_v));
        }
        if (!(player.field_70122_E || player.func_184218_aH() || player.func_70093_af())) {
            this.prevPositionMap.put(player, (Pair<Double, Double>)Pair.of((Object)player.field_70165_t, (Object)player.field_70161_v));
            return;
        }
        int verticalOffset = -1;
        if (player.func_70093_af()) {
            --verticalOffset;
        }
        if ((totalVel = Math.sqrt((playerVelX = player.field_70165_t - (Double)(prevPosition = this.prevPositionMap.get(player)).getLeft()) * playerVelX + (playerVelZ = player.field_70161_v - (Double)prevPosition.getRight()) * playerVelZ)) > 2.0) {
            playerVelX = 0.0;
            playerVelZ = 0.0;
            totalVel = 0.0;
        }
        BlockPos playerPos = player.func_180425_c();
        int posX = playerPos.func_177958_n();
        int posY = playerPos.func_177956_o();
        int posZ = playerPos.func_177952_p();
        if (totalVel >= 0.0 && totalVel < 0.3) {
            ItemSigilPhantomBridge.circleTemplate7x7(posX, posY, posZ, verticalOffset, world);
        } else if (playerVelZ > -0.2 && playerVelZ < 0.2) {
            if (playerVelX > 0.4) {
                if (playerVelX > 1.0) {
                    ItemSigilPhantomBridge.rectangleBridge(posX, posY, posZ, verticalOffset, world, -1, 1, 7, 9);
                }
                ItemSigilPhantomBridge.rectangleBridge(posX, posY, posZ, verticalOffset, world, -2, 2, 1, 6);
            }
            if (playerVelX < -0.4) {
                if (playerVelX < -1.0) {
                    ItemSigilPhantomBridge.rectangleBridge(posX, posY, posZ, verticalOffset, world, 7, 9, -1, 1);
                }
                ItemSigilPhantomBridge.rectangleBridge(posX, posY, posZ, verticalOffset, world, -2, 2, -6, -1);
            }
        } else if (playerVelX > -0.2 && playerVelX < 0.2) {
            if (playerVelZ > 0.4) {
                if (playerVelZ > 1.0) {
                    ItemSigilPhantomBridge.rectangleBridge(posX, posY, posZ, verticalOffset, world, 2, 6, -2, 2);
                }
                ItemSigilPhantomBridge.rectangleBridge(posX, posY, posZ, verticalOffset, world, 1, 6, -2, 2);
            }
            if (playerVelZ < -0.4) {
                if (playerVelZ < -1.0) {
                    ItemSigilPhantomBridge.rectangleBridge(posX, posY, posZ, verticalOffset, world, -9, -7, -1, 1);
                }
                ItemSigilPhantomBridge.rectangleBridge(posX, posY, posZ, verticalOffset, world, -6, -1, -2, 2);
            }
        } else if (playerVelX > 0.2) {
            if (playerVelZ > 0.2) {
                ItemSigilPhantomBridge.templateReaderCustom(posX, posY, posZ, verticalOffset, world, 1, 1, DIAG, false, false);
            } else if (playerVelZ < -0.2) {
                ItemSigilPhantomBridge.templateReaderCustom(posX, posY, posZ, verticalOffset, world, 1, -1, DIAG, false, true);
            }
        } else if (playerVelX < -0.2) {
            if (playerVelZ > 0.2) {
                ItemSigilPhantomBridge.templateReaderCustom(posX, posY, posZ, verticalOffset, world, -1, 1, DIAG, true, true);
            } else if (playerVelZ < -0.2) {
                ItemSigilPhantomBridge.templateReaderCustom(posX, posY, posZ, verticalOffset, world, -1, -1, DIAG, true, false);
            }
        } else {
            ItemSigilPhantomBridge.circleTemplate9x9(posX, posY, posZ, verticalOffset, world);
        }
        this.prevPositionMap.put(player, (Pair<Double, Double>)Pair.of((Object)player.field_70165_t, (Object)player.field_70161_v));
    }

    private static void circleTemplate9x9(int posX, int posY, int posZ, int verticalOffset, World world) {
        int x = -5;
        int z = -5;
        ItemSigilPhantomBridge.templateReader(posX, posY, posZ, verticalOffset, world, z, x, CIRCLE9X9);
    }

    private static void circleTemplate7x7(int posX, int posY, int posZ, int verticalOffset, World world) {
        int x = -4;
        int z = -4;
        ItemSigilPhantomBridge.templateReader(posX, posY, posZ, verticalOffset, world, z, x, CIRCLE7X7);
    }

    private static void rectangleBridge(int posX, int posY, int posZ, int verticalOffset, World world, int startZ, int endZ, int startX, int endX) {
        for (int z = startZ; z <= endZ; ++z) {
            for (int x = startX; x <= endX; ++x) {
                BlockPos blockPos = new BlockPos(posX + x, posY + verticalOffset, posZ + z);
                if (!world.func_175623_d(blockPos)) continue;
                world.func_175656_a(blockPos, RegistrarBloodMagicBlocks.PHANTOM.func_176223_P());
            }
        }
    }

    private static void templateReader(int posX, int posY, int posZ, int verticalOffset, World world, int offsetZ, int offsetX, String[] template) {
        ItemSigilPhantomBridge.templateReaderCustom(posX, posY, posZ, verticalOffset, world, offsetZ, offsetX, template, false, false);
    }

    private static void templateReaderCustom(int posX, int posY, int posZ, int verticalOffset, World world, int offsetZ, int offsetX, String[] template, boolean inverted, boolean XnZ) {
        int x = 0;
        for (String row : template) {
            x = inverted ? --x : ++x;
            int z = 0;
            for (char block : row.toCharArray()) {
                BlockPos blockPos;
                z = inverted && !XnZ || XnZ && !inverted ? --z : ++z;
                if (block != 'X' || !world.func_175623_d(blockPos = new BlockPos(posX + offsetX + x, posY + verticalOffset, posZ + offsetZ + z))) continue;
                world.func_175656_a(blockPos, RegistrarBloodMagicBlocks.PHANTOM.func_176223_P());
            }
        }
    }

    public static boolean isPhantomActive(EntityPlayer entity) {
        for (int i = 0; i < entity.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = entity.field_71071_by.func_70301_a(i);
            if (stack.func_77973_b() instanceof ItemSigilPhantomBridge) {
                return NBTHelper.checkNBT(stack).func_77978_p().func_74767_n("activated");
            }
            if (!(stack.func_77973_b() instanceof ItemSigilHolding)) continue;
            List<ItemStack> inv = ItemSigilHolding.getInternalInventory(stack);
            for (int j = 0; j < 5; ++j) {
                ItemStack invStack = inv.get(j);
                if (!(invStack.func_77973_b() instanceof ItemSigilPhantomBridge)) continue;
                return NBTHelper.checkNBT(invStack).func_77978_p().func_74767_n("activated");
            }
        }
        return false;
    }
}

