/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.network;

import WayofTime.bloodmagic.proxy.ClientProxy;
import WayofTime.bloodmagic.soul.DemonWillHolder;
import WayofTime.bloodmagic.soul.EnumDemonWillType;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DemonAuraPacketProcessor
implements IMessage,
IMessageHandler<DemonAuraPacketProcessor, IMessage> {
    public DemonWillHolder currentWill = new DemonWillHolder();

    public DemonAuraPacketProcessor() {
    }

    public DemonAuraPacketProcessor(DemonWillHolder holder) {
        this.currentWill = holder;
    }

    public void fromBytes(ByteBuf buffer) {
        PacketBuffer buff = new PacketBuffer(buffer);
        for (EnumDemonWillType type : EnumDemonWillType.values()) {
            this.currentWill.willMap.put(type, buff.readDouble());
        }
    }

    public void toBytes(ByteBuf buffer) {
        PacketBuffer buff = new PacketBuffer(buffer);
        for (EnumDemonWillType type : EnumDemonWillType.values()) {
            if (this.currentWill.willMap.containsKey(type)) {
                buff.writeDouble(this.currentWill.willMap.get(type).doubleValue());
                continue;
            }
            buff.writeDouble(0.0);
        }
    }

    public IMessage onMessage(DemonAuraPacketProcessor message, MessageContext ctx) {
        if (ctx.side == Side.CLIENT) {
            message.onMessageFromServer();
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void onMessageFromServer() {
        ClientProxy.currentAura = this.currentWill;
    }
}

