/*
 * Decompiled with CFR 0.152.
 */
package its_meow.openscreens.client.renderer.tileentity;

import its_meow.openscreens.OpenScreens;
import its_meow.openscreens.common.tileentity.TileEntityFlatScreen;
import li.cil.oc.Settings;
import li.cil.oc.integration.util.Wrench;
import li.cil.oc.util.RenderState;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GLContext;

public class RenderFlatScreen
extends TileEntitySpecialRenderer<TileEntityFlatScreen> {
    public double maxRenderDistanceSq = Settings.get().maxScreenTextRenderDistance() * Settings.get().maxScreenTextRenderDistance();
    public double fadeDistanceSq = Settings.get().screenTextFadeStartDistance() * Settings.get().screenTextFadeStartDistance();
    public double fadeRatio = 1.0 / (this.maxRenderDistanceSq - this.fadeDistanceSq);
    public TileEntityFlatScreen screen = null;
    public boolean canUseBlendColor;
    public static final ResourceLocation UP_ARROW = new ResourceLocation(Settings.resourceDomain(), "textures/blocks/overlay/screen_up_indicator.png");

    public RenderFlatScreen() {
        this.canUseBlendColor = GLContext.getCapabilities().OpenGL14;
    }

    public void render(TileEntityFlatScreen te, double x, double y, double z, float partialTicks, int destroyStage, float a) {
        RenderState.checkError((String)(((Object)((Object)this)).getClass().getName() + ".render: entering (aka: wasntme)"));
        this.screen = te;
        if (!this.screen.isOrigin()) {
            return;
        }
        double distance = this.playerDistanceSq() / (double)Math.min(this.screen.width(), this.screen.height());
        if (distance > this.maxRenderDistanceSq) {
            return;
        }
        RenderState.checkError((String)(((Object)((Object)this)).getClass().getName() + ".render: checks"));
        RenderState.pushAttrib();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)255.0f, (float)255.0f);
        RenderState.disableEntityLighting();
        RenderState.makeItBlend();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        RenderState.checkError((String)(((Object)((Object)this)).getClass().getName() + ".render: setup"));
        this.drawOverlay(te);
        RenderState.checkError((String)(((Object)((Object)this)).getClass().getName() + ".render: overlay"));
        if (distance > this.fadeDistanceSq) {
            float alpha = (float)Math.max(0.0, 1.0 - (distance - this.fadeDistanceSq) * this.fadeRatio);
            if (this.canUseBlendColor) {
                GL14.glBlendColor((float)0.0f, (float)0.0f, (float)0.0f, (float)alpha);
                GlStateManager.func_179112_b((int)32771, (int)1);
            }
        }
        RenderState.checkError((String)(((Object)((Object)this)).getClass().getName() + ".render: fade"));
        if (this.screen.buffer().isRenderingEnabled()) {
            this.draw(te);
        }
        RenderState.disableBlend();
        RenderState.enableEntityLighting();
        GlStateManager.func_179121_F();
        RenderState.popAttrib();
        RenderState.checkError((String)(((Object)((Object)this)).getClass().getName() + ".render: leaving"));
    }

    public void transform() {
        switch (this.screen.yaw()) {
            case WEST: {
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case NORTH: {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
        }
        switch (this.screen.pitch()) {
            case DOWN: {
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case UP: {
                GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
        }
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)0.5f);
        GlStateManager.func_179109_b((float)0.0f, (float)this.screen.height(), (float)0.0f);
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
    }

    private void drawOverlay(TileEntityFlatScreen te) {
        ItemStack stack;
        if (!(this.screen.facing() != EnumFacing.UP && this.screen.facing() != EnumFacing.DOWN || (stack = Minecraft.func_71410_x().field_71439_g.func_184614_ca()).func_190926_b() || !Wrench.holdsApplicableWrench((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (BlockPos)this.screen.func_174877_v()) && !OpenScreens.SCREENS.contains(Block.func_149634_a((Item)stack.func_77973_b())))) {
            GlStateManager.func_179094_E();
            this.transform();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179109_b((float)((float)this.screen.width() / 2.0f - 0.5f), (float)((float)this.screen.height() / 2.0f - 0.5f), (float)(te.isBack ? -0.935f : 0.05f));
            Tessellator t = Tessellator.func_178181_a();
            BufferBuilder r = t.func_178180_c();
            r.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            this.func_147499_a(UP_ARROW);
            r.func_181662_b(0.0, 1.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
            r.func_181662_b(1.0, 1.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
            r.func_181662_b(1.0, 0.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
            r.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
            t.func_78381_a();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179121_F();
        }
    }

    private void draw(TileEntityFlatScreen te) {
        RenderState.checkError((String)(((Object)((Object)this)).getClass().getName() + ".draw: entering (aka: wasntme)"));
        float sx = this.screen.width();
        float sy = this.screen.height();
        float tw = sx * 16.0f;
        float th = sy * 16.0f;
        this.transform();
        float border = 0.5f;
        GlStateManager.func_179109_b((float)(sx * border / tw), (float)(sy * border / th), (float)0.0f);
        float isx = sx - border / 8.0f;
        float isy = sy - border / 8.0f;
        float sizeX = this.screen.buffer().renderWidth();
        float sizeY = this.screen.buffer().renderHeight();
        float scaleX = isx / sizeX;
        float scaleY = isy / sizeY;
        if (scaleX > scaleY) {
            GlStateManager.func_179109_b((float)(sizeX * 0.5f * (scaleX - scaleY)), (float)0.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)scaleY, (float)scaleY, (float)1.0f);
        } else {
            GlStateManager.func_179109_b((float)0.0f, (float)(sizeY * 0.5f * (scaleY - scaleX)), (float)0.0f);
            GlStateManager.func_179152_a((float)scaleX, (float)scaleX, (float)1.0f);
        }
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)((te.isBack ? -0.94 : 0.0) + 0.01));
        RenderState.checkError((String)(((Object)((Object)this)).getClass().getName() + ".draw: setup"));
        this.screen.buffer().renderText();
        RenderState.checkError((String)(((Object)((Object)this)).getClass().getName() + ".draw: text"));
    }

    public double playerDistanceSq() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        AxisAlignedBB bounds = this.screen.getRenderBoundingBox();
        double px = player.field_70165_t;
        double py = player.field_70163_u;
        double pz = player.field_70161_v;
        double ex = bounds.field_72336_d - bounds.field_72340_a;
        double ey = bounds.field_72337_e - bounds.field_72338_b;
        double ez = bounds.field_72334_f - bounds.field_72339_c;
        double cx = bounds.field_72340_a + ex * 0.5;
        double cy = bounds.field_72338_b + ey * 0.5;
        double cz = bounds.field_72339_c + ez * 0.5;
        double dx = px - cx;
        double dy = py - cy;
        double dz = pz - cz;
        return RenderFlatScreen.fixDiff(dx, ex) + RenderFlatScreen.fixDiff(dy, ey) + RenderFlatScreen.fixDiff(dz, ez);
    }

    private static double fixDiff(double a, double b) {
        if (a < -b) {
            double d = a + b;
            return d * d;
        }
        if (a > b) {
            double d = a - b;
            return d * d;
        }
        return 0.0;
    }
}

