/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.simplerpc;

import me.hypherionmc.simplerpc.Utils;
import me.hypherionmc.simplerpc.discordutils.RPCEvents;
import me.hypherionmc.simplerpc.gui.ConfigGui;
import me.hypherionmc.simplerpc.util.updater.UpdateEngine;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiDownloadTerrain;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.gui.GuiOptions;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenWorking;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ClientEventHandler {
    public static RPCEvents rpcEvents;
    public UpdateEngine updateEngine;

    public void preinit(FMLPreInitializationEvent event) {
        try {
            String modVersion = Loader.instance().getModList().stream().filter(modContainer -> modContainer.getModId().equalsIgnoreCase("simple-rpc")).findFirst().get().getVersion();
            this.updateEngine = new UpdateEngine("1.12-forge", modVersion.replace("1.12.2-", ""));
            this.updateEngine.runUpdater();
        }
        catch (Exception modVersion) {
            // empty catch block
        }
        GameSettings gameSettings = Minecraft.func_71410_x().field_71474_y;
        rpcEvents = new RPCEvents(new Utils(), Minecraft.func_71410_x().field_71412_D.getAbsolutePath(), gameSettings.field_74363_ab == null ? "en_us" : gameSettings.field_74363_ab);
        rpcEvents.initRPC();
    }

    @SubscribeEvent
    public void guiEvent(GuiOpenEvent event) {
        if (event.getGui() instanceof GuiMainMenu) {
            rpcEvents.setLangCode(Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a());
            rpcEvents.mainMenuRPC();
        }
        if (event.getGui() instanceof GuiMultiplayer) {
            rpcEvents.setLangCode(Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a());
            rpcEvents.serverListRPC();
        }
        if (event.getGui() instanceof GuiScreenWorking || event.getGui() instanceof GuiDownloadTerrain) {
            rpcEvents.setLangCode(Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a());
            rpcEvents.joiningGameRPC();
        }
    }

    @SubscribeEvent
    public void onEvent(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.player.field_70170_p.field_72995_K && event.player.field_70170_p.func_82737_E() % 40L == 0L) {
            rpcEvents.setLangCode(Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a());
            rpcEvents.ingameRPC(Minecraft.func_71410_x().func_71356_B());
        }
    }

    @SubscribeEvent
    public void onJoinEvent(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayerSP && ((EntityPlayerSP)event.getEntity()).func_110124_au().equals(Minecraft.func_71410_x().field_71439_g.func_110124_au())) {
            rpcEvents.setLangCode(Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a());
            rpcEvents.joinGame();
            if (this.updateEngine != null && !this.updateEngine.isUpToDate() && !this.updateEngine.isHasNotified() && RPCEvents.getConfig().general.updater) {
                ((EntityPlayerSP)event.getEntity()).func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "" + TextFormatting.BOLD + "[Simple RPC]: " + TextFormatting.RESET + "" + TextFormatting.GREEN + this.updateEngine.getNEWVER() + " is now available"));
                this.updateEngine.setHasNotified(true);
            }
        }
    }

    @SubscribeEvent
    public void onGuiInit(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.getGui() instanceof GuiOptions) {
            int[] lastX = new int[]{0};
            int[] lastY = new int[]{0};
            event.getButtonList().forEach(bt -> {
                if (bt.field_146128_h > lastX[0]) {
                    lastX[0] = bt.field_146128_h;
                }
                if (bt.field_146129_i > lastY[0]) {
                    lastY[0] = bt.field_146129_i;
                    lastX[0] = bt.field_146128_h;
                }
            });
            GuiButton button = new GuiButton(43, lastX[0], lastY[0] - 25, 200, 20, "Discord Presence");
            if (RPCEvents.getConfig().general.configScreen) {
                event.getButtonList().add(button);
            }
        }
    }

    @SubscribeEvent
    public void onGuiActionPerformed(GuiScreenEvent.ActionPerformedEvent event) {
        if (event.getGui() instanceof GuiOptions && event.getButton().field_146127_k == 43) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new ConfigGui(event.getGui(), RPCEvents.getConfig()));
        }
    }
}

