/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.simplerpc.configuration;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.conversion.ObjectConverter;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.io.File;
import java.io.IOException;
import me.hypherionmc.simplerpc.configuration.ClientConfig;
import me.hypherionmc.simplerpc.configuration.ServerConfig;
import me.hypherionmc.simplerpc.configuration.confighelpers.World;
import me.hypherionmc.simplerpc.util.APIUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigEngine {
    public static int VerNum = 9;
    public static int ServerVerNum = 1;
    private static final Logger LOGGER = LogManager.getLogger(ConfigEngine.class);
    public static String lngCode = "en_us";

    public static ClientConfig loadConfig(String configPath, String langCode) {
        File configFile = ConfigEngine.loadTranslated(configPath, langCode);
        try {
            ConfigEngine.migrateOldConfigs(configPath);
        }
        catch (Exception e) {
            LOGGER.error("Could not migrate old config format!");
            e.printStackTrace();
        }
        lngCode = langCode;
        ClientConfig config = null;
        if (configFile.exists()) {
            configFile = ConfigEngine.migrateOldConfig(configFile);
        }
        if ((config = ConfigEngine.loadConfig(configFile)) == null) {
            LOGGER.error("Could not load config file. Something went wrong!");
        }
        config.configPath = configFile.getAbsolutePath();
        return config;
    }

    private static File loadDefault(String configPath) {
        File confDir = new File(configPath + "/config/");
        File configFile = new File(configPath + "/config/simple-rpc.toml");
        if (!confDir.exists()) {
            confDir.mkdirs();
        }
        if (!configFile.exists()) {
            ClientConfig conf = new ClientConfig();
            conf.world_images.worlds.add(new World("overworld", "overworld", "In the Overworld", "mclogo", "%mods% mods installed"));
            conf.world_images.worlds.add(new World("the_nether", "nether", "In the Nether", "mclogo", "%mods% mods installed"));
            conf.world_images.worlds.add(new World("the_end", "end", "In the End", "mclogo", "%mods% mods installed"));
            ConfigEngine.saveConfig(conf, configFile);
            LOGGER.warn("A config file has been created.\nPlease edit " + configFile.getAbsolutePath() + " to specify your RPC details");
        }
        return configFile;
    }

    private static File loadTranslated(String configPath, String langCode) {
        File configFile;
        File langDir = new File(configPath + "/simple-rpc/");
        if (!langDir.exists()) {
            langDir.mkdirs();
        }
        if (!(configFile = new File(langDir + "/simple-rpc_" + langCode + ".toml")).exists()) {
            configFile = ConfigEngine.loadDefault(configPath);
        }
        return configFile;
    }

    public static ServerConfig loadServerConfig(String configPath) {
        try {
            ConfigEngine.migrateOldServerConfigs(configPath);
        }
        catch (Exception e) {
            LOGGER.error("Could not migrate old config format!");
            e.printStackTrace();
        }
        File configFile = ConfigEngine.loadServerDefault(configPath);
        ServerConfig config = null;
        if (configFile.exists()) {
            configFile = ConfigEngine.migrateOldServerConfig(configFile);
        }
        if ((config = ConfigEngine.loadServerConfig(configFile)) == null) {
            LOGGER.error("Could not load config file. Something went wrong!");
        } else if (config.version < ServerVerNum) {
            ConfigEngine.saveConfig(config, configFile);
            config = ConfigEngine.loadServerConfig(configFile);
        }
        return config;
    }

    private static File loadServerDefault(String configPath) {
        File confDir = new File(configPath + "/config/");
        File configFile = new File(configPath + "/config/simple-rpc-server.toml");
        if (!confDir.exists()) {
            confDir.mkdirs();
        }
        if (!configFile.exists()) {
            ServerConfig conf = new ServerConfig();
            ConfigEngine.saveConfig(conf, configFile);
            LOGGER.warn("A config file has been created.\nPlease edit " + configFile.getAbsolutePath() + " to specify your RPC details");
        }
        return configFile;
    }

    public static void saveConfig(Object conf, File configPath) {
        Config.setInsertionOrderPreserved(true);
        ObjectConverter converter = new ObjectConverter();
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder(configPath).build();
        converter.toConfig(conf, (Config)config);
        config.save();
    }

    private static ClientConfig loadConfig(File configPath) {
        Config.setInsertionOrderPreserved(true);
        ObjectConverter converter = new ObjectConverter();
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder(configPath).build();
        config.load();
        return converter.toObject((UnmodifiableConfig)config, ClientConfig::new);
    }

    private static ServerConfig loadServerConfig(File configPath) {
        Config.setInsertionOrderPreserved(true);
        ObjectConverter converter = new ObjectConverter();
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder(configPath).build();
        config.load();
        return converter.toObject((UnmodifiableConfig)config, ServerConfig::new);
    }

    private static void migrateOldConfigs(String configPath) throws IOException {
        File langDir;
        ClientConfig config;
        File configFileBase = new File(configPath + "/config/simple-rpc.json");
        if (configFileBase.exists() && (config = APIUtils.migrateConfig(configFileBase)) != null) {
            ConfigEngine.saveConfig(config, new File(configPath + "/config/simple-rpc.toml"));
            configFileBase.delete();
        }
        if ((langDir = new File(configPath + "/simple-rpc/")).exists() && langDir.listFiles() != null) {
            for (File conf : langDir.listFiles()) {
                ClientConfig config2;
                if (!conf.getName().startsWith("simple-rpc_") || !conf.getName().endsWith(".json") || (config2 = APIUtils.migrateConfig(conf)) == null) continue;
                ConfigEngine.saveConfig(config2, new File(langDir.getAbsolutePath() + "/" + conf.getName().replace(".json", ".toml")));
                conf.delete();
            }
        }
    }

    private static void migrateOldServerConfigs(String configPath) throws IOException {
        ServerConfig config;
        File configFileBase = new File(configPath + "/config/simple-rpc-server.json");
        if (configFileBase.exists() && (config = APIUtils.migrateServerConfig(configFileBase)) != null) {
            ConfigEngine.saveConfig(config, new File(configPath + "/config/simple-rpc-server.toml"));
            configFileBase.delete();
        }
    }

    public static File migrateOldConfig(File configFile) {
        Config.setInsertionOrderPreserved(true);
        CommentedFileConfig config = CommentedFileConfig.of(configFile);
        CommentedFileConfig config2 = CommentedFileConfig.of(configFile);
        config2.clear();
        config.load();
        if (config.getInt("general.version") != VerNum) {
            ObjectConverter converter = new ObjectConverter();
            converter.toConfig((Object)new ClientConfig(), (Config)config2);
            config.valueMap().forEach((s, o) -> {
                if (o instanceof CommentedConfig) {
                    CommentedConfig config1 = (CommentedConfig)o;
                    config1.valueMap().forEach((ss, oo) -> config2.set(s + "." + ss, oo));
                } else {
                    config2.set((String)s, o);
                }
            });
            configFile.renameTo(new File(configFile.getName().replace(".toml", ".bak")));
            config2.set("general.version", (Object)VerNum);
            config2.save();
        }
        return config2.getFile();
    }

    public static File migrateOldServerConfig(File configFile) {
        Config.setInsertionOrderPreserved(true);
        CommentedFileConfig config = CommentedFileConfig.of(configFile);
        CommentedFileConfig config2 = CommentedFileConfig.of(configFile);
        config2.clear();
        config.load();
        if (config.getInt("general.version") != VerNum) {
            ObjectConverter converter = new ObjectConverter();
            converter.toConfig((Object)new ServerConfig(), (Config)config2);
            config.valueMap().forEach((s, o) -> {
                if (o instanceof CommentedConfig) {
                    CommentedConfig config1 = (CommentedConfig)o;
                    config1.valueMap().forEach((ss, oo) -> config2.set(s + "." + ss, oo));
                } else {
                    config2.set((String)s, o);
                }
            });
            configFile.renameTo(new File(configFile.getName().replace(".toml", ".bak")));
            config2.set("general.version", (Object)VerNum);
            config2.save();
        }
        return config2.getFile();
    }
}

