/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.simplerpc.configuration;

import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import me.hypherionmc.simplerpc.discordutils.RPCEvents;

public class ConfigWatcher
extends Thread {
    private final File file;
    private AtomicBoolean stop = new AtomicBoolean(false);

    public ConfigWatcher(File file) {
        this.file = file;
    }

    public boolean isStopped() {
        return this.stop.get();
    }

    public void stopThread() {
        this.stop.set(true);
    }

    public void doOnChange() {
        RPCEvents.configChanged();
    }

    @Override
    public void run() {
        try (WatchService watcher = FileSystems.getDefault().newWatchService();){
            Path path = this.file.toPath().getParent();
            path.register(watcher, StandardWatchEventKinds.ENTRY_MODIFY);
            while (!this.isStopped()) {
                WatchKey key;
                try {
                    key = watcher.poll(25L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    if (watcher != null) {
                        if (var2_3 != null) {
                            try {
                                watcher.close();
                            }
                            catch (Throwable throwable) {
                                var2_3.addSuppressed(throwable);
                            }
                        } else {
                            watcher.close();
                        }
                    }
                    return;
                }
                if (key == null) {
                    Thread.yield();
                    continue;
                }
                for (WatchEvent<?> event : key.pollEvents()) {
                    boolean valid;
                    WatchEvent.Kind<?> kind = event.kind();
                    WatchEvent<?> ev = event;
                    Path filename = (Path)ev.context();
                    if (kind == StandardWatchEventKinds.OVERFLOW) {
                        Thread.yield();
                        continue;
                    }
                    if (kind == StandardWatchEventKinds.ENTRY_MODIFY && filename.toString().equals(this.file.getName())) {
                        this.doOnChange();
                    }
                    if (valid = key.reset()) continue;
                    break;
                }
                Thread.yield();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

