/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.simplerpc.discordapi.entities.pipe;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import me.hypherionmc.simplerpc.discordapi.IPCClient;
import me.hypherionmc.simplerpc.discordapi.entities.Callback;
import me.hypherionmc.simplerpc.discordapi.entities.Packet;
import me.hypherionmc.simplerpc.discordapi.entities.pipe.Pipe;
import me.hypherionmc.simplerpc.discordapi.entities.pipe.PipeStatus;
import me.hypherionmc.simplerpc.discordutils.RPCEvents;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;

public class UnixPipe
extends Pipe {
    private static final Logger LOGGER = LogManager.getLogger(UnixPipe.class);
    private final AFUNIXSocket socket = AFUNIXSocket.newInstance();

    UnixPipe(IPCClient ipcClient, HashMap<String, Callback> callbacks, String location) throws IOException {
        super(ipcClient, callbacks);
        this.socket.connect(new AFUNIXSocketAddress(new File(location)));
    }

    @Override
    public Packet read() throws IOException, JSONException {
        InputStream is = this.socket.getInputStream();
        while (is.available() == 0 && this.status == PipeStatus.CONNECTED) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.status == PipeStatus.DISCONNECTED) {
            throw new IOException("Disconnected!");
        }
        if (this.status == PipeStatus.CLOSED) {
            return new Packet(Packet.OpCode.CLOSE, null);
        }
        byte[] d = new byte[8];
        is.read(d);
        ByteBuffer bb = ByteBuffer.wrap(d);
        Packet.OpCode op = Packet.OpCode.values()[Integer.reverseBytes(bb.getInt())];
        d = new byte[Integer.reverseBytes(bb.getInt())];
        is.read(d);
        Packet p = new Packet(op, new JSONObject(new String(d)));
        if (RPCEvents.getConfig().general.debugging) {
            LOGGER.info(String.format("Received packet: %s", p.toString()));
        }
        if (this.listener != null) {
            this.listener.onPacketReceived(this.ipcClient, p);
        }
        return p;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.socket.getOutputStream().write(b);
    }

    @Override
    public void close() throws IOException {
        if (RPCEvents.getConfig().general.debugging) {
            LOGGER.info("Closing IPC pipe...");
        }
        this.send(Packet.OpCode.CLOSE, new JSONObject(), null);
        this.status = PipeStatus.CLOSED;
        this.socket.close();
    }
}

