/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.simplerpc.discordapi.entities.pipe;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import me.hypherionmc.simplerpc.discordapi.IPCClient;
import me.hypherionmc.simplerpc.discordapi.entities.Callback;
import me.hypherionmc.simplerpc.discordapi.entities.Packet;
import me.hypherionmc.simplerpc.discordapi.entities.pipe.Pipe;
import me.hypherionmc.simplerpc.discordapi.entities.pipe.PipeStatus;
import me.hypherionmc.simplerpc.discordutils.RPCEvents;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class WindowsPipe
extends Pipe {
    private static final Logger LOGGER = LogManager.getLogger(WindowsPipe.class);
    private final RandomAccessFile file;

    WindowsPipe(IPCClient ipcClient, HashMap<String, Callback> callbacks, String location) {
        super(ipcClient, callbacks);
        try {
            this.file = new RandomAccessFile(location, "rw");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.file.write(b);
    }

    @Override
    public Packet read() throws IOException, JSONException {
        while (this.file.length() == 0L && this.status == PipeStatus.CONNECTED) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.status == PipeStatus.DISCONNECTED) {
            throw new IOException("Disconnected!");
        }
        if (this.status == PipeStatus.CLOSED) {
            return new Packet(Packet.OpCode.CLOSE, null);
        }
        Packet.OpCode op = Packet.OpCode.values()[Integer.reverseBytes(this.file.readInt())];
        int len = Integer.reverseBytes(this.file.readInt());
        byte[] d = new byte[len];
        this.file.readFully(d);
        Packet p = new Packet(op, new JSONObject(new String(d)));
        if (RPCEvents.getConfig().general.debugging) {
            LOGGER.info(String.format("Received packet: %s", p.toString()));
        }
        if (this.listener != null) {
            this.listener.onPacketReceived(this.ipcClient, p);
        }
        return p;
    }

    @Override
    public void close() throws IOException {
        if (RPCEvents.getConfig().general.debugging) {
            LOGGER.info("Closing IPC pipe...");
        }
        this.send(Packet.OpCode.CLOSE, new JSONObject(), null);
        this.status = PipeStatus.CLOSED;
        this.file.close();
    }
}

