/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.simplerpc.discordutils;

import java.io.File;
import java.time.OffsetDateTime;
import java.util.concurrent.TimeUnit;
import me.hypherionmc.simplerpc.config.jsonhelpers.RPCState;
import me.hypherionmc.simplerpc.configuration.ClientConfig;
import me.hypherionmc.simplerpc.configuration.ConfigEngine;
import me.hypherionmc.simplerpc.configuration.ConfigWatcher;
import me.hypherionmc.simplerpc.configuration.ServerConfig;
import me.hypherionmc.simplerpc.discordutils.RPCBuild;
import me.hypherionmc.simplerpc.discordutils.RPCHandler;
import me.hypherionmc.simplerpc.integrations.launchers.LauncherUtils;
import me.hypherionmc.simplerpc.util.IUtilHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RPCEvents {
    private static IUtilHandler utilHandler;
    private static String configPath;
    public static final Logger LOGGER;
    private static ClientConfig config;
    private static RPCHandler rpcHandler;
    private static RPCState rpcState;
    private static RPCState lastState;
    private static OffsetDateTime time;
    private static boolean isSingle;
    private static String langCode;
    private static boolean isServer;
    private static boolean isFirstJoin;
    private static ServerConfig serverConfig;
    private static Long lastDiscordID;
    private static ConfigWatcher configWatcher;

    public RPCEvents(IUtilHandler utilHandler, String path, String langCode) {
        RPCEvents.utilHandler = utilHandler;
        configPath = path;
        RPCEvents.langCode = langCode;
        config = ConfigEngine.loadConfig(path, langCode);
        lastDiscordID = RPCEvents.config.general.discordid;
        rpcHandler = new RPCHandler(config);
        this.initRPC();
        this.startConfigWatcher();
    }

    public void initRPC() {
        time = OffsetDateTime.now();
        rpcState = RPCState.INIT;
        isFirstJoin = true;
        RPCEvents.doRPCStuff();
    }

    public void startConfigWatcher() {
        RPCHandler.taskManager.scheduleAtFixedRate(() -> {
            if (configWatcher == null || !configWatcher.isAlive() || configWatcher.isStopped()) {
                configWatcher = new ConfigWatcher(new File(RPCEvents.config.configPath));
                configWatcher.start();
            }
            RPCEvents.doRPCStuff();
        }, 0L, 1L, TimeUnit.SECONDS);
    }

    public static void configChanged() {
        config = ConfigEngine.loadConfig(configPath, langCode);
        if (!lastDiscordID.equals(RPCEvents.config.general.discordid)) {
            lastDiscordID = RPCEvents.config.general.discordid;
            rpcHandler = new RPCHandler(config);
        }
    }

    public void ingameRPC(boolean isSingle) {
        rpcState = RPCState.IN_GAME;
        RPCEvents.isSingle = isSingle;
        RPCEvents.doRPCStuff();
    }

    public void mainMenuRPC() {
        time = OffsetDateTime.now();
        rpcState = RPCState.MAIN_MENU;
        isFirstJoin = true;
        RPCEvents.doRPCStuff();
    }

    public void serverListRPC() {
        time = OffsetDateTime.now();
        rpcState = RPCState.SERVER_MENU;
        isFirstJoin = true;
        RPCEvents.doRPCStuff();
    }

    public void joiningGameRPC() {
        time = OffsetDateTime.now();
        rpcState = RPCState.JOINING_GAME;
        RPCEvents.doRPCStuff();
    }

    public void joinGame() {
        if (isFirstJoin) {
            RPCBuild.offsetDateTime = OffsetDateTime.now();
            isFirstJoin = false;
        }
    }

    private static void doRPCStuff() {
        if (config != null && RPCEvents.config.general.enabled && rpcHandler != null) {
            if (rpcState == RPCState.INIT) {
                if (RPCEvents.config.init.enabled) {
                    RPCBuild build = new RPCBuild().setDetails(utilHandler.parseVars(RPCEvents.config.init.description)).setLargeImage(RPCEvents.config.init.largeImageKey).setLargeImageText(utilHandler.parseVars(RPCEvents.config.init.largeImageText)).setSmallImage(RPCEvents.config.init.smallImageKey).setSmallImageText(utilHandler.parseVars(RPCEvents.config.init.smallImageText)).setTimeStamp(time).setButtons(RPCEvents.config.init.buttonsList).setState(utilHandler.parseVars(RPCEvents.config.init.state));
                    build = LauncherUtils.getLauncherOverrides(build, LauncherUtils.getLauncherType());
                    rpcHandler.sendRPC(build.getPresence(false));
                } else {
                    RPCEvents.genericRPC();
                }
            } else if (rpcState == RPCState.MAIN_MENU) {
                if (RPCEvents.config.main_menu.enabled) {
                    RPCBuild build = new RPCBuild().setDetails(utilHandler.parseVars(RPCEvents.config.main_menu.description)).setLargeImage(RPCEvents.config.main_menu.largeImageKey).setLargeImageText(utilHandler.parseVars(RPCEvents.config.main_menu.largeImageText)).setSmallImage(RPCEvents.config.main_menu.smallImageKey).setSmallImageText(utilHandler.parseVars(RPCEvents.config.main_menu.smallImageText)).setTimeStamp(time).setButtons(RPCEvents.config.main_menu.buttonsList).setState(utilHandler.parseVars(RPCEvents.config.main_menu.state));
                    build = LauncherUtils.getLauncherOverrides(build, LauncherUtils.getLauncherType());
                    rpcHandler.sendRPC(build.getPresence(false));
                } else {
                    RPCEvents.genericRPC();
                }
            } else if (rpcState == RPCState.SERVER_MENU) {
                if (RPCEvents.config.server_list.enabled) {
                    RPCBuild build = new RPCBuild().setDetails(utilHandler.parseVars(RPCEvents.config.server_list.description)).setLargeImage(RPCEvents.config.server_list.largeImageKey).setLargeImageText(utilHandler.parseVars(RPCEvents.config.server_list.largeImageText)).setSmallImage(RPCEvents.config.server_list.smallImageKey).setSmallImageText(utilHandler.parseVars(RPCEvents.config.server_list.smallImageText)).setTimeStamp(time).setButtons(RPCEvents.config.server_list.buttonsList).setState(utilHandler.parseVars(RPCEvents.config.server_list.state));
                    build = LauncherUtils.getLauncherOverrides(build, LauncherUtils.getLauncherType());
                    rpcHandler.sendRPC(build.getPresence(false));
                } else {
                    RPCEvents.genericRPC();
                }
            } else if (rpcState == RPCState.JOINING_GAME) {
                if (RPCEvents.config.join_game.enabled) {
                    RPCBuild build = new RPCBuild().setDetails(utilHandler.parseVars(RPCEvents.config.join_game.description)).setLargeImage(RPCEvents.config.join_game.largeImageKey).setLargeImageText(utilHandler.parseVars(RPCEvents.config.join_game.largeImageText)).setSmallImage(RPCEvents.config.join_game.smallImageKey).setSmallImageText(utilHandler.parseVars(RPCEvents.config.join_game.smallImageText)).setTimeStamp(time).setButtons(RPCEvents.config.join_game.buttonsList).setState(utilHandler.parseVars(RPCEvents.config.join_game.state));
                    build = LauncherUtils.getLauncherOverrides(build, LauncherUtils.getLauncherType());
                    rpcHandler.sendRPC(build.getPresence(false));
                } else {
                    RPCEvents.genericRPC();
                }
            } else if (rpcState == RPCState.IN_GAME) {
                if (isSingle) {
                    if (RPCEvents.config.single_player.enabled) {
                        if (rpcHandler != null) {
                            RPCBuild build = new RPCBuild().setDetails(utilHandler.parseVars(RPCEvents.config.single_player.description));
                            build.setLargeImage(RPCEvents.config.single_player.largeImageKey);
                            build.setLargeImageText(utilHandler.parseVars(RPCEvents.config.single_player.largeImageText));
                            build.setSmallImage(RPCEvents.config.single_player.smallImageKey);
                            build.setSmallImageText(utilHandler.parseVars(RPCEvents.config.single_player.smallImageText));
                            build.setState(utilHandler.parseVars(RPCEvents.config.single_player.state));
                            build.setButtons(RPCEvents.config.single_player.buttonsList);
                            build = LauncherUtils.getLauncherOverrides(build, LauncherUtils.getLauncherType());
                            if (RPCEvents.config.world_images.enabled) {
                                RPCBuild finalBuild = build;
                                RPCEvents.config.world_images.worlds.stream().filter(world -> world.worldname.equalsIgnoreCase(utilHandler.getWorld())).anyMatch(worlds -> {
                                    if (worlds.largeImageKey != null && !worlds.largeImageKey.isEmpty()) {
                                        finalBuild.setLargeImage(worlds.largeImageKey);
                                    }
                                    if (worlds.largeImageText != null && !worlds.largeImageText.isEmpty()) {
                                        finalBuild.setLargeImageText(utilHandler.parseVars(worlds.largeImageText));
                                    }
                                    if (worlds.smallImageKey != null && !worlds.smallImageKey.isEmpty()) {
                                        finalBuild.setSmallImage(worlds.smallImageKey);
                                    }
                                    if (worlds.smallImageText != null && !worlds.smallImageText.isEmpty()) {
                                        finalBuild.setSmallImageText(utilHandler.parseVars(worlds.smallImageText));
                                    }
                                    return true;
                                });
                                build = finalBuild;
                            }
                            rpcHandler.sendRPC(build.getPresence(true));
                        }
                    } else {
                        RPCEvents.genericRPC();
                    }
                } else if (RPCEvents.config.multi_player.enabled) {
                    RPCBuild finalBuild;
                    RPCBuild build = new RPCBuild().setDetails(utilHandler.parseVars(RPCEvents.config.multi_player.description));
                    build.setLargeImage(RPCEvents.config.multi_player.largeImageKey);
                    build.setLargeImageText(utilHandler.parseVars(RPCEvents.config.multi_player.largeImageText));
                    build.setSmallImage(RPCEvents.config.multi_player.smallImageKey);
                    build.setSmallImageText(utilHandler.parseVars(RPCEvents.config.multi_player.smallImageText));
                    build.setState(utilHandler.parseVars(RPCEvents.config.multi_player.state));
                    build.setButtons(RPCEvents.config.multi_player.buttonsList);
                    build = LauncherUtils.getLauncherOverrides(build, LauncherUtils.getLauncherType());
                    if (serverConfig != null && RPCEvents.serverConfig.enabled && RPCEvents.serverConfig.multi_player.enabled) {
                        build = new RPCBuild().setDetails(utilHandler.parseVars(RPCEvents.serverConfig.multi_player.description));
                        build.setLargeImage(RPCEvents.serverConfig.multi_player.largeImageKey);
                        build.setLargeImageText(utilHandler.parseVars(RPCEvents.serverConfig.multi_player.largeImageText));
                        build.setSmallImage(RPCEvents.serverConfig.multi_player.smallImageKey);
                        build.setSmallImageText(utilHandler.parseVars(RPCEvents.serverConfig.multi_player.smallImageText));
                        build.setState(utilHandler.parseVars(RPCEvents.serverConfig.multi_player.state));
                        build.setButtons(RPCEvents.serverConfig.multi_player.buttonsList);
                    }
                    if (RPCEvents.config.world_images.enabled) {
                        finalBuild = build;
                        RPCEvents.config.world_images.worlds.stream().filter(world -> world.worldname.equalsIgnoreCase(utilHandler.getWorld())).anyMatch(worlds -> {
                            if (worlds.largeImageKey != null && !worlds.largeImageKey.isEmpty()) {
                                finalBuild.setLargeImage(worlds.largeImageKey);
                            }
                            if (worlds.largeImageText != null && !worlds.largeImageText.isEmpty()) {
                                finalBuild.setLargeImageText(utilHandler.parseVars(worlds.largeImageText));
                            }
                            if (worlds.smallImageKey != null && !worlds.smallImageKey.isEmpty()) {
                                finalBuild.setSmallImage(worlds.smallImageKey);
                            }
                            if (worlds.smallImageText != null && !worlds.smallImageText.isEmpty()) {
                                finalBuild.setSmallImageText(utilHandler.parseVars(worlds.smallImageText));
                            }
                            return true;
                        });
                    }
                    if (serverConfig != null && RPCEvents.serverConfig.enabled && RPCEvents.serverConfig.world_images.enabled) {
                        finalBuild = build;
                        RPCEvents.serverConfig.world_images.worlds.stream().filter(world -> world.worldname.equalsIgnoreCase(utilHandler.getWorld())).anyMatch(worlds -> {
                            if (worlds.largeImageKey != null && !worlds.largeImageKey.isEmpty()) {
                                finalBuild.setLargeImage(worlds.largeImageKey);
                            }
                            if (worlds.largeImageText != null && !worlds.largeImageText.isEmpty()) {
                                finalBuild.setLargeImageText(utilHandler.parseVars(worlds.largeImageText));
                            }
                            if (worlds.smallImageKey != null && !worlds.smallImageKey.isEmpty()) {
                                finalBuild.setSmallImage(worlds.smallImageKey);
                            }
                            if (worlds.smallImageText != null && !worlds.smallImageText.isEmpty()) {
                                finalBuild.setSmallImageText(utilHandler.parseVars(worlds.smallImageText));
                            }
                            return true;
                        });
                        build = finalBuild;
                    }
                    rpcHandler.sendRPC(build.getPresence(true));
                } else {
                    RPCEvents.genericRPC();
                }
            } else {
                RPCEvents.genericRPC();
            }
        } else {
            rpcHandler.sendRPC(null);
        }
    }

    public static void genericRPC() {
        if (config != null && RPCEvents.config.general.enabled && rpcHandler != null) {
            RPCBuild build = new RPCBuild().setDetails(utilHandler.parseVars(RPCEvents.config.generic.description)).setLargeImage(RPCEvents.config.generic.largeImageKey).setLargeImageText(utilHandler.parseVars(RPCEvents.config.generic.largeImageText)).setSmallImage(RPCEvents.config.generic.smallImageKey).setSmallImageText(utilHandler.parseVars(RPCEvents.config.generic.smallImageText)).setState(utilHandler.parseVars(RPCEvents.config.generic.state)).setButtons(RPCEvents.config.generic.buttonsList);
            build = LauncherUtils.getLauncherOverrides(build, LauncherUtils.getLauncherType());
            rpcHandler.sendRPC(build.getPresence(false));
        }
    }

    public static void setServerData(ServerConfig serverData) {
        serverConfig = serverData;
        RPCEvents.doRPCStuff();
    }

    public void setLangCode(String langCode) {
        RPCEvents.langCode = langCode;
    }

    public static ClientConfig getConfig() {
        return config;
    }

    public static void saveConfig(ClientConfig config) {
        ConfigEngine.saveConfig(config, new File(config.configPath));
    }

    static {
        LOGGER = LogManager.getLogger((String)"Simple RPC");
        lastState = RPCState.INIT;
        time = OffsetDateTime.now();
        isSingle = false;
        isServer = false;
        isFirstJoin = true;
    }
}

