/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.simplerpc.integrations.launchers;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import me.hypherionmc.simplerpc.discordutils.RPCBuild;
import me.hypherionmc.simplerpc.discordutils.RPCEvents;
import me.hypherionmc.simplerpc.integrations.launchers.LauncherAssets;
import me.hypherionmc.simplerpc.integrations.launchers.atlauncher.ATLauncherInstance;
import me.hypherionmc.simplerpc.integrations.launchers.curse.CurseManifest;
import me.hypherionmc.simplerpc.integrations.launchers.technic.TechnicPack;
import me.hypherionmc.simplerpc.util.APIUtils;
import me.hypherionmc.simplerpc.util.SystemUtils;

public class LauncherUtils {
    private static List<String> multiMCIcons = new ArrayList<String>(){
        {
            this.add("bee");
            this.add("bricks");
            this.add("chicken");
            this.add("creeper");
            this.add("default");
            this.add("diamond");
            this.add("dirt");
            this.add("enderman");
            this.add("enderpearl");
            this.add("flame");
            this.add("fox");
            this.add("ftb");
            this.add("ftb_glow");
            this.add("gear");
            this.add("gold");
            this.add("grass");
            this.add("herobrine");
            this.add("iron");
            this.add("magitech");
            this.add("meat");
            this.add("netherstar");
            this.add("planks");
            this.add("skeleton");
            this.add("squarecreeper");
            this.add("steve");
            this.add("stone");
            this.add("tnt");
        }
    };

    public static LauncherType getLauncherType() {
        try {
            File instanceFile = new File(new File(SystemUtils.CUR_DIR).getParent() + File.separator + "instance.cfg");
            File installedPack = new File(new File(SystemUtils.CUR_DIR).getParentFile().getParentFile() + File.separator + "installedPacks");
            File curseInstance = new File(new File(SystemUtils.CUR_DIR) + File.separator + "manifest.json");
            File atInstance = new File(new File(SystemUtils.CUR_DIR) + File.separator + "instance.json");
            if (instanceFile.exists()) {
                if (RPCEvents.getConfig().general.debugging) {
                    RPCEvents.LOGGER.info("MultiMC Pack Found");
                }
                return LauncherType.MULTIMC;
            }
            if (installedPack.exists()) {
                if (RPCEvents.getConfig().general.debugging) {
                    RPCEvents.LOGGER.info("Technic Pack Found");
                }
                return LauncherType.TECHNIC;
            }
            File curseDir = new File(new File(SystemUtils.CUR_DIR).getParentFile().getParentFile().getParent());
            File gdDir = new File(new File(SystemUtils.CUR_DIR).getParentFile().getParent());
            if (curseInstance.exists() || curseDir.getName().equalsIgnoreCase("curseforge")) {
                if (RPCEvents.getConfig().general.debugging) {
                    RPCEvents.LOGGER.info("Curseforge Instance Found");
                }
                return LauncherType.CURSE;
            }
            if (curseInstance.exists() || gdDir.getName().equalsIgnoreCase("gdlauncher_next")) {
                if (RPCEvents.getConfig().general.debugging) {
                    RPCEvents.LOGGER.info("GDLauncher Instance Found");
                }
                return LauncherType.GDLAUNCHER;
            }
            if (atInstance.exists()) {
                if (RPCEvents.getConfig().general.debugging) {
                    RPCEvents.LOGGER.info("ATLauncher Instance Found");
                }
                return LauncherType.ATLAUNCHER;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return LauncherType.UNKNOWN;
    }

    public static LauncherAssets getLauncherInfo(LauncherType type) {
        try {
            File atInstance;
            FileReader fileReader;
            ATLauncherInstance atLauncherInstance;
            LauncherAssets curse;
            File gdDir;
            LauncherAssets curse2;
            CurseManifest curseManifest;
            FileReader curseReader;
            File curseInstance;
            if (type == LauncherType.MULTIMC) {
                File instanceFile = new File(new File(SystemUtils.CUR_DIR).getParent() + File.separator + "instance.cfg");
                Properties multiMcInstance = new Properties();
                multiMcInstance.load(new FileInputStream(instanceFile));
                if (multiMcInstance != null) {
                    LauncherAssets multiMc = new LauncherAssets();
                    if (multiMcInstance.containsKey("iconKey")) {
                        multiMc.ICON_NAME = multiMcInstance.getProperty("iconKey");
                    }
                    if (multiMcInstance.containsKey("name")) {
                        multiMc.PACK_NAME = "MultiMC: " + multiMcInstance.getProperty("name");
                    }
                    if (multiMc.PACK_NAME == null || multiMc.PACK_NAME.isEmpty()) {
                        multiMc.PACK_NAME = "MultiMC Instance";
                    }
                    if (multiMc.ICON_NAME == null || multiMc.ICON_NAME.isEmpty() || !multiMCIcons.contains(multiMc.ICON_NAME)) {
                        multiMc.ICON_NAME = "default";
                    }
                    return multiMc;
                }
            }
            if (type == LauncherType.TECHNIC) {
                File installedPack = new File(new File(SystemUtils.CUR_DIR).getParentFile().getParentFile() + File.separator + "installedPacks");
                FileReader reader = new FileReader(installedPack);
                Gson gson = new Gson();
                TechnicPack technicPack = (TechnicPack)gson.fromJson((Reader)reader, TechnicPack.class);
                reader.close();
                if (technicPack != null) {
                    LauncherAssets technic = new LauncherAssets();
                    technic.PACK_NAME = "Technic Launcher: " + APIUtils.capatilize(technicPack.selected);
                    technic.ICON_NAME = "technic";
                    return technic;
                }
            }
            if (type == LauncherType.CURSE) {
                curseInstance = new File(new File(SystemUtils.CUR_DIR) + File.separator + "manifest.json");
                if (curseInstance.exists()) {
                    curseReader = new FileReader(curseInstance);
                    curseManifest = (CurseManifest)new Gson().fromJson((Reader)curseReader, CurseManifest.class);
                    if (curseManifest != null) {
                        curse2 = new LauncherAssets();
                        curse2.PACK_NAME = "Curseforge Launcher: " + curseManifest.name;
                        curse2.ICON_NAME = "curse";
                        return curse2;
                    }
                } else {
                    gdDir = new File(SystemUtils.CUR_DIR);
                    curse = new LauncherAssets();
                    curse.PACK_NAME = "Curseforge Launcher: " + APIUtils.capatilize(gdDir.getName());
                    curse.ICON_NAME = "curse";
                    return curse;
                }
            }
            if (type == LauncherType.GDLAUNCHER) {
                curseInstance = new File(new File(SystemUtils.CUR_DIR) + File.separator + "manifest.json");
                if (curseInstance.exists()) {
                    curseReader = new FileReader(curseInstance);
                    curseManifest = (CurseManifest)new Gson().fromJson((Reader)curseReader, CurseManifest.class);
                    if (curseManifest != null) {
                        curse2 = new LauncherAssets();
                        curse2.PACK_NAME = "GDLauncher: " + curseManifest.name;
                        curse2.ICON_NAME = "gdlauncher";
                        return curse2;
                    }
                } else {
                    gdDir = new File(SystemUtils.CUR_DIR);
                    curse = new LauncherAssets();
                    curse.PACK_NAME = "GDLauncher: " + APIUtils.capatilize(gdDir.getName());
                    curse.ICON_NAME = "gdlauncher";
                    return curse;
                }
            }
            if (type == LauncherType.ATLAUNCHER && (atLauncherInstance = (ATLauncherInstance)new Gson().fromJson((Reader)(fileReader = new FileReader(atInstance = new File(new File(SystemUtils.CUR_DIR) + File.separator + "instance.json"))), ATLauncherInstance.class)) != null) {
                curse2 = new LauncherAssets();
                curse2.PACK_NAME = "ATLauncher: " + atLauncherInstance.launcher.name;
                curse2.ICON_NAME = "atlauncher";
                return curse2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static RPCBuild getLauncherOverrides(RPCBuild rpcBuild, LauncherType type) {
        LauncherAssets assets;
        if (type != LauncherType.UNKNOWN && RPCEvents.getConfig().general.discordid == 762726289341677668L && RPCEvents.getConfig().general.launcherIntegration && (assets = LauncherUtils.getLauncherInfo(type)) != null) {
            rpcBuild.setLargeImage(assets.ICON_NAME);
            rpcBuild.setLargeImageText(assets.PACK_NAME);
        }
        return rpcBuild;
    }

    public static enum LauncherType {
        UNKNOWN,
        GDLAUNCHER,
        TECHNIC,
        ATLAUNCHER,
        LUNAR,
        CURSE,
        MULTIMC;

    }
}

