/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.simplerpc.util.updater;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import me.hypherionmc.simplerpc.util.updater.Version;

public class UpdateEngine {
    private String MCVER = "";
    private String MODVER = "";
    private String NEWVER = "";
    private boolean isUpToDate = false;
    private boolean hasNotified = false;

    public UpdateEngine(String mcver, String modVer) {
        this.MCVER = mcver;
        this.MODVER = modVer;
        this.isUpToDate = false;
        this.hasNotified = false;
    }

    public void runUpdater() {
        try {
            String UPDATE_URL = "https://raw.githubusercontent.com/hypherionmc/simple-rpc-public/main/updatechecker.json";
            URL url = new URL(UPDATE_URL);
            InputStreamReader reader = new InputStreamReader(url.openStream());
            JsonElement object = new JsonParser().parse((Reader)reader);
            JsonObject skr = (JsonObject)object;
            if (skr.has(this.MCVER)) {
                Version current;
                String ver = skr.get(this.MCVER).getAsString();
                Version newVer = new Version(ver);
                if (newVer.compareTo(current = new Version(this.MODVER)) > 0) {
                    this.isUpToDate = false;
                    this.hasNotified = false;
                    this.NEWVER = newVer.get();
                } else {
                    this.isUpToDate = true;
                    this.hasNotified = false;
                    this.NEWVER = this.MODVER;
                }
            }
        }
        catch (Exception ex) {
            this.isUpToDate = true;
            this.NEWVER = this.MODVER;
        }
    }

    public boolean isHasNotified() {
        return this.hasNotified;
    }

    public void setHasNotified(boolean hasNotified) {
        this.hasNotified = hasNotified;
    }

    public boolean isUpToDate() {
        return this.isUpToDate;
    }

    public String getNEWVER() {
        return this.NEWVER;
    }
}

