/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.modules;

import com.bartz24.skyresources.recipe.ProcessRecipeManager;
import com.bartz24.skyresources.registry.ModFluids;
import com.bartz24.skyresources.registry.ModItems;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.FluidStack;
import thelm.jaopca.api.EnumEntryType;
import thelm.jaopca.api.EnumOreType;
import thelm.jaopca.api.IOreEntry;
import thelm.jaopca.api.ItemEntry;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.ModuleBase;
import thelm.jaopca.api.utils.Utils;

public class ModuleSkyResources
extends ModuleBase {
    public static final ArrayList<String> BLACKLIST = Lists.newArrayList((Object[])new String[]{"Iron", "Gold", "Copper", "Tin", "Silver", "Zinc", "Nickel", "Platinum", "Aluminium", "Lead", "Cobalt", "Ardite", "Osmium", "Draconium", "Titanium", "Tungsten", "Chromium", "Iridium", "Boron", "Lithium", "Magnesium", "Mithril", "Yellorium", "Uranium", "Thorium"});
    public static final ArrayList<String> GEM_BLACKLIST = Lists.newArrayList((Object[])new String[]{"Emerald", "Diamond", "Ruby", "Sapphire", "Peridot", "RedGarnet", "YellowGarnet", "Apatite", "Amber", "Lepidolite", "Malachite", "Onyx", "Moldavite", "Agate", "Opal", "Amethyst", "Jasper", "Aquamarine", "Heliodor", "Turquoise", "Moonstone", "Morganite", "Carnelian", "Beryl", "GoldenBeryl", "Citrine", "Indicolite", "Garnet", "Topaz", "Ametrine", "Tanzanite", "VioletSapphire", "Alexandrite", "BlueTopaz", "Spinel", "Iolite", "BlackDiamond", "Chaos", "EnderEssence", "Dark", "Quartz", "Lapis", "QuartzBlack", "CertusQuartz"});
    public static final HashMap<IOreEntry, ItemStack> ORE_CLEAN_BASES = Maps.newHashMap();
    public static final HashMap<IOreEntry, ItemStack> ORE_BASES = Maps.newHashMap();
    public static final ItemEntry ALCH_DUST_ENTRY = new ItemEntry(EnumEntryType.ITEM, "dustAlch", new ModelResourceLocation("jaopca:dust_alch#inventory"), BLACKLIST);
    public static final ItemEntry DIRTY_GEM_ENTRY = new ItemEntry(EnumEntryType.ITEM, "dirtyGem", new ModelResourceLocation("jaopca:dirty_gem#inventory"), GEM_BLACKLIST).setOreTypes(EnumOreType.GEM);

    @Override
    public String getName() {
        return "skyresources";
    }

    @Override
    public List<String> getOreBlacklist() {
        return BLACKLIST;
    }

    public List<ItemEntry> getItemRequests() {
        return Lists.newArrayList((Object[])new ItemEntry[]{ALCH_DUST_ENTRY, DIRTY_GEM_ENTRY});
    }

    @Override
    public void registerConfigs(Configuration config) {
        for (IOreEntry entry : JAOPCAApi.ENTRY_NAME_TO_ORES_MAP.get((Object)"dirtyGem")) {
            ORE_BASES.put(entry, Utils.parseItemStack(config.get(Utils.to_under_score(entry.getOreName()), "skyResourcesBase", "minecraft:stone", "The block used to create the ore. (Sky Resources)").setRequiresMcRestart(true).getString()));
        }
        for (IOreEntry entry : JAOPCAApi.ENTRY_NAME_TO_ORES_MAP.get((Object)"dustAlch")) {
            ORE_BASES.put(entry, Utils.parseItemStack(config.get(Utils.to_under_score(entry.getOreName()), "skyResourcesBase", "minecraft:stone", "The block to grind for the material. (Sky Resources)").setRequiresMcRestart(true).getString()));
        }
        for (IOreEntry entry : JAOPCAApi.MODULE_TO_ORES_MAP.get((Object)this)) {
            ORE_CLEAN_BASES.put(entry, Utils.parseItemStack(config.get(Utils.to_under_score(entry.getOreName()), "skyResourcesCleanBase", "skyresources:techitemcomponent@0", "The item that can be cleaned for this material. (Sky Resources)").setRequiresMcRestart(true).getString()));
        }
    }

    @Override
    public void init() {
        ItemStack base;
        for (IOreEntry entry : JAOPCAApi.ENTRY_NAME_TO_ORES_MAP.get((Object)"dustAlch")) {
            int rarity = Utils.rarityI(entry, 6.0);
            base = ORE_BASES.get(entry);
            if (Utils.doesOreNameExist("dust" + entry.getOreName())) {
                ProcessRecipeManager.fusionRecipes.addRecipe((Object)Utils.getOreStack("dustAlch", entry, 1), (float)rarity * 0.0021f, (List)Lists.newArrayList((Object[])new Object[]{"dust" + entry.getOreName(), ModuleSkyResources.getOreItemDust(rarity)}));
            }
            ProcessRecipeManager.condenserRecipes.addRecipe((Object)Utils.getOreStack("ingot", entry, 1), (float)Math.pow(1.4, rarity) * 50.0f, (List)Lists.newArrayList((Object[])new Object[]{Utils.getOreStack("dustAlch", entry, 1), new FluidStack(ModFluids.crystalFluid, 1000)}));
            ProcessRecipeManager.condenserRecipes.addRecipe((Object)Utils.getOreStack("ore", entry, 1), (float)Math.pow(1.8, rarity) * 50.0f, (List)Lists.newArrayList((Object[])new Object[]{Utils.getOreStack("dustAlch", entry, 1), base}));
        }
        for (IOreEntry entry : JAOPCAApi.ENTRY_NAME_TO_ORES_MAP.get((Object)"dirtyGem")) {
            float rarity = Utils.rarityReciprocalF(entry, 0.006);
            base = ORE_BASES.get(entry);
            ProcessRecipeManager.rockGrinderRecipes.addRecipe((Object)Utils.getOreStack("dirtyGem", entry, 1), rarity, (Object)base);
            ProcessRecipeManager.cauldronCleanRecipes.addRecipe((Object)Utils.getOreStack("gem", entry, 1), 1.0f, (Object)Utils.getOreStack("dirtyGem", entry, 1));
        }
        for (IOreEntry entry : JAOPCAApi.MODULE_TO_ORES_MAP.get((Object)this)) {
            int rarity = Utils.rarityI(entry, 6.0);
            base = ORE_CLEAN_BASES.get(entry);
            if (!Utils.doesOreNameExist("dust" + entry.getOreName()) || base == null || base.func_190926_b()) continue;
            ProcessRecipeManager.cauldronCleanRecipes.addRecipe((Object)Utils.getOreStack("dust", entry, 1), 1.0f / (float)Math.pow((float)rarity + 2.5f, 3.7f), (Object)base);
        }
    }

    private static ItemStack getOreItemDust(int rarity) {
        if (rarity <= 2) {
            return new ItemStack(Items.field_151016_H, 2);
        }
        if (rarity <= 4) {
            return new ItemStack(Items.field_151065_br, 2);
        }
        if (rarity <= 6) {
            return new ItemStack(Items.field_151114_aO, 2);
        }
        if (rarity <= 8) {
            return new ItemStack(Items.field_151100_aR, 2, 4);
        }
        return new ItemStack(ModItems.baseComponent, 2, 3);
    }
}

