/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.base.tile;

import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.tile.machine.IEUStorage;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IMultiEnergySource;
import ic2.core.block.base.tile.TileEntityBlock;
import ic2.core.block.base.util.comparator.ComparatorManager;
import ic2.core.block.base.util.comparator.comparators.ComparatorEUStorage;
import ic2.core.block.base.util.info.EmitterInfo;
import ic2.core.block.base.util.info.EnergyInfo;
import ic2.core.block.base.util.info.EnergyPacketInfo;
import ic2.core.block.base.util.info.MaxInputInfo;
import ic2.core.block.base.util.info.SinkTierInfo;
import ic2.core.block.base.util.info.SourceTierInfo;
import ic2.core.block.base.util.info.misc.IEmitterTile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class TileEntityTransformer
extends TileEntityBlock
implements ITickable,
IEUStorage,
IEmitterTile,
IEnergySink,
IMultiEnergySource {
    public int lowOutput;
    public int highOutput;
    public int maxEnergy;
    @NetworkField(index=3, override=true)
    public int energy = 0;
    public boolean addedToEnergyNet = false;

    public TileEntityTransformer(int low, int high, int max) {
        this.lowOutput = low;
        this.highOutput = high;
        this.maxEnergy = max;
        this.addGuiFields("energy");
        this.addInfos(new SinkTierInfo(this), new MaxInputInfo(this), new EnergyInfo(this), new EmitterInfo(this), new SourceTierInfo(this), new EnergyPacketInfo(this));
    }

    @Override
    protected void addComparators(ComparatorManager manager) {
        manager.addComparatorMode(new ComparatorEUStorage(this));
    }

    @Override
    public int getOutput() {
        return this.getActive() ? this.highOutput : this.lowOutput;
    }

    @Override
    public int getMaxEU() {
        return this.maxEnergy;
    }

    @Override
    public int getStoredEU() {
        return this.energy;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energy = nbt.func_74762_e("Energy");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("Energy", this.energy);
        return nbt;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (this.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    public void func_73660_a() {
        this.handleRedstone();
    }

    @Override
    public boolean canUpdate() {
        return this.isSimulating();
    }

    @Override
    public boolean needsInitialRedstoneUpdate() {
        return true;
    }

    @Override
    public void handleRedstone() {
        boolean newValue;
        if (this.needsRedstoneUpdate && (newValue = this.field_145850_b.func_175640_z(this.func_174877_v())) != this.redstone) {
            if (this.addedToEnergyNet) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            }
            this.addedToEnergyNet = false;
            this.redstone = newValue;
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
            this.setActive(this.redstone);
        }
    }

    @Override
    public void setFacing(EnumFacing facing) {
        if (this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        }
        this.addedToEnergyNet = false;
        super.setFacing(facing);
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
        this.addedToEnergyNet = true;
    }

    @Override
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing side) {
        if (this.redstone) {
            return this.getFacing() != side;
        }
        return this.getFacing() == side;
    }

    @Override
    public double getDemandedEnergy() {
        return this.maxEnergy - this.energy;
    }

    @Override
    public int getSinkTier() {
        if (this.getActive()) {
            return EnergyNet.instance.getTierFromPower(this.lowOutput);
        }
        return EnergyNet.instance.getTierFromPower(this.highOutput);
    }

    @Override
    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        int n = this.redstone ? this.lowOutput : this.highOutput;
        if (amount > (double)n || amount <= 0.0) {
            return 0.0;
        }
        this.energy = (int)((double)this.energy + amount);
        int re = 0;
        if (this.energy > this.maxEnergy) {
            re = this.energy - this.maxEnergy;
            this.energy = this.maxEnergy;
        }
        this.getNetwork().updateTileGuiField(this, "energy");
        return re;
    }

    @Override
    public double getOfferedEnergy() {
        if (this.getActive()) {
            if (this.energy >= this.highOutput) {
                return this.highOutput;
            }
        } else if (this.energy >= this.lowOutput) {
            return this.lowOutput;
        }
        return 0.0;
    }

    @Override
    public void drawEnergy(double amount) {
        this.energy = (int)((double)this.energy - amount);
        this.getNetwork().updateTileGuiField(this, "energy");
    }

    @Override
    public int getSourceTier() {
        if (this.getActive()) {
            return EnergyNet.instance.getTierFromPower(this.highOutput);
        }
        return EnergyNet.instance.getTierFromPower(this.lowOutput);
    }

    @Override
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
        if (this.redstone) {
            return this.getFacing() == side;
        }
        return this.getFacing() != side;
    }

    @Override
    public boolean sendMultipleEnergyPackets() {
        return !this.redstone;
    }

    @Override
    public int getMultipleEnergyPacketAmount() {
        return this.redstone ? 1 : 4;
    }

    @Override
    public boolean canRemoveBlock(EntityPlayer player) {
        return true;
    }

    @Override
    public boolean canSetFacing(EntityPlayer player, EnumFacing facing) {
        return this.getFacing() != facing;
    }
}

