/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.personal.base.trades.builder;

import ic2.api.classic.trading.trades.ITrade;
import ic2.core.block.personal.base.misc.IPersonalInventory;
import ic2.core.block.personal.base.misc.PersonalInventory;
import ic2.core.block.personal.base.trades.builder.ItemTradeFabricator;
import ic2.core.block.personal.trades.energy.BasicCustomEnergyTrade;
import ic2.core.util.math.IntCounter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class EnergyTradeFabricator {
    Map<Integer, NonNullList<ItemStack>> inputs = new HashMap<Integer, NonNullList<ItemStack>>();
    Map<Integer, IntCounter> outputs = new HashMap<Integer, IntCounter>();
    Map<Integer, ItemTradeFabricator.ItemTradeRules> rules = new HashMap<Integer, ItemTradeFabricator.ItemTradeRules>();
    Set<Integer> slots = new HashSet<Integer>();

    public boolean hasKey(int slot) {
        return this.slots.contains(slot);
    }

    public void removeInput(int slot) {
        this.inputs.remove(slot);
    }

    public ItemTradeFabricator.ItemTradeRules getRules(int slot) {
        ItemTradeFabricator.ItemTradeRules newRules = this.rules.get(slot);
        if (newRules == null) {
            newRules = new ItemTradeFabricator.ItemTradeRules();
            this.rules.put(slot, newRules);
        }
        return newRules;
    }

    public void clear() {
        this.inputs.clear();
        this.outputs.clear();
        this.rules.clear();
        this.slots.clear();
    }

    public void setItems(IPersonalInventory inv, IntCounter energy, int slot) {
        NonNullList input = NonNullList.func_191197_a((int)8, (Object)ItemStack.field_190927_a);
        boolean hasAnything = energy.getValue() > 0;
        for (int i = 0; i < 8; ++i) {
            input.set(i, (Object)inv.getStackInSlot(i).func_77946_l());
            if (hasAnything) continue;
            hasAnything = !((ItemStack)input.get(i)).func_190926_b();
        }
        if (hasAnything) {
            this.inputs.put(slot, (NonNullList<ItemStack>)input);
            this.outputs.put(slot, new IntCounter(energy.getValue()));
            this.slots.add(slot);
        } else {
            this.inputs.remove(slot);
            this.outputs.remove(slot);
            this.slots.remove(slot);
        }
    }

    public void pushToSlots(int slot, IntCounter energy, PersonalInventory inv) {
        NonNullList in = this.inputs.get(slot);
        IntCounter out = this.outputs.get(slot);
        if (in == null || in.size() != 8) {
            in = NonNullList.func_191197_a((int)8, (Object)ItemStack.field_190927_a);
        }
        if (out == null) {
            out = new IntCounter();
        }
        for (int i = 0; i < 8; ++i) {
            inv.setStackInSlot(i, ((ItemStack)in.get(i)).func_77946_l());
        }
        energy.setValue(out.getValue());
    }

    public void setItems(int slot, IntCounter energy, PersonalInventory inv, boolean copyInput, boolean copyOutput) {
        NonNullList input = NonNullList.func_191197_a((int)8, (Object)ItemStack.field_190927_a);
        IntCounter output = new IntCounter();
        if (copyOutput) {
            output.setValue(energy.getValue());
        }
        for (int i = 0; i < 8; ++i) {
            if (!copyInput) continue;
            input.set(i, (Object)inv.getStackInSlot(i).func_77946_l());
        }
        this.inputs.put(slot, (NonNullList<ItemStack>)input);
        this.outputs.put(slot, output);
    }

    public ITrade createTrade(UUID owner) {
        BasicCustomEnergyTrade trade = new BasicCustomEnergyTrade(owner);
        for (Integer slot : this.slots) {
            trade.addSlot(slot, this.inputs.get(slot), this.outputs.get(slot));
            trade.addRules(slot, this.getRules(slot));
        }
        trade.createSubTrades();
        return trade;
    }
}

