/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.upgrades.subtypes.machine;

import ic2.api.classic.item.IMachineUpgradeItem;
import ic2.api.classic.reactor.IChamberReactor;
import ic2.api.classic.reactor.IReactorPlannerComponent;
import ic2.api.classic.tile.IMachine;
import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorChamber;
import ic2.api.reactor.IReactorComponent;
import ic2.core.Direction;
import ic2.core.IC2;
import ic2.core.inventory.filters.BasicItemFilter;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.inventory.filters.IFilter;
import ic2.core.inventory.filters.ReactorTypeFilter;
import ic2.core.inventory.transport.IItemTransporter;
import ic2.core.inventory.transport.TransporterManager;
import ic2.core.item.upgrades.subtypes.machine.BaseMetaUpgrade;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2GuiLang;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.player.PlayerHandler;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.util.helpers.ToolHelper;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ReactorTrackUpgrade
extends BaseMetaUpgrade {
    @Override
    public void addInfo(ItemStack par1, EntityPlayer par2, List<String> par3, Map<ToolTipType, List<String>> toolTip) {
        List<String> altInfo = toolTip.get((Object)ToolTipType.Alt);
        NBTTagCompound nbt = StackUtil.getNbtData(par1);
        altInfo.add(Ic2InfoLang.reactorTrackType.getLocalizedFormatted(this.getCategoryName(IReactorPlannerComponent.ReactorComponentType.values()[nbt.func_74762_e("Type")])));
        altInfo.add(Ic2InfoLang.reactorTrackMode.getLocalizedFormatted(nbt.func_74767_n("Insert") ? Ic2InfoLang.trackModeInsert : Ic2InfoLang.trackModeExtract));
        altInfo.add(Ic2InfoLang.reactorItemsToTrack.getLocalizedFormatted(nbt.func_150295_c("Data", 7).func_74745_c()));
        List<String> ctrlInfo = toolTip.get((Object)ToolTipType.Ctrl);
        ctrlInfo.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(IC2.keyboard.getKeyName(2), Ic2InfoLang.setTransferMode));
        ctrlInfo.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(IC2.keyboard.getKeyName(2) + " + " + IC2.keyboard.getKeyName(0), Ic2InfoLang.setTrackType));
        ctrlInfo.add("");
        ctrlInfo.add(Ic2Lang.onBlockClick.getLocalized());
        ctrlInfo.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(IC2.keyboard.getKeyName(3), Ic2InfoLang.createSnapshot));
    }

    @Override
    public IMachineUpgradeItem.UpgradeType getType() {
        return IMachineUpgradeItem.UpgradeType.ImportExport;
    }

    @Override
    public LocaleComp getName() {
        return Ic2ItemLang.reactorTrackerUpgrade;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture() {
        return Ic2Icons.getTextures("i0")[160];
    }

    @Override
    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }

    @Override
    public boolean needsTick() {
        return true;
    }

    @Override
    public boolean usesDirection() {
        return true;
    }

    @Override
    public boolean usesExtraRightClick(ItemStack item) {
        return true;
    }

    @Override
    public void onRightClick(ItemStack item, World world, EntityPlayer player, EnumHand hand) {
        if (IC2.platform.isSimulating() && !player.func_70093_af()) {
            PlayerHandler handler = PlayerHandler.getHandlerForPlayer(player);
            if (handler.modeSwitchKeyDown) {
                NBTTagCompound nbt = StackUtil.getOrCreateNbtData(item);
                if (handler.altKeyDown) {
                    IReactorPlannerComponent.ReactorComponentType[] types;
                    int type = nbt.func_74762_e("Type") + 1;
                    if (type >= (types = IReactorPlannerComponent.ReactorComponentType.values()).length) {
                        type = 0;
                    }
                    nbt.func_74768_a("Type", type);
                    IC2.platform.messagePlayer(player, Ic2InfoLang.reactorTrackType, this.getCategoryName(types[type]));
                } else {
                    boolean result = !nbt.func_74767_n("Insert");
                    nbt.func_74757_a("Insert", result);
                    IC2.platform.messagePlayer(player, Ic2InfoLang.reactorTrackMode, result ? Ic2InfoLang.trackModeInsert : Ic2InfoLang.trackModeExtract);
                }
            }
        }
    }

    @Override
    public boolean onBlockClick(ItemStack stack, World world, BlockPos pos, EntityPlayer player, EnumHand hand) {
        if (IC2.keyboard.isSideinventoryKeyDown(player)) {
            IChamberReactor reactor = this.getReactor(world.func_175625_s(pos));
            if (reactor == null) {
                IC2.platform.messagePlayer(player, Ic2InfoLang.invalidReactor);
                return false;
            }
            int maxX = reactor.getSlotCountX();
            int maxY = reactor.getSlotCountY();
            IFilter filter = this.getFilter(IReactorPlannerComponent.ReactorComponentType.values()[StackUtil.getNbtData(stack).func_74762_e("Type")]);
            NBTTagList list = new NBTTagList();
            for (int x = 0; x < maxX; ++x) {
                for (int y = 0; y < maxY; ++y) {
                    ItemStack item = reactor.getItemAt(x, y);
                    if (item.func_190926_b() || !filter.matches(item)) continue;
                    list.func_74742_a((NBTBase)new NBTTagByteArray(new byte[]{(byte)x, (byte)y}));
                }
            }
            stack.func_77983_a("Data", (NBTBase)list);
            IC2.platform.messagePlayer(player, Ic2InfoLang.reactorItemsToTrack, list.func_74745_c());
            return true;
        }
        return false;
    }

    @Override
    public boolean usesBlockClick(ItemStack stack) {
        return true;
    }

    private LocaleComp getCategoryName(IReactorPlannerComponent.ReactorComponentType type) {
        switch (type) {
            case FuelRod: {
                return Ic2GuiLang.categoryRods;
            }
            case CoolantCell: {
                return Ic2GuiLang.categoryCoolant;
            }
            case Conensator: {
                return Ic2GuiLang.categoryCondensators;
            }
            case HeatPack: {
                return Ic2GuiLang.categoryHeatPacks;
            }
            case Vent: {
                return Ic2GuiLang.categoryVents;
            }
            case VentSpread: {
                return Ic2GuiLang.categorySpreadVents;
            }
            case HeatSwitch: {
                return Ic2GuiLang.categorySwitches;
            }
            case Plating: {
                return Ic2GuiLang.categoryPlates;
            }
            case Reflection: {
                return Ic2GuiLang.categoryReflectors;
            }
            case IsotopeCell: {
                return Ic2GuiLang.categoryIsotopics;
            }
        }
        return Ic2Lang.nullKey;
    }

    @Override
    public void onTick(ItemStack upgrade, IMachine machine) {
        if (this.getWorldTime(machine) % 10L == 0L) {
            if (StackUtil.getNbtData(upgrade).func_74767_n("Insert")) {
                this.insertItems(upgrade, machine);
            } else {
                this.extractItems(upgrade, machine);
            }
        }
    }

    public void extractItems(ItemStack upgrade, IMachine machine) {
        Direction dir = this.getDirection(upgrade);
        if (dir != null) {
            IChamberReactor reactor = this.getReactor(dir.applyToTileEntity((TileEntity)machine));
            if (reactor == null) {
                return;
            }
            IItemTransporter transporter = TransporterManager.manager.getTransporter(machine, true);
            if (transporter == null) {
                return;
            }
            NBTTagCompound nbt = StackUtil.getNbtData(upgrade);
            NBTTagList list = nbt.func_150295_c("Data", 7);
            IFilter filter = this.getFilter(IReactorPlannerComponent.ReactorComponentType.values()[nbt.func_74762_e("Type")]);
            EnumFacing side = dir.getInverse().toFacing();
            for (int i = 0; i < list.func_74745_c(); ++i) {
                ItemStack added;
                double per;
                byte y;
                byte[] array = ((NBTTagByteArray)list.func_179238_g(i)).func_150292_c();
                byte x = array[0];
                ItemStack stack = reactor.getItemAt(x, y = array[1]);
                if (stack.func_190926_b()) continue;
                if (!filter.matches(stack)) {
                    ItemStack added2 = transporter.addItem(stack, side, true);
                    if (added2.func_190926_b()) continue;
                    stack.func_190918_g(added2.func_190916_E());
                    continue;
                }
                IReactorPlannerComponent comp = (IReactorPlannerComponent)stack.func_77973_b();
                if (comp.getReactorStat(IReactorPlannerComponent.ReactorComponentStat.Rechargeable, stack).func_150287_d() <= 0 || !((per = ToolHelper.getPercentage(stack)) >= 0.9) || (added = transporter.addItem(stack, side, true)).func_190926_b()) continue;
                stack.func_190918_g(added.func_190916_E());
            }
        }
    }

    public void insertItems(ItemStack upgrade, IMachine machine) {
        Direction dir = this.getDirection(upgrade);
        if (dir != null) {
            IChamberReactor reactor = this.getReactor(dir.applyToTileEntity((TileEntity)machine));
            if (reactor == null) {
                return;
            }
            IItemTransporter transporter = TransporterManager.manager.getTransporter(machine, true);
            if (transporter == null) {
                return;
            }
            NBTTagCompound nbt = StackUtil.getNbtData(upgrade);
            NBTTagList list = nbt.func_150295_c("Data", 7);
            IFilter filter = this.getFilter(IReactorPlannerComponent.ReactorComponentType.values()[nbt.func_74762_e("Type")]);
            EnumFacing side = dir.getInverse().toFacing();
            for (int i = 0; i < list.func_74745_c(); ++i) {
                byte y;
                byte[] array = ((NBTTagByteArray)list.func_179238_g(i)).func_150292_c();
                byte x = array[0];
                ItemStack stack = reactor.getItemAt(x, y = array[1]);
                if (!stack.func_190926_b()) continue;
                ItemStack adding = transporter.removeItem(filter, side, 1, false);
                if (!(adding.func_77973_b() instanceof IReactorComponent) || !((IReactorComponent)adding.func_77973_b()).canBePlacedIn(adding, reactor)) break;
                reactor.setItemAt(x, y, transporter.removeItem(new BasicItemFilter(adding.func_77946_l()), side, 1, true).func_77946_l());
            }
        }
    }

    public IFilter getFilter(IReactorPlannerComponent.ReactorComponentType type) {
        if (type == null) {
            return CommonFilters.Nothing;
        }
        return new ReactorTypeFilter(type);
    }

    public IChamberReactor getReactor(TileEntity tile) {
        IReactor reactor;
        if (tile instanceof IChamberReactor) {
            return (IChamberReactor)tile;
        }
        if (tile instanceof IReactorChamber && (reactor = ((IReactorChamber)tile).getReactorInstance()) instanceof IChamberReactor) {
            return (IChamberReactor)reactor;
        }
        return null;
    }
}

