/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.generating;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.SubTileGenerating;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.lexicon.LexiconData;

public class SubTileEndoflame
extends SubTileGenerating {
    private static final String TAG_BURN_TIME = "burnTime";
    private static final int FUEL_CAP = 32000;
    private static final int RANGE = 3;
    private static final int START_BURN_EVENT = 0;
    private int burnTime = 0;

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.burnTime > 0) {
            --this.burnTime;
        }
        if (this.getWorld().field_72995_K) {
            if (this.burnTime > 0 && this.supertile.func_145831_w().field_73012_v.nextInt(10) == 0) {
                Vec3d offset = this.getWorld().func_180495_p(this.getPos()).func_191059_e((IBlockAccess)this.getWorld(), this.getPos()).func_72441_c(0.4, 0.7, 0.4);
                this.supertile.func_145831_w().func_175688_a(EnumParticleTypes.FLAME, (double)this.supertile.func_174877_v().func_177958_n() + offset.field_72450_a + Math.random() * 0.2, (double)this.supertile.func_174877_v().func_177956_o() + offset.field_72448_b, (double)this.supertile.func_174877_v().func_177952_p() + offset.field_72449_c + Math.random() * 0.2, 0.0, 0.0, 0.0, new int[0]);
            }
            return;
        }
        if (this.linkedCollector != null && this.burnTime == 0 && this.mana < this.getMaxMana()) {
            int slowdown = this.getSlowdownFactor();
            for (EntityItem item : this.supertile.func_145831_w().func_72872_a(EntityItem.class, new AxisAlignedBB(this.supertile.func_174877_v().func_177982_a(-3, -3, -3), this.supertile.func_174877_v().func_177982_a(4, 4, 4)))) {
                int burnTime;
                ItemStack stack;
                if (item.field_70292_b < 59 + slowdown || item.field_70128_L || (stack = item.func_92059_d()).func_190926_b() || stack.func_77973_b().hasContainerItem(stack) || (burnTime = stack.func_77973_b() == Item.func_150898_a((Block)ModBlocks.spreader) ? 0 : TileEntityFurnace.func_145952_a((ItemStack)stack)) <= 0 || stack.func_190916_E() <= 0) continue;
                this.burnTime = Math.min(32000, burnTime) / 2;
                stack.func_190918_g(1);
                this.supertile.func_145831_w().func_184133_a(null, this.supertile.func_174877_v(), ModSounds.endoflame, SoundCategory.BLOCKS, 0.2f, 1.0f);
                this.getWorld().func_175641_c(this.getPos(), this.getWorld().func_180495_p(this.getPos()).func_177230_c(), 0, item.func_145782_y());
                this.sync();
                return;
            }
        }
    }

    @Override
    public boolean receiveClientEvent(int event, int param) {
        if (event == 0) {
            Entity e = this.getWorld().func_73045_a(param);
            if (e != null) {
                e.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, e.field_70165_t, e.field_70163_u + 0.1, e.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
                e.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, e.field_70165_t, e.field_70163_u, e.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
            }
            return true;
        }
        return super.receiveClientEvent(event, param);
    }

    @Override
    public int getMaxMana() {
        return 300;
    }

    @Override
    public int getValueForPassiveGeneration() {
        return 3;
    }

    @Override
    public int getColor() {
        return 7884800;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.toBlockPos(), 3);
    }

    @Override
    public LexiconEntry getEntry() {
        return LexiconData.endoflame;
    }

    @Override
    public void writeToPacketNBT(NBTTagCompound cmp) {
        super.writeToPacketNBT(cmp);
        cmp.func_74768_a(TAG_BURN_TIME, this.burnTime);
    }

    @Override
    public void readFromPacketNBT(NBTTagCompound cmp) {
        super.readFromPacketNBT(cmp);
        this.burnTime = cmp.func_74762_e(TAG_BURN_TIME);
    }

    @Override
    public boolean canGeneratePassively() {
        return this.burnTime > 0;
    }

    @Override
    public int getDelayBetweenPassiveGeneration() {
        return 2;
    }
}

