/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.astronomy;

import asmodeuscore.api.dimension.IAdvancedSpace;
import asmodeuscore.api.space.IExBody;
import asmodeuscore.core.astronomy.BodiesData;
import asmodeuscore.core.astronomy.dimension.world.gen.ACBiome;
import asmodeuscore.core.astronomy.gui.screen.GuiCustomTeleporting;
import asmodeuscore.core.prefab.celestialbody.ExMoon;
import asmodeuscore.core.prefab.celestialbody.ExPlanet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.IChildBody;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.Satellite;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.galaxies.Star;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.WorldProviderSpace;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.AtmosphereInfo;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedCreeper;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedEnderman;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSkeleton;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSpider;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedZombie;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.util.EnumHelper;

public class BodiesRegistry {
    private static Map<CelestialBody, BodiesData> data = new HashMap<CelestialBody, BodiesData>();
    private static int max_tier = 3;
    public static int getDefaultDergrees = 20;
    private static List<Map<String, ? extends CelestialBody>> bodiesToRegister = new ArrayList<Map<String, ? extends CelestialBody>>();

    public static Galaxies getGalaxy(String name) {
        for (Galaxies gal : Galaxies.values()) {
            if (!gal.getName().equals(name)) continue;
            return gal;
        }
        return null;
    }

    public static void setMaxTier(int tier) {
        if (BodiesRegistry.getMaxTier() < tier) {
            max_tier = tier;
        }
    }

    public static int getMaxTier() {
        return max_tier;
    }

    public static BodiesData getData(CelestialBody body) {
        return data.get(body) != null ? data.get(body) : new BodiesData(IAdvancedSpace.TypeBody.PLANET, IAdvancedSpace.ClassBody.TERRA);
    }

    public static List<Map<String, ? extends CelestialBody>> getBodies() {
        return bodiesToRegister;
    }

    public static void registerCelestialBody(Map<String, ? extends CelestialBody> body) {
        bodiesToRegister.add(body);
    }

    public static Galaxies registerGalaxy(String galaxy, ResourceLocation image) {
        return (Galaxies)EnumHelper.addEnum(Galaxies.class, (String)galaxy.toUpperCase(), (Class[])new Class[]{String.class, ResourceLocation.class}, (Object[])new Object[]{galaxy.toLowerCase(), image});
    }

    public static IAdvancedSpace.ClassBody registerClass(String classname) {
        return (IAdvancedSpace.ClassBody)EnumHelper.addEnum(IAdvancedSpace.ClassBody.class, (String)classname.toUpperCase(), (Class[])new Class[0], (Object[])new Object[0]);
    }

    public static IAdvancedSpace.TypeBody registerType(String typename) {
        return (IAdvancedSpace.TypeBody)EnumHelper.addEnum(IAdvancedSpace.TypeBody.class, (String)typename.toUpperCase(), (Class[])new Class[0], (Object[])new Object[0]);
    }

    public static void addTeleportData(int dimID, ResourceLocation image) {
        String[] possibleStrings = new String[]{"Taking one small step", "Taking one giant leap", "Prepare for entry!"};
        BodiesRegistry.addTeleportData(dimID, image, possibleStrings);
    }

    public static void addTeleportData(int dimID, ResourceLocation image, String[] text) {
        GuiCustomTeleporting.getList().add(new GuiCustomTeleporting.TeleportData(image, text, dimID));
    }

    public static SolarSystem registerSolarSystem(String prefix, String name, Galaxies galaxy, Vector3 pos, String starname, float size) {
        return BodiesRegistry.registerSolarSystem(prefix, name, galaxy, pos, starname, size, null);
    }

    public static SolarSystem registerSolarSystem(String prefix, String name, Galaxies galaxy, Vector3 pos, String starname, float size, @Nullable ResourceLocation icon) {
        SolarSystem body = new SolarSystem(name, galaxy.getName());
        body.setMapPosition(pos);
        Star main = new Star(starname);
        main.setParentSolarSystem(body);
        main.setTierRequired(-1);
        main.setRelativeSize(size);
        main.setBodyIcon(icon != null ? icon : new ResourceLocation(prefix, "textures/gui/celestialbodies/" + name + "/" + starname + ".png"));
        body.setMainStar(main);
        return body;
    }

    public static ExPlanet registerExPlanet(SolarSystem system, String name, String prefix, float distancefromcenter) {
        ExPlanet body = new ExPlanet(name).setParentSolarSystem(system);
        String path = system.getUnlocalizedName().replace("solarsystem.", "");
        body.setRingColorRGB(0.0f, 0.4f, 0.9f);
        body.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(distancefromcenter, distancefromcenter));
        body.setBodyIcon(new ResourceLocation(prefix, "textures/gui/celestialbodies/" + path + "/" + name + ".png"));
        return body;
    }

    public static ExMoon registerExMoon(Planet parent, String name, String prefix, float distancefromcenter) {
        ExMoon body = new ExMoon(name).setParentPlanet(parent);
        String path = parent.getParentSolarSystem().getUnlocalizedName().replace("solarsystem.", "");
        body.setRingColorRGB(0.0f, 0.4f, 0.9f);
        body.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(distancefromcenter, distancefromcenter));
        body.setBodyIcon(new ResourceLocation(prefix, "textures/gui/celestialbodies/" + path + "/moons/" + name + ".png"));
        return body;
    }

    public static void setOrbitData(CelestialBody body, float phase, float size, float relativetime) {
        BodiesRegistry.setOrbitData(body, phase, size, relativetime, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public static void setOrbitData(CelestialBody body, float phase, float size, float relativetime, float eccentricityX, float eccentricityY, float orbitOffsetX, float orbitOffsetY) {
        body.setPhaseShift(phase);
        body.setRelativeSize(size);
        body.setRelativeOrbitTime(relativetime);
        if (body instanceof ExPlanet) {
            ((ExPlanet)body).setOrbitEccentricity(eccentricityX, eccentricityY);
            ((ExPlanet)body).setOrbitOffset(orbitOffsetX, orbitOffsetY);
        }
    }

    @Deprecated
    public static void setPlanetData(CelestialBody body, int atm_pressure, long day_length, float gravity, boolean isSolarRadiation) {
        BodiesRegistry.setPlanetData(body, (float)atm_pressure, day_length, gravity, isSolarRadiation);
    }

    public static void setPlanetData(CelestialBody body, float water_pressure, float atm_pressure, long day_length, float gravity, boolean isSolarRadiation) {
        if (body instanceof ExPlanet) {
            ((ExPlanet)body).setWaterPressure(water_pressure);
        }
        if (body instanceof ExMoon) {
            ((ExMoon)body).setWaterPressure(water_pressure);
        }
        BodiesRegistry.setPlanetData(body, atm_pressure, day_length, gravity, isSolarRadiation);
    }

    public static void setPlanetData(CelestialBody body, float atm_pressure, long day_length, float gravity, boolean isSolarRadiation) {
        if (body instanceof ExPlanet) {
            ((ExPlanet)body).setGravity(gravity);
            ((ExPlanet)body).setAtmosphericPressure(atm_pressure);
            ((ExPlanet)body).setDayLength(day_length);
            ((ExPlanet)body).setSolarRadiation(isSolarRadiation ? 1.0f : 0.0f);
        }
        if (body instanceof ExMoon) {
            ((ExMoon)body).setGravity(gravity);
            ((ExMoon)body).setAtmosphericPressure(atm_pressure);
            ((ExMoon)body).setDayLength(day_length);
            ((ExMoon)body).setSolarRadiation(isSolarRadiation ? 1.0f : 0.0f);
        }
    }

    public static void setAtmosphere(CelestialBody body, boolean breathable, boolean precipitation, boolean corrosive, float temperature, float windLevel, float density) {
        body.setAtmosphere(new AtmosphereInfo(Boolean.valueOf(breathable), precipitation, corrosive, temperature, windLevel, density));
    }

    public static void setProviderData(CelestialBody body, Class<? extends WorldProvider> provider, int dimID, int tier, Biome ... biome) {
        body.setTierRequired(tier);
        body.setDimensionInfo(dimID, provider);
        if (biome != null) {
            body.setBiomeInfo(biome);
        }
        body.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedZombie.class, 8, 2, 3));
        body.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSpider.class, 8, 2, 3));
        body.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSkeleton.class, 8, 2, 3));
        body.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedCreeper.class, 8, 2, 3));
        body.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedEnderman.class, 10, 1, 4));
    }

    public static void setClassBody(CelestialBody body, IAdvancedSpace.ClassBody classbody) {
        if (body instanceof ExPlanet) {
            ((ExPlanet)body).setClassPlanet(classbody);
        }
        if (body instanceof ExMoon) {
            ((ExMoon)body).setClassPlanet(classbody);
        }
    }

    public static Planet registerPlanet(String name, String prefix, Class<? extends WorldProvider> provider, int dimID, int tier, float phase, float size, float distancefromcenter, float relativetime, Biome ... biome) {
        return BodiesRegistry.registerPlanet(GalacticraftCore.solarSystemSol, name, prefix, provider, dimID, tier, phase, size, distancefromcenter, relativetime, biome);
    }

    public static Planet registerPlanet(SolarSystem system, String name, String prefix, Class<? extends WorldProvider> provider, int dimID, int tier, float phase, float size, float distancefromcenter, float relativetime, Biome ... biome) {
        Planet body = new Planet(name).setParentSolarSystem(system);
        String path = system.getUnlocalizedName().replace("solarsystem.", "");
        body.setRingColorRGB(0.0f, 0.4f, 0.9f);
        body.setPhaseShift(phase);
        body.setRelativeSize(size);
        body.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(distancefromcenter, distancefromcenter));
        body.setRelativeOrbitTime(relativetime);
        body.setBodyIcon(new ResourceLocation(prefix, "textures/gui/celestialbodies/" + path + "/" + name + ".png"));
        if (provider != null) {
            body.setTierRequired(tier);
            body.setDimensionInfo(dimID, provider);
            if (biome != null) {
                body.setBiomeInfo(biome);
            }
            body.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedZombie.class, 8, 2, 3));
            body.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSpider.class, 8, 2, 3));
            body.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSkeleton.class, 8, 2, 3));
            body.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedCreeper.class, 8, 2, 3));
            body.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedEnderman.class, 10, 1, 4));
        }
        return body;
    }

    public static Moon registerMoon(Planet parent, String name, String prefix, Class<? extends WorldProvider> provider, int dimID, int tier, float phase, float size, float distancefromcenter, float relativetime, Biome ... biome) {
        Moon body = new Moon(name).setParentPlanet(parent);
        String path = parent.getParentSolarSystem().getUnlocalizedName().replace("solarsystem.", "");
        body.setRingColorRGB(0.0f, 0.4f, 0.9f);
        body.setPhaseShift(phase);
        body.setRelativeSize(size);
        body.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(distancefromcenter, distancefromcenter));
        body.setRelativeOrbitTime(relativetime);
        body.setBodyIcon(new ResourceLocation(prefix, "textures/gui/celestialbodies/" + path + "/moons/" + name + ".png"));
        if (provider != null) {
            body.setTierRequired(tier);
            body.setDimensionInfo(dimID, provider);
            if (biome != null) {
                body.setBiomeInfo(biome);
            }
            body.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedZombie.class, 8, 2, 3));
            body.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSpider.class, 8, 2, 3));
            body.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSkeleton.class, 8, 2, 3));
            body.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedCreeper.class, 8, 2, 3));
            body.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedEnderman.class, 10, 1, 4));
        }
        return body;
    }

    public static Satellite registerSatellite(Planet parent, String prefix, Class<? extends WorldProvider> provider, int dimID, int dimIDStatic, float phase, float size, float distancefromcenter, float relativetime) {
        Satellite body = new Satellite("spacestation." + parent.getUnlocalizedName().replace("planet.", ""));
        body.setParentBody(parent);
        body.setRelativeOrbitTime(relativetime);
        body.setPhaseShift(phase);
        body.setRelativeSize(size);
        body.setRingColorRGB(0.0f, 0.4f, 0.9f);
        body.setBodyIcon(new ResourceLocation("galacticraftcore:textures/gui/celestialbodies/space_station.png"));
        if (provider != null) {
            body.setTierRequired(parent.getTierRequirement());
            body.setDimensionInfo(dimID, dimIDStatic, provider);
            body.setBiomeInfo(new Biome[]{ACBiome.ACSpace});
        }
        return body;
    }

    public static void registerBodyData(CelestialBody body, BodiesData bodydata) {
        data.put(body, bodydata);
    }

    public static float calculateGravity(float Si) {
        float i = (9.81f - Si) * 0.008664628f;
        float k = Math.round(i * 1000.0f);
        return k / 1000.0f;
    }

    public static String getLocale(Object temp) {
        return GCCoreUtil.translate((String)("gui.info." + temp.toString().toLowerCase() + ".name"));
    }

    public static String classPlanet(CelestialBody body, WorldProvider dim) {
        BodiesData data = BodiesRegistry.getData(body);
        if (body != GalacticraftCore.planetOverworld) {
            IExBody planet;
            float temp = body.atmosphere.thermalLevel();
            boolean breath = body.atmosphere.isBreathable();
            String type = "";
            IAdvancedSpace.TempBody tempbody = IAdvancedSpace.TempBody.COMFORT;
            if (temp >= 2.0f) {
                tempbody = IAdvancedSpace.TempBody.HOT;
            }
            if (temp >= 1.0f && (double)temp < 2.0) {
                tempbody = IAdvancedSpace.TempBody.WARM;
            }
            if (temp > -1.0f && temp < 1.0f) {
                tempbody = IAdvancedSpace.TempBody.COMFORT;
            }
            if ((double)temp > -2.0 && temp <= -1.0f) {
                tempbody = IAdvancedSpace.TempBody.COOL;
            }
            if (temp <= -2.0f) {
                tempbody = IAdvancedSpace.TempBody.COLD;
            }
            type = BodiesRegistry.getLocale((Object)tempbody);
            if (body instanceof IExBody && (planet = (IExBody)body).getClassPlanet() != null) {
                return type + " " + BodiesRegistry.getLocale((Object)planet.getClassPlanet());
            }
            if (!breath && body.atmosphere.hasNoGases()) {
                if (dim instanceof WorldProviderSpace && (double)((WorldProviderSpace)dim).getDayLength() == 0.0) {
                    return BodiesRegistry.getLocale((Object)IAdvancedSpace.ClassBody.ASTEROID);
                }
                return type + " " + BodiesRegistry.getLocale((Object)IAdvancedSpace.ClassBody.SELENA);
            }
            if (breath) {
                return type + " " + BodiesRegistry.getLocale((Object)IAdvancedSpace.ClassBody.TERRA);
            }
            if (data != null && data.getClassPlanet() != null) {
                if (data.getStarColor() != null) {
                    return BodiesRegistry.getLocale((Object)data.getStarColor()) + " " + BodiesRegistry.getLocale(data.getClassPlanet().name().toLowerCase());
                }
                return BodiesRegistry.getLocale(data.getClassPlanet().name().toLowerCase());
            }
            if (!breath && dim instanceof IGalacticraftWorldProvider && ((IGalacticraftWorldProvider)dim).getCelestialBody() instanceof IExBody && ((IExBody)((IGalacticraftWorldProvider)dim).getCelestialBody()).getClassPlanet() == IAdvancedSpace.ClassBody.TITAN) {
                type = temp > 2.5f ? BodiesRegistry.getLocale((Object)IAdvancedSpace.TempBody.HOT) : (temp < -2.5f ? BodiesRegistry.getLocale((Object)IAdvancedSpace.TempBody.ICY) : BodiesRegistry.getLocale((Object)IAdvancedSpace.TempBody.COMFORT));
                return type + " " + BodiesRegistry.getLocale((Object)IAdvancedSpace.ClassBody.TITAN);
            }
            if (temp < -3.0f) {
                return BodiesRegistry.getLocale((Object)IAdvancedSpace.ClassBody.ICEWORLD);
            }
            return type + " " + BodiesRegistry.getLocale((Object)IAdvancedSpace.ClassBody.DESERT);
        }
        if (body == GalacticraftCore.planetOverworld) {
            return BodiesRegistry.getLocale((Object)IAdvancedSpace.TempBody.COMFORT) + " " + BodiesRegistry.getLocale((Object)IAdvancedSpace.ClassBody.TERRA);
        }
        return GCCoreUtil.translate((String)"gui.message.unknown");
    }

    public static float getDistanceFromCenter(World world) {
        if (world.field_73011_w instanceof IGalacticraftWorldProvider) {
            CelestialBody current_body = ((IGalacticraftWorldProvider)world.field_73011_w).getCelestialBody();
            float distance = 0.0f;
            if (current_body instanceof Planet) {
                distance = current_body.getRelativeDistanceFromCenter().unScaledDistance;
            }
            if (current_body instanceof IChildBody) {
                distance = ((IChildBody)current_body).getParentPlanet().getRelativeDistanceFromCenter().unScaledDistance;
            }
            return distance;
        }
        return 0.0f;
    }

    public static enum Galaxies {
        MILKYWAY("milky_way", null),
        ANDROMEDA("andromeda", null);

        private final String name;
        private final ResourceLocation image;

        private Galaxies(String name, ResourceLocation image) {
            this.name = name;
            this.image = image;
        }

        public String getName() {
            return this.name;
        }

        public ResourceLocation getImage() {
            return this.image;
        }
    }
}

