/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.lib;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.darkhax.bookshelf.util.StackUtils;
import net.minecraft.item.ItemStack;

public class ItemStackMap<T>
extends HashMap<ItemStack, T> {
    public static final IStackComparator SIMILAR = (stack, obj) -> obj instanceof ItemStack ? StackUtils.areStacksSimilar(stack, (ItemStack)obj) : false;
    public static final IStackComparator SIMILAR_WITH_SIZE = (stack, obj) -> obj instanceof ItemStack ? StackUtils.areStacksSimilarWithSize(stack, (ItemStack)obj) : false;
    public static final IStackComparator SIMILAR_WITH_NBT = (stack, obj) -> obj instanceof ItemStack ? StackUtils.areStacksSimilarWithPartialNBT(stack, (ItemStack)obj) : false;
    private final IStackComparator comparator;

    public ItemStackMap(IStackComparator comparator) {
        this.comparator = comparator;
    }

    @Override
    public boolean containsKey(Object key) {
        for (Map.Entry entry : this.entrySet()) {
            if (!this.comparator.isValid((ItemStack)entry.getKey(), key)) continue;
            return true;
        }
        return super.containsKey(key);
    }

    @Override
    public T remove(Object key) {
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!this.comparator.isValid((ItemStack)entry.getKey(), key)) continue;
            iterator.remove();
        }
        return (T)super.remove(key);
    }

    @Override
    public T get(Object key) {
        for (Map.Entry entry : this.entrySet()) {
            if (!this.comparator.isValid((ItemStack)entry.getKey(), key)) continue;
            return (T)entry.getValue();
        }
        return (T)super.get(key);
    }

    public static interface IStackComparator {
        public boolean isValid(ItemStack var1, Object var2);
    }
}

