/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.UUID;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.api.item.IInventoryItem;
import me.desht.pneumaticcraft.common.item.ItemRegistry;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class PneumaticCraftUtils {
    private static final List<Item> inventoryItemBlacklist = new ArrayList<Item>();
    public static final double[] sin = new double[500];
    public static final double[] cos = new double[500];
    public static final int CIRCLE_POINTS = 500;

    public static EnumFacing getDirectionFacing(EntityLivingBase entity, boolean includeUpAndDown) {
        double yaw;
        for (yaw = (double)entity.field_70177_z; yaw < 0.0; yaw += 360.0) {
        }
        yaw %= 360.0;
        if (includeUpAndDown) {
            if (entity.field_70125_A > 45.0f) {
                return EnumFacing.DOWN;
            }
            if (entity.field_70125_A < -45.0f) {
                return EnumFacing.UP;
            }
        }
        if (yaw < 45.0) {
            return EnumFacing.SOUTH;
        }
        if (yaw < 135.0) {
            return EnumFacing.WEST;
        }
        if (yaw < 225.0) {
            return EnumFacing.NORTH;
        }
        if (yaw < 315.0) {
            return EnumFacing.EAST;
        }
        return EnumFacing.SOUTH;
    }

    public static int getYawFromFacing(EnumFacing facing) {
        switch (facing) {
            case NORTH: {
                return 180;
            }
            case SOUTH: {
                return 0;
            }
            case WEST: {
                return 90;
            }
            case EAST: {
                return -90;
            }
        }
        return 0;
    }

    public static List<String> convertStringIntoList(String text) {
        return PneumaticCraftUtils.convertStringIntoList(text, 26);
    }

    public static List<String> convertStringIntoList(String text, int maxCharPerLine) {
        StringTokenizer tok = new StringTokenizer(text, " ");
        StringBuilder output = new StringBuilder(text.length());
        ArrayList<String> textList = new ArrayList<String>();
        String color = "";
        int lineLen = 0;
        while (tok.hasMoreTokens()) {
            String word = tok.nextToken();
            if (word.contains("\u00a7")) {
                for (int i = 0; i < word.length() - 1; ++i) {
                    if (!word.substring(i, i + 2).contains("\u00a7")) continue;
                    color = word.substring(i, i + 2);
                }
                lineLen -= 2;
            }
            if (lineLen + word.length() > maxCharPerLine || word.contains("\\n")) {
                word = word.replace("\\n", "");
                textList.add(output.toString());
                output.delete(0, output.length());
                output.append(color);
                lineLen = 0;
            } else if (lineLen > 0) {
                output.append(" ");
                ++lineLen;
            }
            output.append(word);
            lineLen += word.length();
        }
        textList.add(output.toString());
        return textList;
    }

    public static String convertTicksToMinutesAndSeconds(long ticks, boolean fraction) {
        String part = ticks % 20L * 5L + "";
        if (part.length() < 2) {
            part = "0" + part;
        }
        if ((ticks /= 20L) < 60L) {
            return ticks + (fraction ? "." + part : "") + "s";
        }
        return ticks / 60L + "m " + ticks % 60L + "s";
    }

    public static String convertAmountToString(int amount) {
        if (amount < 1000) {
            return amount + "";
        }
        return amount / 1000 + "k";
    }

    public static String roundNumberTo(double value, int decimals) {
        return new BigDecimal(value).setScale(decimals, 5).toPlainString();
    }

    public static double roundNumberToDouble(double value, int decimals) {
        return new BigDecimal(value).setScale(decimals, 5).doubleValue();
    }

    public static String roundNumberTo(float value, int decimals) {
        return "" + (double)Math.round((double)value * Math.pow(10.0, decimals)) / Math.pow(10.0, decimals);
    }

    public static boolean areFloatsEqual(float f1, float f2) {
        return PneumaticCraftUtils.areFloatsEqual(f1, f2, 0.001f);
    }

    public static boolean areFloatsEqual(float f1, float f2, float maxDifference) {
        return Math.abs(f1 - f2) < maxDifference;
    }

    private static void quickSort(ItemStack[] stacks, int begin, int end) {
        if (begin < end) {
            int partitionIndex = PneumaticCraftUtils._partition(stacks, begin, end);
            PneumaticCraftUtils.quickSort(stacks, begin, partitionIndex - 1);
            PneumaticCraftUtils.quickSort(stacks, partitionIndex + 1, end);
        }
    }

    private static int _partition(ItemStack[] arr, int begin, int end) {
        ItemStack pivot = arr[end];
        int i = begin - 1;
        for (int j = begin; j < end; ++j) {
            if (arr[j].func_82833_r().compareToIgnoreCase(pivot.func_82833_r()) > 0) continue;
            ItemStack swapTemp = arr[++i];
            arr[i] = arr[j];
            arr[j] = swapTemp;
        }
        ItemStack swapTemp = arr[i + 1];
        arr[i + 1] = arr[end];
        arr[end] = swapTemp;
        return i + 1;
    }

    public static void sortCombineItemStacksAndToString(List<String> textList, ItemStack[] originalStacks) {
        PneumaticCraftUtils.sortCombineItemStacksAndToString(textList, originalStacks, "\u2022 ");
    }

    public static void sortCombineItemStacksAndToString(List<String> textList, ItemStack[] originalStacks, String prefix) {
        ItemStack[] stacks = Arrays.copyOf(originalStacks, originalStacks.length);
        PneumaticCraftUtils.quickSort(stacks, 0, stacks.length - 1);
        int itemCount = 0;
        ItemStack prevItemStack = ItemStack.field_190927_a;
        List<ItemStack> prevInventoryItems = null;
        for (ItemStack stack : stacks) {
            if (stack.func_190926_b()) continue;
            if (!stack.func_77969_a(prevItemStack) || prevInventoryItems != null && prevInventoryItems.size() > 0) {
                if (!prevItemStack.func_190926_b()) {
                    textList.add(prefix + PneumaticCraftUtils.convertAmountToString(itemCount) + " x " + prevItemStack.func_82833_r());
                }
                if (prevInventoryItems != null) {
                    PneumaticCraftUtils.sortCombineItemStacksAndToString(textList, prevInventoryItems.toArray(new ItemStack[0]), "\u21b3 ");
                }
                prevItemStack = stack;
                itemCount = stack.func_190916_E();
            } else {
                itemCount += stack.func_190916_E();
            }
            prevInventoryItems = PneumaticCraftUtils.getStacksInItem(stack);
        }
        if (itemCount > 0 && !prevItemStack.func_190926_b()) {
            textList.add(prefix + PneumaticCraftUtils.convertAmountToString(itemCount) + " x " + prevItemStack.func_82833_r());
            if (prevInventoryItems != null) {
                PneumaticCraftUtils.sortCombineItemStacksAndToString(textList, prevInventoryItems.toArray(new ItemStack[0]), "\u21b3 ");
            }
        }
    }

    public static List<ItemStack> getStacksInItem(@Nonnull ItemStack item) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (item.func_77973_b() instanceof IInventoryItem && !inventoryItemBlacklist.contains(item.func_77973_b())) {
            try {
                ((IInventoryItem)item.func_77973_b()).getStacksInItem(item, items);
            }
            catch (Throwable e) {
                Log.error("An InventoryItem crashed:");
                e.printStackTrace();
                inventoryItemBlacklist.add(item.func_77973_b());
            }
        } else {
            Iterator<IInventoryItem> iterator = ItemRegistry.getInstance().inventoryItems.iterator();
            while (iterator.hasNext()) {
                try {
                    iterator.next().getStacksInItem(item, items);
                }
                catch (Throwable e) {
                    Log.error("An InventoryItem crashed:");
                    e.printStackTrace();
                    iterator.remove();
                }
            }
        }
        return items;
    }

    public static int getRedstoneLevel(World world, BlockPos pos) {
        return world != null ? world.func_175687_A(pos) : 0;
    }

    public static String getPage(String urlString) throws IOException {
        StringBuilder all = new StringBuilder();
        URL myUrl = new URL(urlString);
        try (BufferedReader in = new BufferedReader(new InputStreamReader(myUrl.openStream()));){
            String line;
            while ((line = in.readLine()) != null) {
                all.append(line).append(System.getProperty("line.separator"));
            }
        }
        return all.toString();
    }

    public static RayTraceResult getEntityLookedObject(EntityLivingBase entity) {
        return PneumaticCraftUtils.getEntityLookedObject(entity, 4.5f);
    }

    public static RayTraceResult getEntityLookedObject(EntityLivingBase entity, float maxDistance) {
        Pair<Vec3d, Vec3d> vecs = PneumaticCraftUtils.getStartAndEndLookVec(entity, maxDistance);
        return entity.field_70170_p.func_72933_a((Vec3d)vecs.getLeft(), (Vec3d)vecs.getRight());
    }

    public static Pair<Vec3d, Vec3d> getStartAndEndLookVec(EntityLivingBase entity) {
        return PneumaticCraftUtils.getStartAndEndLookVec(entity, 4.5f);
    }

    public static Pair<Vec3d, Vec3d> getStartAndEndLookVec(EntityLivingBase entity, float maxDistance) {
        Vec3d entityVec = entity.field_70170_p.field_72995_K && entity instanceof EntityPlayer ? new Vec3d(entity.field_70165_t, entity.field_70163_u + 1.62, entity.field_70161_v) : new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e() - (entity.func_70093_af() ? 0.08 : 0.0), entity.field_70161_v);
        Vec3d entityLookVec = entity.func_70676_i(1.0f);
        Vec3d maxDistVec = entityVec.func_72441_c(entityLookVec.field_72450_a * (double)maxDistance, entityLookVec.field_72448_b * (double)maxDistance, entityLookVec.field_72449_c * (double)maxDistance);
        return new ImmutablePair((Object)entityVec, (Object)maxDistVec);
    }

    public static BlockPos getEntityLookedBlock(EntityLivingBase entity, float maxDistance) {
        RayTraceResult hit = PneumaticCraftUtils.getEntityLookedObject(entity, maxDistance);
        if (hit == null || hit.field_72313_a != RayTraceResult.Type.BLOCK) {
            return null;
        }
        return hit.func_178782_a();
    }

    @Nonnull
    public static ItemStack exportStackToInventory(ICapabilityProvider provider, ItemStack stack, EnumFacing side) {
        if (provider.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            IItemHandler handler = (IItemHandler)provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
            return ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)false);
        }
        return stack;
    }

    public static double distBetween(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.sqrt(PneumaticCraftUtils.distBetweenSq(x1, y1, z1, x2, y2, z2));
    }

    public static double distBetweenSq(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0) + Math.pow(z1 - z2, 2.0);
    }

    public static double distBetweenSq(Vec3i pos, double x, double y, double z) {
        return PneumaticCraftUtils.distBetweenSq((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, x, y, z);
    }

    public static double distBetweenSq(BlockPos pos1, BlockPos pos2) {
        return PneumaticCraftUtils.distBetweenSq(pos1.func_177958_n(), pos1.func_177956_o(), pos1.func_177952_p(), pos2.func_177958_n(), pos2.func_177956_o(), pos2.func_177952_p());
    }

    public static double distBetween(double x1, double y1, double x2, double y2) {
        return Math.sqrt(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0));
    }

    public static double distBetweenSq(double x1, double y1, double x2, double y2) {
        return (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2);
    }

    public static double distBetween(Vec3i pos, double x, double y, double z) {
        return PneumaticCraftUtils.distBetween((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, x, y, z);
    }

    public static double distBetween(Vec3i pos1, Vec3i pos2) {
        return PneumaticCraftUtils.distBetween(pos1, (double)pos2.func_177958_n() + 0.5, (double)pos2.func_177956_o() + 0.5, (double)pos2.func_177952_p() + 0.5);
    }

    public static double distBetween(Vec3d vec, double x, double y, double z) {
        return PneumaticCraftUtils.distBetween(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, x, y, z);
    }

    public static double distBetween(Vec3d vec1, Vec3d vec2) {
        return PneumaticCraftUtils.distBetween(vec1, vec2.field_72450_a, vec2.field_72448_b, vec2.field_72449_c);
    }

    public static boolean areStacksEqual(@Nonnull ItemStack stack1, @Nonnull ItemStack stack2, boolean checkMeta, boolean checkNBT, boolean checkOreDict, boolean checkModSimilarity) {
        boolean metaOK;
        if (stack1.func_190926_b() && stack2.func_190926_b()) {
            return true;
        }
        if (stack1.func_190926_b() || stack2.func_190926_b()) {
            return false;
        }
        if (checkModSimilarity) {
            String mod1 = stack1.func_77973_b().getRegistryName().func_110624_b();
            String mod2 = stack2.func_77973_b().getRegistryName().func_110624_b();
            return mod1.equals(mod2);
        }
        if (checkOreDict) {
            return PneumaticCraftUtils.isSameOreDictStack(stack1, stack2);
        }
        if (stack1.func_77973_b() != stack2.func_77973_b()) {
            return false;
        }
        boolean bl = metaOK = !checkMeta || stack1.func_77952_i() == stack2.func_77952_i();
        boolean nbtOK = !checkNBT || (stack1.func_77942_o() ? stack1.func_77978_p().equals((Object)stack2.func_77978_p()) : !stack2.func_77942_o());
        return metaOK && nbtOK;
    }

    public static boolean isSameOreDictStack(ItemStack stack1, ItemStack stack2) {
        int[] oredictIds;
        for (int oredictId : oredictIds = OreDictionary.getOreIDs((ItemStack)stack1)) {
            NonNullList oreDictStacks = OreDictionary.getOres((String)OreDictionary.getOreName((int)oredictId));
            for (ItemStack oreDictStack : oreDictStacks) {
                if (!OreDictionary.itemMatches((ItemStack)oreDictStack, (ItemStack)stack2, (boolean)false)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isBlockLiquid(Block block) {
        return block instanceof BlockLiquid || block instanceof IFluidBlock;
    }

    public static String getOrientationName(EnumFacing dir) {
        switch (dir) {
            case UP: {
                return "Top";
            }
            case DOWN: {
                return "Bottom";
            }
            case NORTH: {
                return "North";
            }
            case SOUTH: {
                return "South";
            }
            case EAST: {
                return "East";
            }
            case WEST: {
                return "West";
            }
        }
        return "Unknown";
    }

    public static void dropItemOnGround(ItemStack stack, World world, BlockPos pos) {
        PneumaticCraftUtils.dropItemOnGround(stack, world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
    }

    public static void dropItemOnGround(ItemStack stack, World world, double x, double y, double z) {
        float dX = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        float dY = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        float dZ = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        EntityItem entityItem = new EntityItem(world, x + (double)dX, y + (double)dY, z + (double)dZ, new ItemStack(stack.func_77973_b(), stack.func_190916_E(), stack.func_77952_i()));
        if (stack.func_77942_o()) {
            entityItem.func_92059_d().func_77982_d(stack.func_77978_p().func_74737_b());
        }
        float factor = 0.05f;
        entityItem.field_70159_w = world.field_73012_v.nextGaussian() * (double)factor;
        entityItem.field_70181_x = world.field_73012_v.nextGaussian() * (double)factor + (double)0.2f;
        entityItem.field_70179_y = world.field_73012_v.nextGaussian() * (double)factor;
        world.func_72838_d((Entity)entityItem);
        stack.func_190920_e(0);
    }

    public static void dropItemOnGroundPrecisely(ItemStack stack, World world, double x, double y, double z) {
        EntityItem entityItem = new EntityItem(world, x, y, z, new ItemStack(stack.func_77973_b(), stack.func_190916_E(), stack.func_77952_i()));
        if (stack.func_77942_o()) {
            entityItem.func_92059_d().func_77982_d(stack.func_77978_p().func_74737_b());
        }
        entityItem.field_70159_w = 0.0;
        entityItem.field_70181_x = 0.0;
        entityItem.field_70179_y = 0.0;
        world.func_72838_d((Entity)entityItem);
        stack.func_190920_e(0);
    }

    public static TileEntity getTileEntity(BlockPos pos, int dimension) {
        WorldServer world = DimensionManager.getWorld((int)dimension);
        if (world != null && world.func_175667_e(pos)) {
            return world.func_175625_s(pos);
        }
        return null;
    }

    public static EntityPlayer getPlayerFromId(String uuid) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(UUID.fromString(uuid));
    }

    public static EntityPlayer getPlayerFromId(UUID uuid) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(uuid);
    }

    public static EntityPlayer getPlayerFromName(String name) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(name);
    }

    public static boolean isPlayerOp(EntityPlayer player) {
        return player.func_70003_b(2, "PneumaticCraftIsPlayerOp");
    }

    private static RayTraceResult raytraceEntityBlocks(EntityLivingBase entity, double range) {
        Pair<Vec3d, Vec3d> startAndEnd = PneumaticCraftUtils.getStartAndEndLookVec(entity, (float)range);
        return entity.field_70170_p.func_147447_a((Vec3d)startAndEnd.getLeft(), (Vec3d)startAndEnd.getRight(), false, false, true);
    }

    public static RayTraceResult getMouseOverServer(EntityLivingBase lookingEntity, double range) {
        RayTraceResult result = PneumaticCraftUtils.raytraceEntityBlocks(lookingEntity, range);
        double rangeSq = range * range;
        Pair<Vec3d, Vec3d> startAndEnd = PneumaticCraftUtils.getStartAndEndLookVec(lookingEntity, (float)range);
        Vec3d eyePos = (Vec3d)startAndEnd.getLeft();
        if (result != null) {
            rangeSq = result.field_72307_f.func_72436_e(eyePos);
        }
        double rangeSq2 = rangeSq;
        Vec3d hitVec = null;
        Entity focusedEntity = null;
        Vec3d lookVec = lookingEntity.func_70040_Z().func_186678_a(range + 1.0);
        AxisAlignedBB box = lookingEntity.func_174813_aQ().func_72314_b(lookVec.field_72450_a, lookVec.field_72448_b, lookVec.field_72449_c);
        for (Entity entity : lookingEntity.field_70170_p.func_175674_a((Entity)lookingEntity, box, Entity::func_70067_L)) {
            double rangeSq3;
            AxisAlignedBB aabb = entity.func_174813_aQ().func_186662_g((double)entity.func_70111_Y());
            RayTraceResult rtr = aabb.func_72327_a(eyePos, (Vec3d)startAndEnd.getRight());
            if (aabb.func_72318_a(eyePos)) {
                if (!(rangeSq2 >= 0.0)) continue;
                focusedEntity = entity;
                hitVec = rtr == null ? eyePos : rtr.field_72307_f;
                rangeSq2 = 0.0;
                continue;
            }
            if (rtr == null || !((rangeSq3 = eyePos.func_72436_e(rtr.field_72307_f)) < rangeSq2) && rangeSq2 != 0.0) continue;
            if (entity == entity.func_184187_bx() && !entity.canRiderInteract()) {
                if (rangeSq2 != 0.0) continue;
                focusedEntity = entity;
                hitVec = rtr.field_72307_f;
                continue;
            }
            focusedEntity = entity;
            hitVec = rtr.field_72307_f;
            rangeSq2 = rangeSq3;
        }
        if (focusedEntity != null && (rangeSq2 < rangeSq || result == null)) {
            result = new RayTraceResult(focusedEntity, hitVec);
        }
        return result;
    }

    public static PathFinder getPathFinder() {
        WalkNodeProcessor processor = new WalkNodeProcessor();
        processor.func_186317_a(true);
        return new PathFinder((NodeProcessor)processor);
    }

    public static boolean tryPlaceBlock(World w, BlockPos pos, EntityPlayer player, EnumFacing face, IBlockState newState) {
        BlockSnapshot snapshot = BlockSnapshot.getBlockSnapshot((World)w, (BlockPos)pos);
        BlockEvent.PlaceEvent event = ForgeEventFactory.onPlayerBlockPlace((EntityPlayer)player, (BlockSnapshot)snapshot, (EnumFacing)face, (EnumHand)EnumHand.MAIN_HAND);
        if (!event.isCanceled()) {
            w.func_175656_a(pos, newState);
            return true;
        }
        return false;
    }

    public static EntityLiving createDummyEntity(EntityPlayer player) {
        EntityZombie dummy = new EntityZombie(player.field_70170_p){

            protected void func_110147_ax() {
                super.func_110147_ax();
                this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(150.0);
            }
        };
        dummy.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        return dummy;
    }

    public static boolean consumeInventoryItem(InventoryPlayer inv, Item item) {
        for (int i = 0; i < inv.field_70462_a.size(); ++i) {
            if (((ItemStack)inv.field_70462_a.get(i)).func_77973_b() != item) continue;
            ((ItemStack)inv.field_70462_a.get(i)).func_190918_g(1);
            if (((ItemStack)inv.field_70462_a.get(i)).func_190916_E() <= 0) {
                inv.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
            }
            return true;
        }
        return false;
    }

    public static boolean consumeInventoryItem(InventoryPlayer inv, ItemStack item) {
        for (int i = 0; i < inv.field_70462_a.size(); ++i) {
            if (!ItemStack.func_179545_c((ItemStack)((ItemStack)inv.field_70462_a.get(i)), (ItemStack)item)) continue;
            ((ItemStack)inv.field_70462_a.get(i)).func_190918_g(1);
            if (((ItemStack)inv.field_70462_a.get(i)).func_190916_E() <= 0) {
                inv.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
            }
            return true;
        }
        return false;
    }

    public static TileEntity getTileEntitySafely(IBlockAccess world, BlockPos pos) {
        return world instanceof ChunkCache ? ((ChunkCache)world).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK) : world.func_175625_s(pos);
    }

    public static ResourceLocation RL(String path) {
        return new ResourceLocation("pneumaticcraft", path);
    }

    public static String xlate(String s) {
        return PneumaticCraftRepressurized.proxy.xlate(s);
    }

    public static String dyeColorDesc(int c) {
        return TextFormatting.BOLD + WordUtils.capitalize((String)PneumaticCraftUtils.xlate(EnumDyeColor.func_176766_a((int)c).func_176762_d())) + TextFormatting.RESET;
    }

    static {
        for (int i = 0; i < 500; ++i) {
            double angle = Math.PI * 2 * (double)i / 500.0;
            PneumaticCraftUtils.sin[i] = Math.sin(angle);
            PneumaticCraftUtils.cos[i] = Math.cos(angle);
        }
    }
}

