/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.block;

import crafttweaker.api.block.IBlockDefinition;
import crafttweaker.api.creativetabs.ICreativeTab;
import crafttweaker.api.entity.IEntity;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.world.IBlockAccess;
import crafttweaker.api.world.IBlockPos;
import crafttweaker.api.world.IFacing;
import crafttweaker.api.world.IWorld;
import crafttweaker.mc1120.block.MCBlockState;
import crafttweaker.mc1120.creativetabs.MCCreativeTab;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class MCBlockDefinition
implements IBlockDefinition {
    private final Block block;

    public MCBlockDefinition(Block block) {
        this.block = block;
    }

    public Block getInternalBlock() {
        return this.block;
    }

    @Override
    public String getId() {
        return this.block.getRegistryName().toString();
    }

    @Override
    public String getDisplayName() {
        return this.block.func_149732_F();
    }

    @Override
    public Object getInternal() {
        return this.block;
    }

    @Override
    public void setLightOpacity(int lightOpacity) {
        this.block.func_149713_g(lightOpacity);
    }

    @Override
    public void setLightLevel(float lightLevel) {
        this.block.func_149715_a(lightLevel);
    }

    @Override
    public void setResistance(float resistance) {
        this.block.func_149752_b(resistance);
    }

    @Override
    public void setHardness(float hardness) {
        this.block.func_149711_c(hardness);
    }

    @Override
    public float getHardness() {
        return this.block.field_149782_v;
    }

    @Override
    public void setUnbreakable() {
        this.block.func_149722_s();
    }

    @Override
    public boolean getTickRandomly() {
        return this.block.func_149653_t();
    }

    @Override
    public void setTickRandomly(boolean tickRandomly) {
        this.block.func_149675_a(tickRandomly);
    }

    @Override
    public void setHarvestLevel(String toolClass, int level) {
        this.setHarvestLevel(toolClass, level, null);
    }

    @Override
    public void setHarvestLevel(String toolClass, int level, crafttweaker.api.block.IBlockState state) {
        if (state == null) {
            this.block.setHarvestLevel(toolClass, level);
        } else {
            this.block.setHarvestLevel(toolClass, level, CraftTweakerMC.getBlockState(state));
        }
    }

    @Override
    public int getHarvestLevel() {
        return this.block.getHarvestLevel(this.block.func_176223_P());
    }

    @Override
    public int getHarvestLevel(crafttweaker.api.block.IBlockState state) {
        return this.block.getHarvestLevel(CraftTweakerMC.getBlockState(state));
    }

    @Override
    public String getHarvestTool() {
        return Optional.ofNullable(this.block.getHarvestTool(this.block.func_176223_P())).orElse("");
    }

    @Override
    public String getHarvestTool(crafttweaker.api.block.IBlockState state) {
        return Optional.ofNullable(this.block.getHarvestTool(CraftTweakerMC.getBlockState(state))).orElse("");
    }

    @Override
    public int tickRate(IWorld world) {
        return this.block.func_149738_a((World)world.getInternal());
    }

    @Override
    public boolean canPlaceBlockOnSide(IWorld world, IBlockPos pos, IFacing facing) {
        return this.block.func_176198_a((World)world.getInternal(), (BlockPos)pos.getInternal(), (EnumFacing)facing.getInternal());
    }

    @Override
    public boolean canPlaceBlockAt(IWorld world, IBlockPos pos) {
        return this.block.func_176196_c((World)world.getInternal(), (BlockPos)pos.getInternal());
    }

    @Override
    public boolean canSpawnInBlock() {
        return this.block.func_181623_g();
    }

    @Override
    public String getUnlocalizedName() {
        return this.block.func_149739_a();
    }

    @Override
    public ICreativeTab getCreativeTabToDisplayOn() {
        return MCCreativeTab.getICreativeTab(this.block.func_149708_J());
    }

    @Override
    public void setCreativeTab(ICreativeTab creativeTab) {
        this.block.func_149647_a(CraftTweakerMC.getCreativeTabs(creativeTab));
    }

    @Override
    public crafttweaker.api.block.IBlockState getDefaultState() {
        return new MCBlockState(this.block.func_176223_P());
    }

    @Override
    public float getSlipperiness(crafttweaker.api.block.IBlockState state, IBlockAccess access, IBlockPos pos, IEntity entity) {
        return this.block.getSlipperiness((IBlockState)state.getInternal(), (net.minecraft.world.IBlockAccess)access.getInternal(), (BlockPos)pos.getInternal(), (Entity)entity.getInternal());
    }

    @Override
    public void setDefaultSlipperiness(float defaultSlipperiness) {
        this.block.setDefaultSlipperiness(defaultSlipperiness);
    }

    @Override
    public crafttweaker.api.block.IBlockState getStateFromMeta(int meta) {
        return new MCBlockState(this.block.func_176203_a(meta));
    }

    @Override
    public boolean isToolEffective(String type, crafttweaker.api.block.IBlockState state) {
        return this.block.isToolEffective(type, CraftTweakerMC.getBlockState(state));
    }
}

