/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;
import reborncore.RebornCore;

public class OreUtil {
    public static ArrayList<String> oreNames = new ArrayList();

    public static boolean doesOreExistAndValid(String name) {
        if (OreDictionary.doesOreNameExist((String)name)) {
            NonNullList oreList = OreDictionary.getOres((String)name);
            return !oreList.isEmpty();
        }
        return false;
    }

    public static ItemStack getStackFromName(String name) {
        return OreUtil.getStackFromName(name, 1);
    }

    public static ItemStack getStackFromName(String name, int stackSize) {
        NonNullList oreList = OreDictionary.getOres((String)name);
        if (oreList.isEmpty()) {
            throw new RuntimeException("Failed to get ore name:" + name);
        }
        ItemStack stack = ((ItemStack)oreList.get(0)).func_77946_l();
        stack.func_190920_e(stackSize);
        return stack;
    }

    public static void scanForOres() {
        String[] validPrefixes = new String[]{"ingot", "ore", "gem", "crushed", "plate", "nugget", "dustSmall", "dustTiny", "dust", "block"};
        for (String oreDicName : OreDictionary.getOreNames()) {
            for (String prefix : validPrefixes) {
                if (!oreDicName.startsWith(prefix) || !OreUtil.isValidName(oreDicName) || oreNames.contains(oreDicName.replace(prefix, "").toLowerCase())) continue;
                oreNames.add(oreDicName.replace(prefix, "").toLowerCase());
            }
        }
        RebornCore.logHelper.info("Found " + oreNames.size() + " ores");
    }

    public static boolean isValidName(String name) {
        String[] invalidNames;
        for (String invalidName : invalidNames = new String[]{"blockMetal"}) {
            if (!name.equalsIgnoreCase(invalidName)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidID(int id) {
        return OreUtil.isValidName(OreDictionary.getOreName((int)id));
    }

    public static void remove(String name) throws NoSuchFieldException, IllegalAccessException {
        int id = OreDictionary.getOreID((String)name);
        Field field = OreDictionary.class.getDeclaredField("idToStack");
        field.setAccessible(true);
        List idToStack = (List)field.get(null);
        idToStack.remove(id);
        idToStack.add(id, NonNullList.func_191197_a((int)0, (Object)ItemStack.field_190927_a));
        OreDictionary.rebakeMap();
    }

    public static boolean hasIngot(String name) {
        return OreUtil.doesOreExistAndValid("ingot" + OreUtil.capitalizeFirstLetter(name));
    }

    public static boolean hasGem(String name) {
        return OreUtil.doesOreExistAndValid("gem" + OreUtil.capitalizeFirstLetter(name));
    }

    public static boolean hasOre(String name) {
        return OreUtil.doesOreExistAndValid("ore" + OreUtil.capitalizeFirstLetter(name));
    }

    public static boolean hasCrushedOre(String name) {
        return OreUtil.doesOreExistAndValid("crushed" + OreUtil.capitalizeFirstLetter(name));
    }

    public static boolean hasPlate(String name) {
        return OreUtil.doesOreExistAndValid("plate" + OreUtil.capitalizeFirstLetter(name));
    }

    public static boolean hasNugget(String name) {
        return OreUtil.doesOreExistAndValid("nugget" + OreUtil.capitalizeFirstLetter(name));
    }

    public static boolean hasDustSmall(String name) {
        return OreUtil.doesOreExistAndValid("dustSmall" + OreUtil.capitalizeFirstLetter(name));
    }

    public static boolean hasDust(String name) {
        return OreUtil.doesOreExistAndValid("dust" + OreUtil.capitalizeFirstLetter(name));
    }

    public static boolean hasBlock(String name) {
        return OreUtil.doesOreExistAndValid("block" + OreUtil.capitalizeFirstLetter(name));
    }

    public static String capitalizeFirstLetter(String original) {
        if (original.length() == 0) {
            return original;
        }
        return original.substring(0, 1).toUpperCase() + original.substring(1);
    }

    public static void registerOre(String name, Item ore) {
        OreUtil.registerOre(name, new ItemStack(ore));
    }

    public static void registerOre(String name, Block ore) {
        OreUtil.registerOre(name, new ItemStack(ore));
    }

    public static void registerOre(String name, @Nonnull ItemStack ore) {
        OreDictionary.registerOre((String)OreUtil.sanitiseString(name), (ItemStack)ore);
    }

    public static String sanitiseString(String input) {
        StringBuilder builder = new StringBuilder();
        String[] split = input.split("_");
        boolean isFirst = true;
        for (String str : split) {
            builder.append(isFirst ? str : OreUtil.capitalizeFirstLetter(str));
        }
        return builder.toString();
    }
}

