/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.threng.util;

import io.github.phantamanta44.libnine.util.render.TextureRegion;
import io.github.phantamanta44.libnine.util.render.TextureResource;

public class ButtonRender {
    private final TextureRegion normal;
    private final TextureRegion disabled;
    private final TextureRegion hovered;

    public ButtonRender(TextureResource sheet, int x, int y, int width, int height) {
        this.normal = sheet.getRegion(x, y, width, height);
        this.disabled = sheet.getRegion(x, y + height, width, height);
        this.hovered = sheet.getRegion(x, y + height * 2, width, height);
    }

    public TextureRegion getSprite(State state) {
        switch (state) {
            case NORMAL: {
                return this.normal;
            }
            case DISABLED: {
                return this.disabled;
            }
            case HOVERED: {
                return this.hovered;
            }
        }
        throw new IllegalArgumentException("Bad button state: " + (Object)((Object)state));
    }

    public static enum State {
        NORMAL,
        DISABLED,
        HOVERED;

    }
}

