/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.guis;

import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import reborncore.common.network.INetworkPacket;
import reborncore.common.network.NetworkManager;
import vswe.stevescarts.containers.slots.SlotBase;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.guis.GuiBase;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ModuleCountPair;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.modules.ModuleBase;
import vswe.stevescarts.packet.PacketReturnCart;

@SideOnly(value=Side.CLIENT)
public class GuiMinecart
extends GuiBase {
    private static ResourceLocation textureLeft = ResourceHelper.getResource("/gui/guiBase1.png");
    private static ResourceLocation textureRight = ResourceHelper.getResource("/gui/guiBase2.png");
    private static ResourceLocation textureReturn = ResourceHelper.getResource("/gui/return.png");
    private boolean isScrolling;
    private int[] scrollBox = new int[]{450, 15, 18, 225};
    private EntityMinecartModular cart;
    private int[] returnButton = new int[]{324, 173, 24, 12};

    public GuiMinecart(InventoryPlayer invPlayer, EntityMinecartModular cart) {
        super(cart.getCon(invPlayer));
        this.setup(cart);
    }

    protected void setup(EntityMinecartModular cart) {
        this.cart = cart;
        this.setXSize(478);
        this.setYSize(256);
    }

    @Override
    public void drawGuiForeground(int x, int y) {
        GlStateManager.func_179140_f();
        if (this.cart.getModules() != null) {
            ModuleBase thief = this.cart.getInterfaceThief();
            if (thief != null) {
                this.drawModuleForeground(thief);
                this.drawModuleMouseOver(thief, x, y);
            } else {
                for (ModuleBase module : this.cart.getModules()) {
                    this.drawModuleForeground(module);
                }
                this.renderModuleListText(x, y);
                for (ModuleBase module : this.cart.getModules()) {
                    this.drawModuleMouseOver(module, x, y);
                }
                this.renderModuleListMouseOver(x, y);
                this.renderReturnMouseOver(x, y);
            }
        }
        GlStateManager.func_179145_e();
    }

    @Override
    public void drawGuiBackground(float f, int x, int y) {
        GlStateManager.func_179140_f();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int j = this.getGuiLeft();
        int k = this.getGuiTop();
        ResourceHelper.bindResource(textureLeft);
        this.func_73729_b(j, k, 0, 0, 256, this.field_147000_g);
        ResourceHelper.bindResource(textureRight);
        this.func_73729_b(j + 256, k, 0, 0, this.field_146999_f - 256, this.field_147000_g);
        ModuleBase thief = this.cart.getInterfaceThief();
        if (thief != null) {
            this.drawModuleSlots(thief);
            this.drawModuleBackground(thief, x, y);
            this.drawModuleBackgroundItems(thief, x, y);
            for (ModuleBase module : this.cart.getModules()) {
                if (!module.hasGui() || !module.hasSlots()) continue;
                ArrayList<SlotBase> slotsList = module.getSlots();
                for (SlotBase slot : slotsList) {
                    this.resetSlot(slot);
                }
            }
        } else if (this.cart.getModules() != null) {
            this.func_73729_b(j + this.scrollBox[0], k + this.scrollBox[1], 222, 24, this.scrollBox[2], this.scrollBox[3]);
            this.func_73729_b(j + this.scrollBox[0] + 2, k + this.scrollBox[1] + 2 + this.cart.getScrollY(), 240, 26 + (this.cart.canScrollModules ? 0 : 25), 14, 25);
            for (ModuleBase module : this.cart.getModules()) {
                this.drawModuleSlots(module);
            }
            for (ModuleBase module : this.cart.getModules()) {
                this.drawModuleBackground(module, x, y);
            }
            this.renderModuleList(x, y);
            this.renderReturnButton(x, y);
            for (ModuleBase module : this.cart.getModules()) {
                this.drawModuleBackgroundItems(module, x, y);
            }
        }
        GlStateManager.func_179145_e();
    }

    private void renderModuleList(int x, int y) {
        x -= this.getGuiLeft();
        y -= this.getGuiTop();
        ArrayList<ModuleCountPair> moduleCounts = this.cart.getModuleCounts();
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        for (int i = 0; i < moduleCounts.size(); ++i) {
            ModuleCountPair count = moduleCounts.get(i);
            float alpha = this.inRect(x, y, this.getModuleDisplayX(i), this.getModuleDisplayY(i), 16, 16) ? 1.0f : 0.05f;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            this.drawModuleIcon(count.getData(), this.getGuiLeft() + this.getModuleDisplayX(i), this.getGuiTop() + this.getModuleDisplayY(i), 1.0f, 1.0f, 0.0f, 0.0f);
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderReturnButton(int x, int y) {
        ResourceHelper.bindResource(textureReturn);
        int uy = this.inRect(x -= this.getGuiLeft(), y -= this.getGuiTop(), this.returnButton) ? 12 : 0;
        this.func_73729_b(this.returnButton[0] + this.getGuiLeft(), this.returnButton[1] + this.getGuiTop(), 0, uy, this.returnButton[2], this.returnButton[3]);
    }

    private void renderModuleListText(int x, int y) {
        x -= this.getGuiLeft();
        y -= this.getGuiTop();
        ArrayList<ModuleCountPair> moduleCounts = this.cart.getModuleCounts();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getFontRenderer().func_78276_b(this.cart.getCartName(), 5, 172, 0x404040);
        GlStateManager.func_179147_l();
        for (int i = 0; i < moduleCounts.size(); ++i) {
            ModuleCountPair count = moduleCounts.get(i);
            if (count.getCount() == 1) continue;
            int alpha = (int)((this.inRect(x, y, this.getModuleDisplayX(i), this.getModuleDisplayY(i), 16, 16) ? 1.0f : 0.75f) * 256.0f);
            String str = String.valueOf(count.getCount());
            this.getFontRenderer().func_175063_a(str, (float)(this.getModuleDisplayX(i) + 16 - this.getFontRenderer().func_78256_a(str)), (float)(this.getModuleDisplayY(i) + 8), 0xFFFFFF | alpha << 24);
        }
        GlStateManager.func_179084_k();
    }

    private void renderModuleListMouseOver(int x, int y) {
        x -= this.getGuiLeft();
        y -= this.getGuiTop();
        ArrayList<ModuleCountPair> moduleCounts = this.cart.getModuleCounts();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i = 0; i < moduleCounts.size(); ++i) {
            ModuleCountPair count = moduleCounts.get(i);
            if (!this.inRect(x, y, this.getModuleDisplayX(i), this.getModuleDisplayY(i), 16, 16)) continue;
            for (ModuleBase module : this.cart.getModules()) {
                if (module.getClass() != count.getData().getModuleClass()) continue;
                if (!module.hasExtraData()) break;
                count.setExtraData(module.getExtraData());
                break;
            }
            this.drawMouseOver(count.toString(), x, y);
        }
    }

    private void renderReturnMouseOver(int x, int y) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.inRect(x -= this.getGuiLeft(), y -= this.getGuiTop(), this.returnButton)) {
            this.drawMouseOver(Localization.GUI.CART.RETURN.translate(new String[0]), x, y);
        }
    }

    private int getModuleDisplayX(int id) {
        return id % 8 * 18 + 7;
    }

    private int getModuleDisplayY(int id) {
        return id / 8 * 18 + 182;
    }

    @Override
    public void mouseClick(int x, int y, int button) {
        super.mouseClick(x, y, button);
        ModuleBase thief = this.cart.getInterfaceThief();
        if (thief != null) {
            this.handleModuleMouseClicked(thief, x, y, button);
        } else if (this.cart.getModules() != null) {
            if (this.inRect(x - this.getGuiLeft(), y - this.getGuiTop(), this.scrollBox[0], this.scrollBox[1], this.scrollBox[2], this.scrollBox[3])) {
                this.isScrolling = true;
            }
            for (ModuleBase module : this.cart.getModules()) {
                this.handleModuleMouseClicked(module, x, y, button);
            }
            if (this.inRect(x - this.getGuiLeft(), y - this.getGuiTop(), this.returnButton)) {
                NetworkManager.sendToServer((INetworkPacket)new PacketReturnCart());
            }
        }
    }

    protected boolean inRect(int x, int y, int x1, int y1, int sizeX, int sizeY) {
        return x >= x1 && x <= x1 + sizeX && y >= y1 && y <= y1 + sizeY;
    }

    @Override
    public void mouseMoved(int x, int y, int button) {
        super.mouseMoved(x, y, button);
        if (this.isScrolling) {
            int temp = y - this.getGuiTop() - 12 - (this.scrollBox[1] + 2);
            if (temp < 0) {
                temp = 0;
            } else if (temp > 198) {
                temp = 198;
            }
            this.cart.setScrollY(temp);
        }
        if (button != -1) {
            this.isScrolling = false;
        }
        if (this.cart.getModules() != null) {
            ModuleBase thief = this.cart.getInterfaceThief();
            if (thief != null) {
                this.handleModuleMouseMoved(thief, x, y, button);
            } else {
                for (ModuleBase module : this.cart.getModules()) {
                    this.handleModuleMouseMoved(module, x, y, button);
                }
            }
        }
    }

    @Override
    public void keyPress(char character, int extraInformation) {
        super.keyPress(character, extraInformation);
        if (this.cart.getModules() != null) {
            ModuleBase thief = this.cart.getInterfaceThief();
            if (thief != null) {
                this.handleModuleKeyPress(thief, character, extraInformation);
            } else {
                for (ModuleBase module : this.cart.getModules()) {
                    this.handleModuleKeyPress(module, character, extraInformation);
                }
            }
        }
    }

    @Override
    public boolean disableStandardKeyFunctionality() {
        if (this.cart.getModules() != null) {
            ModuleBase thief = this.cart.getInterfaceThief();
            if (thief != null) {
                return thief.disableStandardKeyFunctionality();
            }
            for (ModuleBase module : this.cart.getModules()) {
                if (!module.disableStandardKeyFunctionality()) continue;
                return true;
            }
        }
        return false;
    }

    private void drawModuleForeground(ModuleBase module) {
        if (module.hasGui()) {
            module.drawForeground(this);
            if (module.useButtons()) {
                module.drawButtonText(this);
            }
        }
    }

    private void drawModuleMouseOver(ModuleBase module, int x, int y) {
        if (module.hasGui()) {
            module.drawMouseOver(this, x - this.getGuiLeft() - module.getX(), y - this.getGuiTop() - module.getY());
            if (module.useButtons()) {
                module.drawButtonOverlays(this, x - this.getGuiLeft() - module.getX(), y - this.getGuiTop() - module.getY());
            }
        }
    }

    private void drawModuleSlots(ModuleBase module) {
        if (module.hasGui() && module.hasSlots()) {
            ArrayList<SlotBase> slotsList = module.getSlots();
            for (SlotBase slot : slotsList) {
                boolean drawAll;
                int[] rect = new int[]{slot.getX() + 1, slot.getY() + 1, 16, 16};
                module.handleScroll(rect);
                boolean bl = drawAll = rect[3] == 16;
                if (drawAll) {
                    slot.field_75223_e = slot.getX() + module.getX() + 1;
                    slot.field_75221_f = slot.getY() + module.getY() + 1 - this.cart.getRealScrollY();
                } else {
                    this.resetSlot(slot);
                }
                module.drawImage(this, slot.getX(), slot.getY(), this.field_146999_f - 256, 0, 18, 18);
                if (drawAll) continue;
                module.drawImage(this, slot.getX() + 1, slot.getY() + 1, this.field_146999_f - 256 + 18, 1, 16, 16);
            }
        }
    }

    private void resetSlot(SlotBase slot) {
        slot.field_75223_e = -9001;
        slot.field_75221_f = -9001;
    }

    private void drawModuleBackground(ModuleBase module, int x, int y) {
        if (module.hasGui()) {
            module.drawBackground(this, x - this.getGuiLeft() - module.getX(), y - this.getGuiTop() - module.getY());
            if (module.useButtons()) {
                module.drawButtons(this, x - this.getGuiLeft() - module.getX(), y - this.getGuiTop() - module.getY());
            }
        }
    }

    private void drawModuleBackgroundItems(ModuleBase module, int x, int y) {
        if (module.hasGui()) {
            module.drawBackgroundItems(this, x - this.getGuiLeft() - module.getX(), y - this.getGuiTop() - module.getY());
        }
    }

    private void handleModuleMouseClicked(ModuleBase module, int x, int y, int button) {
        module.mouseClicked(this, x - this.getGuiLeft() - module.getX(), y - this.getGuiTop() - module.getY(), button);
        if (module.useButtons()) {
            module.mouseClickedButton(this, x - this.getGuiLeft() - module.getX(), y - this.getGuiTop() - module.getY(), button);
        }
    }

    private void handleModuleMouseMoved(ModuleBase module, int x, int y, int button) {
        module.mouseMovedOrUp(this, x - this.getGuiLeft() - module.getX(), y - this.getGuiTop() - module.getY(), button);
    }

    private void handleModuleKeyPress(ModuleBase module, char character, int extraInformation) {
        module.keyPress(this, character, extraInformation);
    }

    @Override
    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int d = Mouse.getDWheel();
        if (d != -1) {
            int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
            int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
            if (d < 0) {
                d = -1;
            }
            if (d > 0) {
                d = 1;
            }
            if (this.inRect(x - this.getGuiLeft(), y - this.getGuiTop(), 0, 0, this.field_146999_f, this.field_147000_g)) {
                int moduleSize = this.cart.modularSpaceHeight;
                int scroll = this.cart.getScrollY() + -d * 7500 / (moduleSize - 168);
                scroll = MathHelper.func_76125_a((int)scroll, (int)0, (int)198);
                this.cart.setScrollY(scroll);
            }
        }
    }
}

