/*
 * Decompiled with CFR 0.152.
 */
package org.dave.ocsensors.integration.nbt;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Map;
import org.dave.ocsensors.integration.PrefixRegistry;
import org.dave.ocsensors.integration.nbt.NbtConfig;
import org.dave.ocsensors.integration.nbt.NbtIntegration;
import org.dave.ocsensors.utility.Logz;

public class NbtConfigSerializer
implements JsonDeserializer<NbtConfig> {
    public NbtConfig deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonArray()) {
            Logz.info("Invalid nbt config! Not a json array!", new Object[0]);
            return null;
        }
        for (JsonElement entry : json.getAsJsonArray()) {
            Class<?> mappingClass;
            if (!entry.isJsonObject()) {
                Logz.info("Invalid nbt config! Skipping entry: not a JSON object!", new Object[0]);
                continue;
            }
            JsonObject teObject = entry.getAsJsonObject();
            if (!teObject.has("class")) {
                Logz.info("Invalid nbt config! Skipping TileEntity entry: missing 'class' property!", new Object[0]);
                continue;
            }
            if (!teObject.has("rules")) {
                Logz.info("Invalid nbt config! Skipping TileEntity entry: missing 'rules' property!", new Object[0]);
                continue;
            }
            String className = teObject.get("class").getAsString();
            try {
                mappingClass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                Logz.info("Class not found: %s", className);
                continue;
            }
            String prefix = "";
            if (teObject.has("prefix")) {
                String rawPrefix = teObject.get("prefix").getAsString();
                PrefixRegistry.addSupportedPrefix(NbtIntegration.class, rawPrefix);
                prefix = rawPrefix + ".";
            }
            JsonObject rules = teObject.get("rules").getAsJsonObject();
            for (Map.Entry rule : rules.entrySet()) {
                NbtIntegration.addMapping(mappingClass, prefix + (String)rule.getKey(), ((JsonElement)rule.getValue()).getAsString());
            }
        }
        return null;
    }
}

