/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.relic;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.IRelic;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;
import vazkii.botania.common.item.relic.ItemRelic;

public abstract class ItemRelicBauble
extends ItemBauble
implements IRelic {
    private final ItemRelic dummy = new ItemRelic("dummy");

    public ItemRelicBauble(String name) {
        super(name);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean held) {
        if (entity instanceof EntityPlayer) {
            this.dummy.updateRelic(stack, (EntityPlayer)entity);
        }
    }

    @Override
    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        super.onWornTick(stack, player);
        if (player instanceof EntityPlayer) {
            EntityPlayer ePlayer = (EntityPlayer)player;
            this.dummy.updateRelic(stack, ePlayer);
            if (this.dummy.isRightPlayer(ePlayer, stack)) {
                this.onValidPlayerWornTick(stack, ePlayer);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addHiddenTooltip(ItemStack par1ItemStack, World world, List<String> stacks, ITooltipFlag flags) {
        super.addHiddenTooltip(par1ItemStack, world, stacks, flags);
        this.dummy.addBindInfo(stacks, par1ItemStack);
    }

    public void onValidPlayerWornTick(ItemStack stack, EntityPlayer player) {
    }

    @Override
    public boolean canEquip(ItemStack stack, EntityLivingBase player) {
        return player instanceof EntityPlayer && this.dummy.isRightPlayer((EntityPlayer)player, stack);
    }

    @Override
    public void bindToUUID(UUID uuid, ItemStack stack) {
        this.dummy.bindToUUID(uuid, stack);
    }

    @Override
    public UUID getSoulbindUUID(ItemStack stack) {
        return this.dummy.getSoulbindUUID(stack);
    }

    @Override
    public boolean hasUUID(ItemStack stack) {
        return this.dummy.hasUUID(stack);
    }

    @Nonnull
    public EnumRarity func_77613_e(ItemStack stack) {
        return BotaniaAPI.rarityRelic;
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return Integer.MAX_VALUE;
    }
}

