/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.compat;

import erogenousbeef.bigreactors.common.BRLog;
import erogenousbeef.bigreactors.common.compat.ModCompact;
import it.zerono.mods.zerocore.lib.IModInitializationHandler;
import it.zerono.mods.zerocore.lib.NonNullSupplier;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModAPIManager;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public final class CompatManager
implements IModInitializationHandler {
    public static final CompatManager INSTANCE = new CompatManager();
    private Map<String, String> _modList = new HashMap<String, String>();
    private ModCompact[] _helpers = null;

    public static boolean isModLoaded(@Nonnull String modId) {
        return Loader.isModLoaded((String)modId);
    }

    public static boolean isApiLoaded(@Nonnull String api) {
        return ModAPIManager.INSTANCE.hasAPI(api);
    }

    public static void ifPresent(@Nonnull String modId, @Nonnull Runnable present) {
        if (CompatManager.isModLoaded(modId)) {
            present.run();
        }
    }

    public static void ifPresent(@Nonnull String modId, @Nonnull NonNullSupplier<Runnable> present) {
        if (CompatManager.isModLoaded(modId)) {
            ((Runnable)present.get()).run();
        }
    }

    public static void ifPresentOrElse(@Nonnull String modId, @Nonnull Runnable present, @Nonnull Runnable notPresent) {
        if (CompatManager.isModLoaded(modId)) {
            present.run();
        } else {
            notPresent.run();
        }
    }

    public static void ifPresentOrElse(@Nonnull String modId, @Nonnull NonNullSupplier<Runnable> present, @Nonnull NonNullSupplier<Runnable> notPresent) {
        if (CompatManager.isModLoaded(modId)) {
            ((Runnable)present.get()).run();
        } else {
            ((Runnable)notPresent.get()).run();
        }
    }

    public void onPreInit(FMLPreInitializationEvent event) {
        this.loadHelpers();
        for (ModCompact helper : this._helpers) {
            helper.onPreInit(event);
        }
    }

    public void onInit(FMLInitializationEvent event) {
        for (ModCompact helper : this._helpers) {
            helper.onInit(event);
        }
    }

    public void onPostInit(FMLPostInitializationEvent event) {
        for (ModCompact helper : this._helpers) {
            helper.onPostInit(event);
        }
    }

    private CompatManager() {
        this._modList.put("computercraft", "ModComputerCraft");
        this._modList.put("mekanism", "ModMekanism");
        this._modList.put("thermalexpansion", "ModThermalExpansion");
        this._modList.put("minefactoryreloaded", "ModMineFactoryReloaded");
    }

    private void loadHelpers() {
        ArrayList<ModCompact> loadedHelpers = new ArrayList<ModCompact>();
        for (Map.Entry<String, String> entry : this._modList.entrySet()) {
            ModCompact helper;
            if (!CompatManager.isModLoaded(entry.getKey()) || null == (helper = CompatManager.createHelper(entry.getValue()))) continue;
            loadedHelpers.add(helper);
            BRLog.info("Loaded support for %s", entry.getKey());
        }
        this._helpers = loadedHelpers.toArray(new ModCompact[0]);
    }

    @Nullable
    private static ModCompact createHelper(@Nonnull String className) {
        try {
            Class<?> clazz = Class.forName("erogenousbeef.bigreactors.common.compat." + className);
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            return (ModCompact)constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e1) {
            BRLog.error("Can't load mod-compat helper class %s", className);
        }
        catch (NoSuchMethodException e2) {
            BRLog.error("No default constructor found in mod-compat helper class %s", className);
        }
        catch (InvocationTargetException e3) {
            BRLog.error("Can't invoke default constructor of mod-compat helper class %s", className);
        }
        catch (InstantiationException e4) {
            BRLog.error("Can't instantiate mod-compat helper class %s", className);
        }
        catch (IllegalAccessException e5) {
            BRLog.error("Can't access default constructor of mod-compat helper class %s", className);
        }
        catch (ClassCastException e6) {
            BRLog.error("Invalid mod-compat helper class %s", className);
        }
        return null;
    }
}

