/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import mekanism.api.Coord4D;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiTileEntityElement;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.network.PacketSimpleGui;
import mekanism.common.tile.TileEntityInductionCasing;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiMatrixTab
extends GuiTileEntityElement<TileEntityInductionCasing> {
    private final MatrixTab tabType;
    private final int yPos;

    public GuiMatrixTab(IGuiWrapper gui, TileEntityInductionCasing tile, MatrixTab type, int y, ResourceLocation def) {
        super(type.getResource(), gui, def, tile);
        this.tabType = type;
        this.yPos = y;
    }

    @Override
    public GuiElement.Rectangle4i getBounds(int guiWidth, int guiHeight) {
        return new GuiElement.Rectangle4i(guiWidth - 26, guiHeight + this.yPos, 26, 26);
    }

    @Override
    protected boolean inBounds(int xAxis, int yAxis) {
        return xAxis >= -21 && xAxis <= -3 && yAxis >= this.yPos + 4 && yAxis <= this.yPos + 22;
    }

    @Override
    public void renderBackground(int xAxis, int yAxis, int guiWidth, int guiHeight) {
        GuiMatrixTab.mc.field_71446_o.func_110577_a(this.RESOURCE);
        this.guiObj.drawTexturedRect(guiWidth - 26, guiHeight + this.yPos, 0, 0, 26, 26);
        this.guiObj.drawTexturedRect(guiWidth - 21, guiHeight + this.yPos + 4, 26, this.inBounds(xAxis, yAxis) ? 0 : 18, 18, 18);
        GuiMatrixTab.mc.field_71446_o.func_110577_a(this.defaultLocation);
    }

    @Override
    public void renderForeground(int xAxis, int yAxis) {
        GuiMatrixTab.mc.field_71446_o.func_110577_a(this.RESOURCE);
        if (this.inBounds(xAxis, yAxis)) {
            this.displayTooltip(this.tabType.getDesc(), xAxis, yAxis);
        }
        GuiMatrixTab.mc.field_71446_o.func_110577_a(this.defaultLocation);
    }

    @Override
    public void preMouseClicked(int xAxis, int yAxis, int button) {
    }

    @Override
    public void mouseClicked(int xAxis, int yAxis, int button) {
        if (button == 0 && this.inBounds(xAxis, yAxis)) {
            this.tabType.openGui(this.tileEntity);
            SoundHandler.playSound(SoundEvents.field_187909_gi);
        }
    }

    public static enum MatrixTab {
        MAIN("GuiEnergyTab.png", 49, "gui.main"),
        STAT("GuiStatsTab.png", 50, "gui.stats");

        private String path;
        private int guiId;
        private String desc;

        private MatrixTab(String s, int id, String s1) {
            this.path = s;
            this.guiId = id;
            this.desc = s1;
        }

        public ResourceLocation getResource() {
            return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_ELEMENT, this.path);
        }

        public void openGui(TileEntity tile) {
            Mekanism.packetHandler.sendToServer(new PacketSimpleGui.SimpleGuiMessage(Coord4D.get(tile), 0, this.guiId));
        }

        public String getDesc() {
            return LangUtils.localize(this.desc);
        }
    }
}

