/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.recipes;

import ic2.api.classic.recipe.ClassicRecipes;
import ic2.api.classic.recipe.machine.IMachineRecipeList;
import ic2.api.recipe.IRecipeInput;
import ic2.core.IC2;
import ic2.core.block.machine.high.TileEntityUraniumEnricher;
import ic2.core.block.machine.low.TileEntityCompressor;
import ic2.core.block.machine.recipes.managers.BasicMachineRecipeList;
import ic2.core.inventory.filters.BasicItemFilter;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.item.reactor.uranTypes.IUranium;
import ic2.core.item.recipe.AdvRecipe;
import ic2.core.item.recipe.AdvRecipeBase;
import ic2.core.item.recipe.entry.RecipeInputCombined;
import ic2.core.item.recipe.entry.RecipeInputItemStack;
import ic2.core.item.recipe.entry.RecipeInputOreDict;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.helpers.CompareableStack;
import ic2.core.util.misc.StackUtil;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetMetadata;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import trinsdar.ic2c_extras.IC2CExtras;
import trinsdar.ic2c_extras.Ic2cExtrasConfig;
import trinsdar.ic2c_extras.items.ItemMiscs;
import trinsdar.ic2c_extras.items.ItemNuclearRod;
import trinsdar.ic2c_extras.items.ItemTinyDust;
import trinsdar.ic2c_extras.items.urantypes.Plutonium;
import trinsdar.ic2c_extras.items.urantypes.Thorium;
import trinsdar.ic2c_extras.recipes.CraftingRecipes;
import trinsdar.ic2c_extras.recipes.GTCRecipes;
import trinsdar.ic2c_extras.recipes.MachineRecipes;
import trinsdar.ic2c_extras.recipes.ModRecipes;
import trinsdar.ic2c_extras.tileentity.TileEntityOreWashingPlant;
import trinsdar.ic2c_extras.tileentity.TileEntityThermalCentrifuge;
import trinsdar.ic2c_extras.util.Registry;

public class Ic2cExtrasRecipes {
    public static int itemQuality = 0;
    public static int dungeonWeight = 10;
    public static int netherFortressWeight = 15;
    public static int jungleTempleWeight = 15;
    public static int desertTempleWeight = 15;
    public static int strongholdWeight = 20;
    public static int tinyPlutonioumWeight = 5;
    public static IMachineRecipeList rolling = new BasicMachineRecipeList("rolling");
    public static IMachineRecipeList extruding = new BasicMachineRecipeList("extruding");
    public static IMachineRecipeList cutting = new BasicMachineRecipeList("cutting");
    public static IMachineRecipeList oreWashingPlant = new BasicMachineRecipeList("oreWashingPlant");
    public static IMachineRecipeList thermalCentrifuge = new BasicMachineRecipeList("thermalCentrifuge");
    public static Map<CompareableStack, IRecipeInput> thermalCentrifugeValidInputs = new LinkedHashMap<CompareableStack, IRecipeInput>();
    public static Map<CompareableStack, IRecipeInput> oreWashingPlantValidInputs = new LinkedHashMap<CompareableStack, IRecipeInput>();
    public static Map<CompareableStack, IRecipeInput> rollerValidInputs = new LinkedHashMap<CompareableStack, IRecipeInput>();
    public static Map<CompareableStack, IRecipeInput> extruderValidInputs = new LinkedHashMap<CompareableStack, IRecipeInput>();
    public static Map<CompareableStack, IRecipeInput> cutterValidInputs = new LinkedHashMap<CompareableStack, IRecipeInput>();

    public static String getRefinedIronCasing() {
        return IC2.config.getFlag("SteelRecipes") ? "casingSteel" : "casingRefinedIron";
    }

    public static void init() {
        CraftingRecipes.init();
        MachineRecipes.init();
        ModRecipes.init();
        Ic2cExtrasRecipes.initHarderUraniumProcessing();
        if (Ic2cExtrasConfig.autoFluidContainerRecipes) {
            MachineRecipes.initFluidFillingndEmptyingRecipes();
        }
        if (Loader.isModLoaded((String)"gtclassic")) {
            GTCRecipes.init();
        }
    }

    public static void postInit() {
        MachineRecipes.postInit();
        MachineRecipes.initMetalBenderRecipes();
        Ic2cExtrasRecipes.initInputLists();
    }

    public static void initInputLists() {
        IRecipeInput input;
        oreWashingPlantValidInputs.clear();
        thermalCentrifugeValidInputs.clear();
        rollerValidInputs.clear();
        extruderValidInputs.clear();
        cutterValidInputs.clear();
        for (IMachineRecipeList.RecipeEntry recipe : oreWashingPlant.getRecipeMap()) {
            input = recipe.getInput();
            for (ItemStack stack : input.getInputs()) {
                oreWashingPlantValidInputs.put(new CompareableStack(stack), input);
            }
        }
        for (IMachineRecipeList.RecipeEntry recipe : thermalCentrifuge.getRecipeMap()) {
            input = recipe.getInput();
            for (ItemStack stack : input.getInputs()) {
                thermalCentrifugeValidInputs.put(new CompareableStack(stack), input);
            }
        }
        for (IMachineRecipeList.RecipeEntry recipe : rolling.getRecipeMap()) {
            input = recipe.getInput();
            for (ItemStack stack : input.getInputs()) {
                rollerValidInputs.put(new CompareableStack(stack), input);
            }
        }
        for (IMachineRecipeList.RecipeEntry recipe : extruding.getRecipeMap()) {
            input = recipe.getInput();
            for (ItemStack stack : input.getInputs()) {
                extruderValidInputs.put(new CompareableStack(stack), input);
            }
        }
        for (IMachineRecipeList.RecipeEntry recipe : cutting.getRecipeMap()) {
            input = recipe.getInput();
            for (ItemStack stack : input.getInputs()) {
                cutterValidInputs.put(new CompareableStack(stack), input);
            }
        }
    }

    public static void initHarderUraniumProcessing() {
        ItemStack stoneDust = new ItemStack((Item)Registry.stoneDust);
        if (Ic2cExtrasConfig.harderUranium) {
            IUranium[] types;
            TileEntityUraniumEnricher.URANIUM_INGOT_REFERENCE = new ItemStack((Item)Registry.doubleEnrichedUraniumIngot);
            CommonFilters.uranFilter = new BasicItemFilter(new ItemStack((Item)Registry.doubleEnrichedUraniumIngot));
            ClassicRecipes.macerator.removeRecipe((IRecipeInput)new RecipeInputOreDict("oreUranium"));
            ClassicRecipes.macerator.addRecipe((IRecipeInput)new RecipeInputOreDict("oreUranium"), new ItemStack((Item)Registry.uraniumCrushedOre, 2), 1.0f, "uraniumOre");
            TileEntityThermalCentrifuge.addRecipe((IRecipeInput)new RecipeInputItemStack(Ic2Items.reactorReEnrichedUraniumRod), 1500, 36000, new ItemStack((Item)Registry.plutoniumTinyDust, 1), new ItemStack((Item)Registry.thoriumTinyDust, 2), Ic2cExtrasRecipes.getEmptyRod().func_77946_l());
            TileEntityThermalCentrifuge.addRecipe((IRecipeInput)new RecipeInputItemStack(new ItemStack((Item)Registry.reEnrichedUranium238Cell)), 1500, 36000, new ItemStack((Item)Registry.plutoniumTinyDust, 2), Ic2cExtrasRecipes.getEmptyRod().func_77946_l());
            TileEntityThermalCentrifuge.addRecipe((IRecipeInput)new RecipeInputItemStack(new ItemStack((Item)Registry.reEnrichedThorium232Cell)), 1500, 36000, new ItemStack((Item)Registry.uranium233TinyDust, 2), Ic2cExtrasRecipes.getEmptyRod().func_77946_l());
            TileEntityThermalCentrifuge.addRecipe((IRecipeInput)new RecipeInputOreDict("crushedPurifiedUranium", 1), 900, 18000, new ItemStack((Item)Registry.refinedUraniumOre, 1), new ItemStack((Item)Registry.thoriumTinyDust, 1));
            if (!Loader.isModLoaded((String)"gtclassic")) {
                TileEntityThermalCentrifuge.addRecipe((IRecipeInput)new RecipeInputOreDict("crushedCentrifugedUranium", 1), 900, 18000, new ItemStack((Item)Registry.uraniumDust), new ItemStack((Item)Registry.uranium238, 2), new ItemStack((Item)Registry.uranium235TinyDust));
                TileEntityThermalCentrifuge.addRecipe((IRecipeInput)new RecipeInputOreDict("dustUranium", 22), 1000, 125000, new ItemStack((Item)Registry.uranium238, 16), new ItemStack((Item)Registry.uranium235, 2), new ItemStack((Item)Registry.thoriumDust, 4));
            }
            TileEntityOreWashingPlant.addRecipe((IRecipeInput)new RecipeInputOreDict("crushedUranium", 1), 1000, new ItemStack((Item)Registry.uraniumPurifiedCrushedOre, 1), new ItemStack((Item)Registry.leadTinyDust, 2), stoneDust);
            CraftingRecipes.recipes.addRecipe(StackUtil.copyWithSize((ItemStack)Ic2Items.uraniumDrop, (int)1), new Object[]{"UUU", "TTT", "UUU", Character.valueOf('U'), "dustUranium238", Character.valueOf('T'), "dustTinyUranium235"});
            CraftingRecipes.recipes.addRecipe(new ItemStack((Item)Registry.moxFuel), new Object[]{"UUU", "TTT", "UUU", Character.valueOf('U'), "dustUranium238", Character.valueOf('T'), "dustTinyPlutonium"});
            CraftingRecipes.recipes.addRecipe(new ItemStack((Item)Registry.doubleEnrichedUraniumIngot), new Object[]{" U ", "UIU", " U ", Character.valueOf('U'), Registry.uranium238, Character.valueOf('I'), Ic2Items.uraniumIngot});
            CraftingRecipes.dustUtil("dustUranium235", new ItemStack((Item)Registry.uranium235), "dustTinyUranium235", new ItemStack((Item)Registry.uranium235TinyDust), "dustSmallUranium235", new ItemStack((Item)Registry.uranium235SmallDust));
            CraftingRecipes.dustUtil("dustUranium238", new ItemStack((Item)Registry.uranium238), "dustTinyUranium238", new ItemStack((Item)Registry.uranium238TinyDust), "dustSmallUranium238", new ItemStack((Item)Registry.uranium238SmallDust));
            CraftingRecipes.dustUtil("dustUranium233", new ItemStack((Item)Registry.uranium233Dust), "dustTinyUranium233", new ItemStack((Item)Registry.uranium233TinyDust));
            if (!Loader.isModLoaded((String)"gtclassic")) {
                CraftingRecipes.dustUtil("dustPlutonium", new ItemStack((Item)Registry.plutoniumDust), "dustTinyPlutonium", new ItemStack((Item)Registry.plutoniumTinyDust), "dustSmallPlutonium", new ItemStack((Item)Registry.plutoniumSmallDust));
                CraftingRecipes.dustUtil("dustThorium", new ItemStack((Item)Registry.thoriumDust), "dustTinyThorium", new ItemStack((Item)Registry.thoriumTinyDust));
                TileEntityCompressor.addRecipe((String)"dustPlutonium", (int)1, (ItemStack)new ItemStack((Item)Registry.plutoniumIngot));
                TileEntityCompressor.addRecipe((String)"dustThorium", (int)1, (ItemStack)new ItemStack((Item)Registry.thoriumIngot));
            }
            TileEntityCompressor.addRecipe((String)"dustUranium235", (int)1, (ItemStack)new ItemStack((Item)Registry.uranium235Ingot));
            TileEntityCompressor.addRecipe((String)"dustUranium233", (int)1, (ItemStack)new ItemStack((Item)Registry.uranium233Ingot));
            TileEntityCompressor.addRecipe((String)"dustUranium238", (int)1, (ItemStack)new ItemStack((Item)Registry.uranium238Ingot));
            TileEntityCompressor.addRecipe((String)"crushedPurifiedUranium", (int)1, (ItemStack)Ic2Items.uraniumDrop);
            for (IUranium uran : types = ItemNuclearRod.types) {
                if ((uran instanceof Thorium || uran instanceof Plutonium) && Loader.isModLoaded((String)"gtclassic")) continue;
                Ic2cExtrasRecipes.rodUtil(uran.getRodType(IUranium.RodType.SingleRod), uran.getRodType(IUranium.RodType.DualRod), uran.getRodType(IUranium.RodType.QuadRod), uran.getNewIsotopicRod(), uran.getRodType(IUranium.RodType.ReEnrichedRod), uran.getRodType(IUranium.RodType.NearDepletedRod), uran.getUraniumIngot());
            }
            ItemStack emptyFuelRod = Ic2cExtrasRecipes.getEmptyRod();
            CraftingRecipes.recipes.overrideRecipe("shaped_item.itemCellUranEmpty_-1582032965", StackUtil.copyWithSize((ItemStack)Ic2Items.reactorNearDepletedUraniumRod, (int)4), new Object[]{" R ", "RIR", " R ", Character.valueOf('R'), emptyFuelRod, Character.valueOf('I'), Ic2Items.uraniumIngot});
            CraftingRecipes.recipes.overrideRecipe("shaped_item.itemCellRedstoneEnrichedUranEmpty_192974428", StackUtil.copyWithSize((ItemStack)Ic2Items.reactorNearDepletedRedstoneUraniumRod, (int)4), new Object[]{" R ", "RIR", " R ", Character.valueOf('R'), emptyFuelRod, Character.valueOf('I'), Ic2Items.redstoneUraniumIngot});
            CraftingRecipes.recipes.overrideRecipe("shaped_item.itemCellBlazeEnrichedUranEmpty_1080478140", StackUtil.copyWithSize((ItemStack)Ic2Items.reactorNearDepletedBlazeUraniumRod, (int)4), new Object[]{" R ", "RIR", " R ", Character.valueOf('R'), emptyFuelRod, Character.valueOf('I'), Ic2Items.blazeUraniumIngot});
            CraftingRecipes.recipes.overrideRecipe("shaped_item.itemCellEnderPearlEnrichedUranEmpty_1967981852", StackUtil.copyWithSize((ItemStack)Ic2Items.reactorNearDepletedEnderPearlUraniumRod, (int)4), new Object[]{" R ", "RIR", " R ", Character.valueOf('R'), emptyFuelRod, Character.valueOf('I'), Ic2Items.enderPearlUraniumIngot});
            CraftingRecipes.recipes.overrideRecipe("shaped_item.itemCellNetherStarEnrichedUranEmpty_-1439481732", StackUtil.copyWithSize((ItemStack)Ic2Items.reactorNearDepletedNetherStarUraniumRod, (int)4), new Object[]{" R ", "RIR", " R ", Character.valueOf('R'), emptyFuelRod, Character.valueOf('I'), Ic2Items.netherStarUraniumIngot});
            CraftingRecipes.recipes.overrideRecipe("shaped_item.itemCellCharcoalEnrichedUranEmpty_-551978020", StackUtil.copyWithSize((ItemStack)Ic2Items.reactorNearDepletedCharcoalUraniumRod, (int)4), new Object[]{" R ", "RIR", " R ", Character.valueOf('R'), emptyFuelRod, Character.valueOf('I'), Ic2Items.charcoalUraniumIngot});
            if (Loader.isModLoaded((String)"gtclassic")) {
                GTCRecipes.initUranOverride();
            }
        }
        CraftingRecipes.recipes.addRecipe(new ItemStack((Block)Registry.thermoElectricGenerator), new Object[]{"DDD", "DRD", "DGD", Character.valueOf('D'), "plateDenseIron", Character.valueOf('R'), Ic2Items.nuclearReactor, Character.valueOf('G'), Ic2Items.thermalGenerator});
        CraftingRecipes.recipes.addRecipe(new ItemStack((Item)Registry.plutoniumRTG), new Object[]{"IPI", "IPI", "IPI", Character.valueOf('I'), "plateDenseIron", Character.valueOf('P'), "ingotPlutonium"});
    }

    public static ItemStack getEmptyRod() {
        return Ic2cExtrasConfig.emptyNuclearRod ? new ItemStack((Item)Registry.emptyFuelRod) : Ic2Items.emptyCell;
    }

    public static void rodUtil(ItemStack single, ItemStack dual, ItemStack quad, ItemStack isotope, ItemStack reEnriched, ItemStack nearDepleted, ItemStack ingredient) {
        ItemStack emptyRod = Ic2cExtrasRecipes.getEmptyRod();
        RecipeInputOreDict copper = Loader.isModLoaded((String)"gtc_expansion") ? new RecipeInputOreDict("plateCopper") : new RecipeInputItemStack(Ic2Items.denseCopperPlate);
        RecipeInputCombined coal = Loader.isModLoaded((String)"gtclassic") ? new RecipeInputCombined(1, new IRecipeInput[]{new RecipeInputOreDict("dustCoal"), new RecipeInputOreDict("dustCharcoal"), new RecipeInputOreDict("dustCarbon")}) : new RecipeInputCombined(1, new IRecipeInput[]{new RecipeInputOreDict("dustCoal"), new RecipeInputOreDict("dustCharcoal")});
        CraftingRecipes.recipes.addShapelessRecipe(single, new Object[]{coal, reEnriched});
        CraftingRecipes.recipes.addRecipe(StackUtil.copyWithSize((ItemStack)nearDepleted, (int)4), new Object[]{" R ", "RIR", " R ", Character.valueOf('R'), emptyRod, Character.valueOf('I'), ingredient});
        CraftingRecipes.recipes.addRecipe(dual, new Object[]{"RPR", Character.valueOf('R'), single, Character.valueOf('P'), copper});
        CraftingRecipes.recipes.addRecipe(quad, new Object[]{" R ", "PPP", " R ", Character.valueOf('R'), dual, Character.valueOf('P'), copper});
        CraftingRecipes.recipes.addRecipe(quad, new Object[]{"RPR", "PPP", "RPR", Character.valueOf('R'), single, Character.valueOf('P'), copper});
        CraftingRecipes.recipes.addShapelessRecipe(isotope, new Object[]{nearDepleted, coal});
        if (!IC2.config.getFlag("HardEnrichedUran")) {
            CraftingRecipes.recipes.addShapelessRecipe(single, new Object[]{emptyRod, ingredient});
            ClassicRecipes.canningMachine.registerCannerItem(emptyRod, (IRecipeInput)new RecipeInputItemStack(ingredient), single);
        }
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        LootFunction[] funcs = new LootFunction[]{new SetMetadata(new LootCondition[0], new RandomValueRange(0.0f, 3.0f))};
        String entryNameIridium = "ic2c_extras:iridiumshard";
        String entryNamePlutonium = "ic2c_extras:tinyplutonium";
        ItemMiscs shard = Registry.iridiumShard;
        ItemTinyDust plutonium = Registry.plutoniumTinyDust;
        if (Ic2cExtrasConfig.lootEntries) {
            if (event.getName().equals((Object)LootTableList.field_186422_d)) {
                event.getTable().getPool("main").addEntry((LootEntry)new LootEntryItem((Item)shard, dungeonWeight, itemQuality, funcs, new LootCondition[0], entryNameIridium));
                event.getTable().getPool("main").addEntry((LootEntry)new LootEntryItem((Item)plutonium, tinyPlutonioumWeight, itemQuality, funcs, new LootCondition[0], entryNamePlutonium));
            } else if (event.getName().equals((Object)LootTableList.field_186425_g)) {
                event.getTable().getPool("main").addEntry((LootEntry)new LootEntryItem((Item)shard, netherFortressWeight, itemQuality, funcs, new LootCondition[0], entryNameIridium));
                event.getTable().getPool("main").addEntry((LootEntry)new LootEntryItem((Item)plutonium, tinyPlutonioumWeight, itemQuality, funcs, new LootCondition[0], entryNamePlutonium));
            } else if (event.getName().equals((Object)LootTableList.field_186428_j) || event.getName().equals((Object)LootTableList.field_186427_i)) {
                event.getTable().getPool("main").addEntry((LootEntry)new LootEntryItem((Item)shard, strongholdWeight, itemQuality, funcs, new LootCondition[0], entryNameIridium));
                event.getTable().getPool("main").addEntry((LootEntry)new LootEntryItem((Item)plutonium, tinyPlutonioumWeight, itemQuality, funcs, new LootCondition[0], entryNamePlutonium));
            } else if (event.getName().equals((Object)LootTableList.field_186430_l)) {
                event.getTable().getPool("main").addEntry((LootEntry)new LootEntryItem((Item)shard, jungleTempleWeight, itemQuality, funcs, new LootCondition[0], entryNameIridium));
                event.getTable().getPool("main").addEntry((LootEntry)new LootEntryItem((Item)plutonium, tinyPlutonioumWeight, itemQuality, funcs, new LootCondition[0], entryNamePlutonium));
            } else if (event.getName().equals((Object)LootTableList.field_186429_k)) {
                event.getTable().getPool("main").addEntry((LootEntry)new LootEntryItem((Item)shard, desertTempleWeight, itemQuality, funcs, new LootCondition[0], entryNameIridium));
                event.getTable().getPool("main").addEntry((LootEntry)new LootEntryItem((Item)plutonium, tinyPlutonioumWeight, itemQuality, funcs, new LootCondition[0], entryNamePlutonium));
            }
        }
    }

    public static void removeRecipe(String modid, String recipeId) {
        ((ForgeRegistry)ForgeRegistries.RECIPES).remove(new ResourceLocation(modid, recipeId));
        Field duplicatesf = null;
        try {
            duplicatesf = AdvRecipeBase.class.getDeclaredField("duplicates");
        }
        catch (NoSuchFieldException e) {
            IC2CExtras.logger.info("Trying to access Advanced recipes has failed : (");
        }
        catch (SecurityException e) {
            IC2CExtras.logger.info("AdvRecipeBase security deployed");
        }
        if (duplicatesf != null) {
            duplicatesf.setAccessible(true);
        }
        try {
            if (duplicatesf != null) {
                ((Set)duplicatesf.get(duplicatesf)).remove(new ResourceLocation(modid, recipeId));
            }
        }
        catch (IllegalArgumentException e) {
            IC2CExtras.logger.info("Accessed AdvRecipeBase class but field getter failed");
        }
        catch (IllegalAccessException e) {
            IC2CExtras.logger.info("Accessed AdvRecipeBase class but access denied");
        }
    }

    public static void overrideRecipe(String modid, String recipeId, ItemStack output, Object ... input) {
        Loader loader = Loader.instance();
        ModContainer old = loader.activeModContainer();
        loader.setActiveModContainer((ModContainer)loader.getIndexedModList().get(modid));
        ((ForgeRegistry)ForgeRegistries.RECIPES).remove(new ResourceLocation(modid, recipeId));
        Field duplicatesf = null;
        try {
            duplicatesf = AdvRecipeBase.class.getDeclaredField("duplicates");
        }
        catch (NoSuchFieldException e) {
            IC2CExtras.logger.info("Trying to access Advanced recipes has failed : (");
        }
        catch (SecurityException e) {
            IC2CExtras.logger.info("AdvRecipeBase security deployed");
        }
        if (duplicatesf != null) {
            duplicatesf.setAccessible(true);
        }
        try {
            if (duplicatesf != null) {
                ((Set)duplicatesf.get(duplicatesf)).remove(new ResourceLocation(modid, recipeId));
            }
        }
        catch (IllegalArgumentException e) {
            IC2CExtras.logger.info("Accessed AdvRecipeBase class but field getter failed");
        }
        catch (IllegalAccessException e) {
            IC2CExtras.logger.info("Accessed AdvRecipeBase class but access denied");
        }
        AdvRecipe.overrideAndGet((String)recipeId, (ItemStack)output, (Object[])input);
        loader.setActiveModContainer(old);
    }
}

