/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.filter.redstone.items;

import com.enderio.core.common.TileEntityBase;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.filter.FilterRegistry;
import crazypants.enderio.base.filter.IFilter;
import crazypants.enderio.base.filter.IFilterContainer;
import crazypants.enderio.base.filter.gui.ContainerFilter;
import crazypants.enderio.base.filter.gui.RedstoneSignalLogicGui;
import crazypants.enderio.base.filter.redstone.IOutputSignalFilter;
import crazypants.enderio.base.filter.redstone.LogicOutputSignalFilter;
import crazypants.enderio.base.filter.redstone.items.IItemOutputSignalFilterUpgrade;
import crazypants.enderio.util.NbtValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBasicOutputSignalFilter
extends Item
implements IItemOutputSignalFilterUpgrade {
    @Nonnull
    private final LogicOutputSignalFilter.EnumSignalFilterType filterType;

    public static ItemBasicOutputSignalFilter createOr(@Nonnull IModObject modObject, @Nullable Block block) {
        return new ItemBasicOutputSignalFilter(modObject, LogicOutputSignalFilter.EnumSignalFilterType.OR);
    }

    public static ItemBasicOutputSignalFilter createAnd(@Nonnull IModObject modObject, @Nullable Block block) {
        return new ItemBasicOutputSignalFilter(modObject, LogicOutputSignalFilter.EnumSignalFilterType.AND);
    }

    public static ItemBasicOutputSignalFilter createNor(@Nonnull IModObject modObject, @Nullable Block block) {
        return new ItemBasicOutputSignalFilter(modObject, LogicOutputSignalFilter.EnumSignalFilterType.NOR);
    }

    public static ItemBasicOutputSignalFilter createNand(@Nonnull IModObject modObject, @Nullable Block block) {
        return new ItemBasicOutputSignalFilter(modObject, LogicOutputSignalFilter.EnumSignalFilterType.NAND);
    }

    public static ItemBasicOutputSignalFilter createXor(@Nonnull IModObject modObject, @Nullable Block block) {
        return new ItemBasicOutputSignalFilter(modObject, LogicOutputSignalFilter.EnumSignalFilterType.XOR);
    }

    public static ItemBasicOutputSignalFilter createXnor(@Nonnull IModObject modObject, @Nullable Block block) {
        return new ItemBasicOutputSignalFilter(modObject, LogicOutputSignalFilter.EnumSignalFilterType.XNOR);
    }

    public ItemBasicOutputSignalFilter(@Nonnull IModObject modObject, @Nonnull LogicOutputSignalFilter.EnumSignalFilterType filterType) {
        this.func_77637_a(EnderIOTab.tabEnderIOItems);
        this.filterType = filterType;
        modObject.apply(this);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77625_d(64);
    }

    @Override
    public IOutputSignalFilter createFilterFromStack(@Nonnull ItemStack stack) {
        LogicOutputSignalFilter filter = new LogicOutputSignalFilter(this.filterType);
        if (NbtValue.FILTER.hasTag(stack)) {
            filter.readFromNBT(NbtValue.FILTER.getTag(stack));
        }
        return filter;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nullable
    public GuiScreen getClientGuiElement(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing facing, int param1) {
        Container container = player.field_71070_bA;
        if (container instanceof IFilterContainer) {
            return new RedstoneSignalLogicGui(player.field_71071_by, new ContainerFilter(player, (TileEntityBase)world.func_175625_s(pos), facing, param1), world.func_175625_s(pos), (IFilter)((IFilterContainer)container).getFilter(param1));
        }
        return new RedstoneSignalLogicGui(player.field_71071_by, new ContainerFilter(player, null, facing, param1), null, (IFilter)FilterRegistry.getFilterForUpgrade(player.func_184586_b(EnumHand.values()[param1])));
    }
}

