/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.niard;

import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.base.Log;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class FluidColorUtil {
    @Nonnull
    private static final Map<ResourceLocation, Vector4f> CACHE = new HashMap<ResourceLocation, Vector4f>();

    public static Vector4f getFluidColor(@Nonnull FluidStack stack, Vector4f fallbackColor) {
        ResourceLocation still = stack.getFluid().getStill(stack);
        if (still != null) {
            return CACHE.computeIfAbsent(still, rl -> {
                if (rl == null) return fallbackColor;
                rl = new ResourceLocation(rl.func_110624_b(), String.format("%s/%s%s", "textures", rl.func_110623_a(), ".png"));
                IResourceManager resourceManager = Minecraft.func_71410_x().func_110442_L();
                try (IResource iresource = resourceManager.func_110536_a(rl);){
                    BufferedImage bufferedimage = TextureUtil.func_177053_a((InputStream)iresource.func_110527_b());
                    double rs = 0.0;
                    double gs = 0.0;
                    double bs = 0.0;
                    double as = 0.0;
                    int size = bufferedimage.getWidth();
                    for (int x = 0; x < size; ++x) {
                        double b;
                        double g;
                        double a;
                        double r;
                        for (int y = 0; y < size; rs += r * a * r * a, gs += g * a * g * a, bs += b * a * b * a, as += a * a, ++y) {
                            int color = bufferedimage.getRGB(x, y);
                            r = (float)(color >> 16 & 0xFF) / 255.0f;
                            g = (float)(color >> 8 & 0xFF) / 255.0f;
                            b = (float)(color & 0xFF) / 255.0f;
                            a = (float)(color >> 24 & 0xFF) / 255.0f;
                        }
                    }
                    double r = Math.sqrt(rs / as);
                    double g = Math.sqrt(gs / as);
                    double b = Math.sqrt(bs / as);
                    Vector4f vector4f = new Vector4f(r, g, b, (double)0.4f);
                    return vector4f;
                }
                catch (IOException e) {
                    Log.warn("Could not load still texture for fluid " + stack + ". Using default color for range display instead.");
                    e.printStackTrace();
                }
                return fallbackColor;
            });
        }
        return fallbackColor;
    }
}

