/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.command.sub.blast;

import icbm.classic.ICBMClassic;
import icbm.classic.api.ICBMClassicHelpers;
import icbm.classic.api.explosion.BlastState;
import icbm.classic.api.reg.IExplosiveData;
import icbm.classic.command.CommandUtils;
import icbm.classic.command.system.SubCommand;
import icbm.classic.lib.explosive.ExplosiveHandler;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.SyntaxErrorException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class CommandBlastTrigger
extends SubCommand {
    private static final String TRANSLATION_KEY = "command.icbmclassic:icbm.blast";
    public static final String TRANSLATION_TRIGGERED = "command.icbmclassic:icbm.blast.triggered";
    public static final String TRANSLATION_THREADING = "command.icbmclassic:icbm.blast.threading";
    public static final String TRANSLATION_ERROR = "command.icbmclassic:icbm.blast.error";
    public static final String TRANSLATION_ERROR_BLOCKED = "command.icbmclassic:icbm.blast.error.blocked";
    public static final String TRANSLATION_ERROR_NULL = "command.icbmclassic:icbm.blast.error.null";
    public static final String TRANSLATION_ERROR_TRIGGERED = "command.icbmclassic:icbm.blast.error.triggered";
    public static final String TRANSLATION_ERROR_UNKNOWN = "command.icbmclassic:icbm.blast.error.unknown";
    public static final String TRANSLATION_ERROR_SCALE_ZERO = "command.icbmclassic:icbm.blast.error.scale.zero";
    public static final String TRANSLATION_ERROR_EXPLOSIVE_ID = "command.icbmclassic:icbm.blast.error.explosive.id";

    public CommandBlastTrigger() {
        super("trigger");
    }

    @Override
    protected void collectHelpForAll(Consumer<String> consumer) {
        consumer.accept("<id> <dim> <x> <y> <z> <scale>");
    }

    @Override
    protected void collectHelpWorldOnly(Consumer<String> consumer) {
        consumer.accept("<id> <scale>");
    }

    @Override
    public void handleCommand(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
        if (args.length <= 0 || !this.doCommand(server, sender, args)) {
            throw new WrongUsageException("command.icbmclassic:icbm.error.unknown.command", new Object[]{this.getUsage(sender)});
        }
    }

    private boolean doCommand(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws SyntaxErrorException {
        IExplosiveData explosiveData = CommandBlastTrigger.getExplosive(args[0]);
        if (args.length == 6) {
            this.longVersion(sender, explosiveData, args);
            return true;
        }
        if (!(sender instanceof MinecraftServer) && args.length == 2) {
            this.shortVersion(sender, explosiveData, args);
            return true;
        }
        return false;
    }

    private void shortVersion(ICommandSender sender, IExplosiveData explosiveData, String[] args) throws SyntaxErrorException {
        float scale = Float.parseFloat(args[1]);
        if (scale <= 0.0f) {
            throw new SyntaxErrorException(TRANSLATION_ERROR_SCALE_ZERO, new Object[0]);
        }
        World world = sender.func_130014_f_();
        double x = sender.func_174791_d().field_72450_a;
        double y = sender.func_174791_d().field_72448_b;
        double z = sender.func_174791_d().field_72449_c;
        this.trigger(sender, world, x, y, z, explosiveData, scale);
    }

    private void longVersion(ICommandSender sender, IExplosiveData explosiveData, String[] args) throws SyntaxErrorException {
        float scale = Float.parseFloat(args[5]);
        if (scale <= 0.0f) {
            throw new SyntaxErrorException(TRANSLATION_ERROR_SCALE_ZERO, new Object[0]);
        }
        World world = CommandUtils.getWorld(sender, args[1], sender.func_130014_f_());
        double x = CommandUtils.getNumber(sender, args[2], sender.func_174791_d().field_72450_a);
        double y = CommandUtils.getNumber(sender, args[3], sender.func_174791_d().field_72448_b);
        double z = CommandUtils.getNumber(sender, args[4], sender.func_174791_d().field_72449_c);
        this.trigger(sender, world, x, y, z, explosiveData, scale);
    }

    public static IExplosiveData getExplosive(String explosive_id) throws SyntaxErrorException {
        IExplosiveData explosiveData = ICBMClassicHelpers.getExplosive(explosive_id, true);
        if (explosiveData == null) {
            throw new SyntaxErrorException(TRANSLATION_ERROR_EXPLOSIVE_ID, new Object[]{explosive_id});
        }
        return explosiveData;
    }

    private void trigger(ICommandSender sender, World world, double x, double y, double z, IExplosiveData explosiveData, float scale) {
        BlastState result = ExplosiveHandler.createExplosion(null, world, x, y, z, explosiveData.getRegistryID(), scale, null);
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(CommandBlastTrigger.getTranslationKey(result), new Object[]{explosiveData.getRegistryName(), Float.valueOf(scale), world.field_73011_w.getDimension(), world.func_175624_G().func_77127_a(), x, y, z}));
    }

    public static String getTranslationKey(BlastState result) {
        switch (result) {
            case TRIGGERED: {
                return TRANSLATION_TRIGGERED;
            }
            case THREADING: {
                return TRANSLATION_THREADING;
            }
            case FORGE_EVENT_CANCEL: {
                return TRANSLATION_ERROR_BLOCKED;
            }
            case NULL: {
                return TRANSLATION_ERROR_NULL;
            }
            case ERROR: {
                return TRANSLATION_ERROR;
            }
            case ALREADY_TRIGGERED: {
                return TRANSLATION_ERROR_TRIGGERED;
            }
        }
        ICBMClassic.logger().error("CommandBlastTrigger: unknown blast status code " + (Object)((Object)result));
        return TRANSLATION_ERROR_UNKNOWN;
    }
}

