/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blast;

import icbm.classic.api.explosion.IBlastTickable;
import icbm.classic.content.blast.Blast;
import icbm.classic.content.entity.mobs.EntityXmasCreeper;
import icbm.classic.content.entity.mobs.EntityXmasMob;
import icbm.classic.content.entity.mobs.EntityXmasSkeleton;
import icbm.classic.content.entity.mobs.EntityXmasSkeletonBoss;
import icbm.classic.content.entity.mobs.EntityXmasSnowman;
import icbm.classic.content.entity.mobs.EntityXmasZombie;
import icbm.classic.content.entity.mobs.EntityXmasZombieBoss;
import java.util.HashSet;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;

public class BlastXmas
extends Blast
implements IBlastTickable {
    public int callCountEnd = 20;
    final boolean zombie;

    public BlastXmas(boolean zombie) {
        this.zombie = zombie;
    }

    @Override
    protected boolean doExplode(int callCount) {
        if (!this.field_77287_j.field_72995_K) {
            if (callCount == 0) {
                this.generateGround();
            } else if (callCount % 2 == 0) {
                this.spawnMobs();
            }
            if (callCount > this.callCountEnd) {
                this.spawnEntity(this.zombie ? new EntityXmasZombieBoss(this.world()) : new EntityXmasSkeletonBoss(this.world()), this.field_77284_b, this.field_77285_c + 4.0, this.field_77282_d);
                return true;
            }
        }
        return false;
    }

    public void generateGround() {
        EnumFacing[] directions = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.DOWN};
        LinkedList<BlockPos> blocksToPath = new LinkedList<BlockPos>();
        HashSet<BlockPos> pathed = new HashSet<BlockPos>();
        LinkedList<BlockPos> editBlocks = new LinkedList<BlockPos>();
        BlockPos center = new BlockPos(this.xi(), this.yi() + 1, this.zi());
        blocksToPath.offer(center);
        pathed.add(center);
        while (blocksToPath.peek() != null) {
            BlockPos pos = (BlockPos)blocksToPath.poll();
            IBlockState blockState = this.field_77287_j.func_180495_p(pos);
            Block block = blockState.func_177230_c();
            if (block.func_176200_f((IBlockAccess)this.field_77287_j, pos)) {
                editBlocks.offer(pos);
            }
            for (EnumFacing dir : directions) {
                BlockPos next = pos.func_177972_a(dir);
                if (pathed.contains(next)) continue;
                blockState = this.field_77287_j.func_180495_p(next);
                block = blockState.func_177230_c();
                if (block.func_176200_f((IBlockAccess)this.field_77287_j, next) && this.isInRange(center, next)) {
                    blocksToPath.offer(next);
                }
                pathed.add(next);
            }
        }
        editBlocks.forEach(edit -> this.field_77287_j.func_175656_a(edit, Blocks.field_150433_aE.func_176223_P()));
    }

    public boolean isInRange(BlockPos center, BlockPos pos) {
        int deltaX = Math.abs(center.func_177958_n() - pos.func_177958_n());
        int deltaZ = Math.abs(center.func_177952_p() - pos.func_177952_p());
        int deltaY = Math.abs(center.func_177956_o() - pos.func_177956_o());
        if (pos.func_177956_o() > center.func_177956_o() || pos.func_177956_o() <= 0 || pos.func_177956_o() >= 254) {
            return false;
        }
        int distanceAllowed = (int)this.getBlastRadius() + deltaY;
        if (deltaX <= distanceAllowed && deltaZ <= distanceAllowed) {
            return deltaX + deltaZ <= distanceAllowed;
        }
        return false;
    }

    public void spawnMobs() {
        if (!this.world().field_72995_K) {
            int spawned = 0;
            for (int i = 0; i < 8; ++i) {
                float range = this.getBlastRadius() - 3.0f;
                double x = this.location.x() + 0.5 + (double)(this.field_77287_j.field_73012_v.nextFloat() * range - this.field_77287_j.field_73012_v.nextFloat() * range);
                double z = this.location.z() + 0.5 + (double)(this.field_77287_j.field_73012_v.nextFloat() * range - this.field_77287_j.field_73012_v.nextFloat() * range);
                double y = this.findEmptyY(x, this.location.y() + 2.0, z);
                if (!(y >= 0.0)) continue;
                this.spawnMob(x, y, z);
                if (++spawned < 4) continue;
                return;
            }
        }
    }

    protected void spawnMob(double x, double y, double z) {
        float randomSpawnChance = this.field_77287_j.field_73012_v.nextFloat();
        EntityXmasMob entity = !this.zombie ? ((double)randomSpawnChance < 0.8 ? new EntityXmasSkeleton(this.world()) : new EntityXmasSnowman(this.world())) : ((double)randomSpawnChance < 0.8 ? new EntityXmasZombie(this.world()) : new EntityXmasCreeper(this.world()));
        this.spawnEntity(entity, x, y, z);
    }

    protected void spawnEntity(EntityXmasMob entity, double x, double y, double z) {
        entity.func_70080_a(x, y, z, MathHelper.func_76142_g((float)(this.field_77287_j.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        entity.func_180482_a(this.field_77287_j.func_175649_E(new BlockPos((Entity)entity)), null);
        this.world().func_72838_d((Entity)entity);
    }

    protected double findEmptyY(double x, double y, double z) {
        for (int j = 0; j < 10; ++j) {
            BlockPos pos = new BlockPos(x, y, z);
            BlockPos pos2 = pos.func_177984_a();
            if (this.field_77287_j.func_175623_d(pos) && this.field_77287_j.func_175623_d(pos2)) {
                return y;
            }
            y += 1.0;
        }
        return -1.0;
    }

    @Override
    public float getBlastRadius() {
        return 20.0f;
    }
}

