/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.thread;

import icbm.classic.ICBMClassic;
import icbm.classic.config.ConfigDebug;
import icbm.classic.lib.thread.IThreadWork;
import java.util.concurrent.ConcurrentLinkedQueue;

public class WorkerThread
extends Thread {
    public boolean doRun = true;
    private IThreadWork activateTask;
    private final ConcurrentLinkedQueue<IThreadWork> queue = new ConcurrentLinkedQueue();
    private int workCount = 0;

    public WorkerThread(int index) {
        super(null, null, "ICBM-Classic-WorkerThread-" + index, 0L);
        this.setPriority(1);
        this.setDaemon(true);
    }

    @Override
    public void interrupt() {
        if (ConfigDebug.DEBUG_THREADS) {
            ICBMClassic.logger().error(this.toString() + " was interrupted while running tasks", (Throwable)new RuntimeException("Trace"));
        }
        super.interrupt();
    }

    @Override
    public final void run() {
        while (this.doRun) {
            if (this.activateTask != null && !this.activateTask.doRun(1)) {
                this.activateTask.onCompleted();
                ICBMClassic.logger().debug(this.toString() + " complete work task " + this.activateTask);
                this.activateTask = null;
            }
            if (this.activateTask == null) {
                this.nextTask();
            }
            if (this.activateTask != null) continue;
            try {
                WorkerThread.sleep(100L);
            }
            catch (InterruptedException e) {
                ICBMClassic.logger().error(this.toString() + " was interrupted while sleeping", (Throwable)e);
            }
        }
    }

    protected void nextTask() {
        this.activateTask = this.queue.poll();
        if (this.activateTask != null) {
            --this.workCount;
            this.activateTask.onStarted();
            if (ICBMClassic.runningAsDev) {
                ICBMClassic.logger().info(this.toString() + " starting work task " + this.activateTask);
            }
        }
    }

    protected IThreadWork getCurrentTask() {
        return this.activateTask;
    }

    public void addWork(IThreadWork work) {
        this.queue.add(work);
        ++this.workCount;
    }

    public int getWorkCount() {
        return this.workCount;
    }

    public void stopTasks() {
        this.doRun = false;
    }
}

