/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.transform.vector;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.jlib.data.vector.ITransform;
import com.builtbroken.jlib.data.vector.Pos3D;
import icbm.classic.lib.transform.rotation.EulerAngle;
import icbm.classic.lib.transform.vector.Point;
import icbm.classic.lib.transform.vector.Pos;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class AbstractPos<R extends AbstractPos>
extends Pos3D<R>
implements IPosition {
    public AbstractPos() {
        this(0.0, 0.0, 0.0);
    }

    public AbstractPos(double a) {
        this(a, a, a);
    }

    public AbstractPos(double x, double y, double z) {
        super(x, y, z);
    }

    public AbstractPos(double yaw, double pitch) {
        this(-Math.sin(Math.toRadians(yaw)), Math.sin(Math.toRadians(pitch)), -Math.cos(Math.toRadians(yaw)) * Math.cos(Math.toRadians(pitch)));
    }

    public AbstractPos(TileEntity tile) {
        this(tile.func_174877_v());
    }

    public AbstractPos(Entity entity) {
        this(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
    }

    public AbstractPos(IPos3D vec) {
        this(vec.x(), vec.y(), vec.z());
    }

    public AbstractPos(NBTTagCompound nbt) {
        this(nbt.func_74769_h("x"), nbt.func_74769_h("y"), nbt.func_74769_h("z"));
    }

    public AbstractPos(ByteBuf data) {
        this(data.readDouble(), data.readDouble(), data.readDouble());
    }

    public AbstractPos(BlockPos par1) {
        this(par1.func_177958_n(), par1.func_177956_o(), par1.func_177952_p());
    }

    public AbstractPos(EnumFacing dir) {
        this(dir.func_82601_c(), dir.func_96559_d(), dir.func_82599_e());
    }

    public AbstractPos(Vec3d vec) {
        this(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public double angle(IPos3D other) {
        return Math.acos(((AbstractPos)this.cross(other)).magnitude() / (new Pos(other).magnitude() * this.magnitude()));
    }

    public double anglePreNorm(IPos3D other) {
        return Math.acos(((AbstractPos)this.cross(other)).magnitude());
    }

    public Vec3d toVec3d() {
        return new Vec3d(this.x(), this.y(), this.z());
    }

    public Point toVector2() {
        return new Point(this.x(), this.z());
    }

    public EnumFacing toDirection() {
        for (EnumFacing dir : EnumFacing.values()) {
            if (this.xi() != dir.func_82601_c() || this.yi() != dir.func_96559_d() || this.zi() != dir.func_82599_e()) continue;
            return dir;
        }
        return null;
    }

    public EulerAngle toEulerAngle(IPos3D target) {
        return ((AbstractPos)this.sub(target)).toEulerAngle();
    }

    public EulerAngle toEulerAngle() {
        return new EulerAngle(Math.toDegrees(Math.atan2(this.x(), this.z())), Math.toDegrees(-Math.atan2(this.y(), Math.hypot(this.z(), this.x()))));
    }

    public IPos3D transform(ITransform transformer) {
        if (this instanceof IPos3D) {
            return transformer.transform((IPos3D)((Object)this));
        }
        return null;
    }

    public R absolute() {
        return (R)((AbstractPos)this.newPos(Math.abs(this.x()), Math.abs(this.y()), Math.abs(this.z())));
    }

    public R add(BlockPos other) {
        return (R)((AbstractPos)this.add(other.func_177958_n(), other.func_177956_o(), other.func_177952_p()));
    }

    public R add(EnumFacing face) {
        return (R)((AbstractPos)this.add(face.func_82601_c(), face.func_96559_d(), face.func_82599_e()));
    }

    public R add(Vec3d vec) {
        return (R)((AbstractPos)this.add(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c));
    }

    public R sub(EnumFacing face) {
        return (R)((AbstractPos)this.sub(face.func_82601_c(), face.func_96559_d(), face.func_82599_e()));
    }

    public R sub(Vec3d vec) {
        return (R)((AbstractPos)this.add(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c));
    }

    public double distance(Vec3i vec) {
        return this.distance((double)vec.func_177958_n() + 0.5, (double)vec.func_177956_o() + 0.5, (double)vec.func_177952_p() + 0.5);
    }

    public double distance(Vec3d vec) {
        return this.distance(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public double distance(Entity entity) {
        return this.distance(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
    }

    public R multiply(EnumFacing face) {
        return (R)((AbstractPos)this.multiply(face.func_82601_c(), face.func_96559_d(), face.func_82599_e()));
    }

    public R multiply(Vec3d vec) {
        return (R)((AbstractPos)this.multiply(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c));
    }

    public R divide(EnumFacing face) {
        return (R)((AbstractPos)this.divide(face.func_82601_c(), face.func_96559_d(), face.func_82599_e()));
    }

    public R divide(Vec3d vec) {
        return (R)((AbstractPos)this.divide(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c));
    }

    @Override
    public R floor() {
        return (R)((AbstractPos)this.newPos(Math.floor(this.x()), Math.floor(this.y()), Math.floor(this.z())));
    }

    public NBTTagCompound toNBT() {
        return this.writeNBT(new NBTTagCompound());
    }

    public NBTTagCompound toIntNBT() {
        return this.writeIntNBT(new NBTTagCompound());
    }

    public NBTTagCompound writeNBT(NBTTagCompound nbt) {
        nbt.func_74780_a("x", this.x());
        nbt.func_74780_a("y", this.y());
        nbt.func_74780_a("z", this.z());
        return nbt;
    }

    public NBTTagCompound writeIntNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("x", this.xi());
        nbt.func_74768_a("y", this.yi());
        nbt.func_74768_a("z", this.zi());
        return nbt;
    }

    public ByteBuf writeByteBuf(ByteBuf data) {
        data.writeDouble(this.x());
        data.writeDouble(this.y());
        data.writeDouble(this.z());
        return data;
    }

    public RayTraceResult rayTrace(World world, IPos3D dir, double dist) {
        return this.rayTrace(world, new Pos(this.x() + dir.x() * dist, this.y() + dir.y() * dist, this.z() + dir.z() * dist));
    }

    public RayTraceResult rayTrace(World world, IPos3D end) {
        return this.rayTrace(world, end, false, false, false);
    }

    public RayTraceResult rayTrace(World world, IPos3D end, boolean rightClickWithBoat, boolean doColliderCheck, boolean doMiss) {
        RayTraceResult block = this.rayTraceBlocks(world, end, rightClickWithBoat, doColliderCheck, doMiss);
        RayTraceResult entity = this.rayTraceEntities(world, end);
        if (block == null) {
            return entity;
        }
        if (entity == null) {
            return block;
        }
        Pos pos = new Pos(block.field_72307_f);
        Pos pos2 = new Pos(entity.field_72307_f);
        if (this.distance(pos) < this.distance(pos2)) {
            return block;
        }
        return entity;
    }

    public RayTraceResult rayTraceBlocks(World world, IPos3D end) {
        return this.rayTraceBlocks(world, end, false, false, false);
    }

    public RayTraceResult rayTraceBlocks(World world, IPos3D end, boolean b1, boolean b2, boolean b3) {
        return world.func_147447_a(this.toVec3d(), new Vec3d(end.x(), end.y(), end.z()), b1, b2, b3);
    }

    public RayTraceResult rayTraceEntities(World world, IPos3D end) {
        RayTraceResult closestEntityMOP = null;
        double closetDistance = 0.0;
        double checkDistance = this.distance(end);
        AxisAlignedBB scanRegion = new AxisAlignedBB(-checkDistance, -checkDistance, -checkDistance, checkDistance, checkDistance, checkDistance).func_72317_d(this.x(), this.y(), this.z());
        List checkEntities = world.func_72872_a(Entity.class, scanRegion);
        for (Object obj : checkEntities) {
            Entity entity = (Entity)obj;
            if (entity == null || !entity.func_70067_L() || entity.func_174813_aQ() == null) continue;
            float border = entity.func_70111_Y();
            AxisAlignedBB bounds = entity.func_174813_aQ().func_72321_a((double)border, (double)border, (double)border);
            RayTraceResult hit = bounds.func_72327_a(this.toVec3d(), new Vec3d(end.x(), end.y(), end.z()));
            if (hit == null) continue;
            if (bounds.func_72318_a(this.toVec3d())) {
                if (!(0.0 < closetDistance) && closetDistance != 0.0) continue;
                closestEntityMOP = new RayTraceResult(entity);
                closestEntityMOP.field_72307_f = hit.field_72307_f;
                closetDistance = 0.0;
                continue;
            }
            double dist = this.distance(new Pos(hit.field_72307_f));
            if (!(dist < closetDistance) && closetDistance != 0.0) continue;
            closestEntityMOP = new RayTraceResult(entity);
            closestEntityMOP.field_72307_f = hit.field_72307_f;
            closetDistance = dist;
        }
        return closestEntityMOP;
    }

    public boolean setBlock(World world, Block block) {
        return this.setBlock(world, block.func_176223_P());
    }

    public boolean setBlock(World world, IBlockState state) {
        return this.setBlock(world, state, 3);
    }

    public boolean setBlock(World world, IBlockState block, int notify) {
        if (world != null && block != null) {
            return world.func_180501_a(this.toBlockPos(), block, notify);
        }
        return false;
    }

    public boolean setBlockToAir(World world) {
        return world.func_175698_g(this.toBlockPos());
    }

    public BlockPos toBlockPos() {
        return new BlockPos(this.xi(), this.yi(), this.zi());
    }

    public boolean isAirBlock(World world) {
        return world.func_175623_d(this.toBlockPos());
    }

    @Deprecated
    public boolean isBlockFreezable(World world) {
        return false;
    }

    public boolean isReplaceable(World world) {
        BlockPos pos = this.toBlockPos();
        IBlockState block = world.func_180495_p(pos);
        return block == null || block.func_177230_c().isAir(block, (IBlockAccess)world, pos) || block.func_177230_c().isAir(block, (IBlockAccess)world, this.toBlockPos()) || block.func_177230_c().func_176200_f((IBlockAccess)world, this.toBlockPos());
    }

    public boolean canSeeSky(World world) {
        return world.func_175678_i(this.toBlockPos());
    }

    public boolean isBlockEqual(World world, Block block) {
        Block b = this.getBlock((IBlockAccess)world);
        return b != null && b == block;
    }

    public Block getBlock(IBlockAccess world) {
        IBlockState state = this.getBlockState(world);
        if (world != null && state != null) {
            return state.func_177230_c();
        }
        return null;
    }

    public IBlockState getBlockState(IBlockAccess world) {
        if (world != null) {
            return world.func_180495_p(this.toBlockPos());
        }
        return null;
    }

    public TileEntity getTileEntity(IBlockAccess world) {
        if (world != null) {
            return world.func_175625_s(this.toBlockPos());
        }
        return null;
    }

    public float getHardness(World world) {
        IBlockState state = this.getBlockState((IBlockAccess)world);
        if (state != null && !state.func_177230_c().isAir(state, (IBlockAccess)world, this.toBlockPos())) {
            return state.func_177230_c().func_176195_g(state, world, this.toBlockPos());
        }
        return 0.0f;
    }

    public float getResistance(Entity cause) {
        return this.getResistance(cause.field_70170_p, cause, this.x(), this.y(), this.z());
    }

    public float getResistanceToEntity(Entity cause) {
        return this.getBlock((IBlockAccess)cause.field_70170_p).func_149638_a(cause);
    }

    public float getResistanceToEntity(World world, Entity cause) {
        return this.getBlock((IBlockAccess)world).func_149638_a(cause);
    }

    public float getResistance(World world, Entity cause) {
        return this.getResistance(world, cause, cause.field_70165_t, cause.field_70163_u, cause.field_70161_v);
    }

    public float getResistance(World world, Entity cause, double xx, double yy, double zz) {
        return this.getBlock((IBlockAccess)world).getExplosionResistance(world, this.toBlockPos(), cause, new Explosion(world, cause, xx, yy, zz, 1.0f, false, false));
    }

    public boolean isAboveBedrock() {
        return this.y() > 0.0;
    }

    public boolean isInsideMap() {
        return this.isAboveBedrock() && this.y() < 255.0;
    }

    public void markForUpdate(World world) {
        BlockPos pos = this.toBlockPos();
        IBlockState state = world.func_180495_p(pos);
        if (state != null && !state.func_177230_c().isAir(state, (IBlockAccess)world, this.toBlockPos())) {
            world.func_184138_a(pos, state, state, 3);
        }
    }

    public double func_82615_a() {
        return this.x();
    }

    public double func_82617_b() {
        return this.y();
    }

    public double func_82616_c() {
        return this.z();
    }
}

