/*
 * Decompiled with CFR 0.152.
 */
package nihiltres.engineersdoors.common.module;

import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistryModifiable;

public interface IModule {
    public String getName();

    public Collection<Block> getBlocks();

    public Collection<Item> getItems();

    public Collection<IRecipe> getRecipes();

    public Collection<SoundEvent> getSoundEvents();

    public Collection<Class<? extends TileEntity>> getTileEntities();

    default public void preInit() {
    }

    default public void init() {
    }

    default public void postInit() {
    }

    default public void onRecipeRegisterEvent(RegistryEvent.Register<IRecipe> event) {
    }

    public static void removeRecipes(RegistryEvent.Register<IRecipe> event, String ... recipeNames) {
        for (String rls : recipeNames) {
            ResourceLocation rl = new ResourceLocation(rls);
            ((IForgeRegistryModifiable)event.getRegistry()).remove(rl);
        }
    }
}

