/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.items;

import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.TileEntityIESlab;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDevice0;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDevice1;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConveyorBelt;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityFluidPump;
import blusunrize.immersiveengineering.common.blocks.multiblocks.MultiblockExcavatorDemo;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import com.mojang.realmsclient.gui.ChatFormatting;
import flaxbeard.immersivepetroleum.api.crafting.LubricatedHandler;
import flaxbeard.immersivepetroleum.api.event.SchematicPlaceBlockEvent;
import flaxbeard.immersivepetroleum.api.event.SchematicPlaceBlockPostEvent;
import flaxbeard.immersivepetroleum.api.event.SchematicRenderBlockEvent;
import flaxbeard.immersivepetroleum.api.event.SchematicTestEvent;
import flaxbeard.immersivepetroleum.client.ShaderUtil;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.blocks.metal.BlockTypes_Dummy;
import flaxbeard.immersivepetroleum.common.items.ItemIPBase;
import flaxbeard.immersivepetroleum.common.network.IPPacketHandler;
import flaxbeard.immersivepetroleum.common.network.RotateSchematicPacket;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class ItemProjector
extends ItemIPBase {
    boolean lastDown = false;
    private int tempCode = 99999;

    public ItemProjector(String name) {
        super(name, 1, new String[0]);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        String multiblock;
        MultiblockHandler.IMultiblock mb;
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"multiblock") && (mb = ItemProjector.getMultiblock(multiblock = ItemNBTHelper.getString((ItemStack)stack, (String)"multiblock"))) != null) {
            if ("IE:ExcavatorDemo".equals(multiblock)) {
                multiblock = "IE:Excavator";
            }
            tooltip.add(I18n.func_135052_a((String)"chat.immersivepetroleum.info.schematic.build0", (Object[])new Object[0]));
            tooltip.add(I18n.func_135052_a((String)"chat.immersivepetroleum.info.schematic.build1", (Object[])new Object[]{I18n.func_135052_a((String)("desc.immersiveengineering.info.multiblock." + multiblock), (Object[])new Object[0])}));
            int h = mb.getStructureManual().length;
            int l = mb.getStructureManual()[0].length;
            int w = mb.getStructureManual()[0][0].length;
            tooltip.add(ChatFormatting.DARK_GRAY + l + " x " + h + " x " + w);
            if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"pos")) {
                NBTTagCompound pos = ItemNBTHelper.getTagCompound((ItemStack)stack, (String)"pos");
                int x = pos.func_74762_e("x");
                int y = pos.func_74762_e("y");
                int z = pos.func_74762_e("z");
                tooltip.add(ChatFormatting.DARK_GRAY + I18n.func_135052_a((String)"chat.immersivepetroleum.info.schematic.center", (Object[])new Object[]{x, y, z}));
            } else {
                tooltip.add(ChatFormatting.DARK_GRAY + I18n.func_135052_a((String)"chat.immersivepetroleum.info.schematic.controls", (Object[])new Object[]{Minecraft.func_71410_x().field_71474_y.field_74322_I.getDisplayName(), Minecraft.func_71410_x().field_71474_y.field_74311_E.getDisplayName(), Minecraft.func_71410_x().field_71474_y.field_74322_I.getDisplayName()}));
            }
            return;
        }
        tooltip.add(ChatFormatting.DARK_GRAY + I18n.func_135052_a((String)"chat.immersivepetroleum.info.schematic.noMultiblock", (Object[])new Object[0]));
    }

    public static MultiblockHandler.IMultiblock getMultiblock(String identifier) {
        ArrayList multiblocks = MultiblockHandler.getMultiblocks();
        for (MultiblockHandler.IMultiblock multiblock : multiblocks) {
            if (!multiblock.getUniqueName().equals(identifier)) continue;
            return multiblock;
        }
        if ("IE:ExcavatorDemo".equals(identifier)) {
            return MultiblockExcavatorDemo.instance;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack stack) {
        if (stack.func_77942_o()) {
            String multiblock;
            MultiblockHandler.IMultiblock mb;
            NBTTagCompound comp = stack.func_77978_p();
            if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"multiblock") && (mb = ItemProjector.getMultiblock(multiblock = ItemNBTHelper.getString((ItemStack)stack, (String)"multiblock"))) != null) {
                if ("IE:ExcavatorDemo".equals(multiblock)) {
                    multiblock = "IE:Excavator";
                }
                return I18n.func_135052_a((String)(this.func_77657_g(stack) + ".name"), (Object[])new Object[]{I18n.func_135052_a((String)("desc.immersiveengineering.info.multiblock." + multiblock), (Object[])new Object[0])}).trim();
            }
        }
        return ("" + I18n.func_135052_a((String)(this.func_77657_g(stack) + ".name"), (Object[])new Object[]{""})).trim();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            list.add((Object)new ItemStack((Item)this, 1, 0));
            ArrayList multiblocks = MultiblockHandler.getMultiblocks();
            for (MultiblockHandler.IMultiblock multiblock : multiblocks) {
                String str = multiblock.getUniqueName();
                if (str.equals("IE:BucketWheel") || str.equals("IE:Excavator")) continue;
                ItemStack stack = new ItemStack((Item)this, 1, 0);
                ItemNBTHelper.setString((ItemStack)stack, (String)"multiblock", (String)multiblock.getUniqueName());
                list.add((Object)stack);
            }
            ItemStack stack = new ItemStack((Item)this, 1, 0);
            ItemNBTHelper.setString((ItemStack)stack, (String)"multiblock", (String)MultiblockExcavatorDemo.instance.getUniqueName());
            ItemProjector.setFlipped(stack, true);
            list.add((Object)stack);
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"pos") && playerIn.func_70093_af()) {
            ItemNBTHelper.remove((ItemStack)stack, (String)"pos");
            return EnumActionResult.SUCCESS;
        }
        MultiblockHandler.IMultiblock mb = ItemProjector.getMultiblock(ItemNBTHelper.getString((ItemStack)stack, (String)"multiblock"));
        if (!ItemNBTHelper.hasKey((ItemStack)stack, (String)"pos") && mb != null) {
            EnumFacing look;
            NBTTagCompound posTag = new NBTTagCompound();
            IBlockState state = world.func_180495_p(pos);
            BlockPos hit = pos;
            if (!state.func_177230_c().func_176200_f((IBlockAccess)world, pos) && facing == EnumFacing.UP) {
                hit = hit.func_177982_a(0, 1, 0);
            }
            int mh = mb.getStructureManual().length;
            int ml = mb.getStructureManual()[0].length;
            int mw = mb.getStructureManual()[0][0].length;
            int rotate = ItemProjector.getRotation(stack);
            int xd = rotate % 2 == 0 ? ml : mw;
            int zd = rotate % 2 == 0 ? mw : ml;
            Vec3d vec = playerIn.func_70040_Z();
            EnumFacing enumFacing = Math.abs(vec.field_72449_c) > Math.abs(vec.field_72450_a) ? (vec.field_72449_c > 0.0 ? EnumFacing.SOUTH : EnumFacing.NORTH) : (look = vec.field_72450_a > 0.0 ? EnumFacing.EAST : EnumFacing.WEST);
            if (look == EnumFacing.NORTH || look == EnumFacing.SOUTH) {
                hit = hit.func_177982_a(-xd / 2, 0, 0);
            } else if (look == EnumFacing.EAST || look == EnumFacing.WEST) {
                hit = hit.func_177982_a(0, 0, -zd / 2);
            }
            if (look == EnumFacing.NORTH) {
                hit = hit.func_177982_a(0, 0, -zd + 1);
            } else if (look == EnumFacing.WEST) {
                hit = hit.func_177982_a(-xd + 1, 0, 0);
            }
            if (playerIn.func_70093_af() && playerIn.func_184812_l_()) {
                if (mb.getUniqueName().equals("IE:ExcavatorDemo")) {
                    hit = hit.func_177982_a(0, -2, 0);
                }
                boolean flip = ItemProjector.getFlipped(stack);
                int idx = 0;
                for (int h = 0; h < mh; ++h) {
                    for (int l = 0; l < ml; ++l) {
                        for (int w = 0; w < mw; ++w) {
                            if (mb.getStructureManual()[h][l][w] == null || mb.getStructureManual()[h][l][w].func_190926_b()) continue;
                            int xo = l;
                            int zo = w;
                            switch (rotate) {
                                case 1: {
                                    zo = l;
                                    xo = mw - w - 1;
                                    break;
                                }
                                case 2: {
                                    xo = ml - l - 1;
                                    zo = mw - w - 1;
                                    break;
                                }
                                case 3: {
                                    zo = ml - l - 1;
                                    xo = w;
                                }
                            }
                            if (rotate % 2 == 1) {
                                xo = flip ? xo : mw - xo - 1;
                            } else {
                                zo = flip ? zo : mw - zo - 1;
                            }
                            BlockPos actualPos = hit.func_177982_a(xo, h, zo);
                            ItemStack toPlace = mb.getStructureManual()[h][l][w];
                            IBlockState stt = mb.getBlockstateFromStack(idx, toPlace);
                            SchematicPlaceBlockEvent placeEvent = new SchematicPlaceBlockEvent(mb, idx, stt, world, rotate, l, h, w);
                            if (MinecraftForge.EVENT_BUS.post((Event)placeEvent)) continue;
                            world.func_175656_a(actualPos, placeEvent.getBlockState());
                            SchematicPlaceBlockPostEvent postEvent = new SchematicPlaceBlockPostEvent(mb, idx, stt, actualPos, world, rotate, l, h, w);
                            MinecraftForge.EVENT_BUS.post((Event)postEvent);
                        }
                    }
                }
                return EnumActionResult.SUCCESS;
            }
            posTag.func_74768_a("x", hit.func_177958_n());
            posTag.func_74768_a("y", hit.func_177956_o());
            posTag.func_74768_a("z", hit.func_177952_p());
            ItemNBTHelper.setTagCompound((ItemStack)stack, (String)"pos", (NBTTagCompound)posTag);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public static int getRotation(ItemStack stack) {
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"rotate")) {
            return ItemNBTHelper.getInt((ItemStack)stack, (String)"rotate");
        }
        return 0;
    }

    public static boolean getFlipped(ItemStack stack) {
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"flip")) {
            return ItemNBTHelper.getBoolean((ItemStack)stack, (String)"flip");
        }
        return false;
    }

    public static void rotateClient(ItemStack stack) {
        int newRotate = (ItemProjector.getRotation(stack) + 1) % 4;
        boolean flip = ItemProjector.getFlipped(stack);
        ItemProjector.setRotate(stack, newRotate);
        IPPacketHandler.INSTANCE.sendToServer((IMessage)new RotateSchematicPacket(newRotate, flip));
    }

    public static void flipClient(ItemStack stack) {
        int newRotate = ItemProjector.getRotation(stack);
        boolean flip = !ItemProjector.getFlipped(stack);
        ItemProjector.setFlipped(stack, flip);
        IPPacketHandler.INSTANCE.sendToServer((IMessage)new RotateSchematicPacket(newRotate, flip));
    }

    public static void setRotate(ItemStack stack, int rotate) {
        ItemNBTHelper.setInt((ItemStack)stack, (String)"rotate", (int)rotate);
    }

    public static void setFlipped(ItemStack stack, boolean flip) {
        ItemNBTHelper.setBoolean((ItemStack)stack, (String)"flip", (boolean)flip);
    }

    public ActionResult<ItemStack> onItemRightClick(ItemStack stack, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"pos") && playerIn.func_70093_af()) {
            ItemNBTHelper.remove((ItemStack)stack, (String)"pos");
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void handleKeypress(TickEvent.ClientTickEvent event) {
        Minecraft mc = ClientUtils.mc();
        if (event.phase == TickEvent.Phase.START && mc.field_71439_g != null) {
            int code;
            ItemStack mainItem = mc.field_71439_g.func_184614_ca();
            ItemStack secondItem = mc.field_71439_g.func_184592_cb();
            boolean main = !mainItem.func_190926_b() && mainItem.func_77973_b() == IPContent.itemProjector && ItemNBTHelper.hasKey((ItemStack)mainItem, (String)"multiblock");
            boolean off = !secondItem.func_190926_b() && secondItem.func_77973_b() == IPContent.itemProjector && ItemNBTHelper.hasKey((ItemStack)secondItem, (String)"multiblock");
            ItemStack target = main ? mainItem : secondItem;
            WorldClient world = mc.field_71441_e;
            if ((main || off) && (code = mc.field_71474_y.field_74322_I.func_151463_i()) != 99999 && !ItemNBTHelper.hasKey((ItemStack)target, (String)"pos")) {
                if (code < 0) {
                    if (Mouse.isButtonDown((int)(code += 100))) {
                        if (!this.lastDown) {
                            if (mc.field_71439_g.func_70093_af()) {
                                ItemProjector.flipClient(target);
                            } else {
                                ItemProjector.rotateClient(target);
                            }
                        }
                        this.tempCode = code - 100;
                        mc.field_71474_y.field_74322_I.func_151462_b(99999);
                    }
                } else if (Keyboard.isKeyDown((int)code)) {
                    if (!this.lastDown) {
                        if (mc.field_71439_g.func_70093_af()) {
                            ItemProjector.flipClient(target);
                        } else {
                            ItemProjector.rotateClient(target);
                        }
                    }
                    this.tempCode = code;
                    mc.field_71474_y.field_74322_I.func_151462_b(99999);
                }
            }
        } else if (event.phase == TickEvent.Phase.END && this.tempCode != 99999) {
            mc.field_71474_y.field_74322_I.func_151462_b(this.tempCode);
            this.tempCode = 99999;
            this.lastDown = true;
        } else if (this.tempCode == 99999) {
            this.lastDown = false;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderLast(RenderWorldLastEvent event) {
        boolean off;
        boolean main;
        ItemStack secondItem;
        ItemStack mainItem;
        Minecraft mc = ClientUtils.mc();
        GlStateManager.func_179094_E();
        if (mc.field_71439_g != null) {
            mainItem = mc.field_71439_g.func_184614_ca();
            secondItem = mc.field_71439_g.func_184592_cb();
            main = !mainItem.func_190926_b() && mainItem.func_77973_b() == IPContent.itemProjector && ItemNBTHelper.hasKey((ItemStack)mainItem, (String)"multiblock");
            off = !secondItem.func_190926_b() && secondItem.func_77973_b() == IPContent.itemProjector && ItemNBTHelper.hasKey((ItemStack)secondItem, (String)"multiblock");
            for (int i = 0; i < 11; ++i) {
                ItemStack stack;
                GlStateManager.func_179094_E();
                ItemStack itemStack = stack = i == 10 ? secondItem : mc.field_71439_g.field_71071_by.func_70301_a(i);
                if (!stack.func_190926_b() && stack.func_77973_b() == IPContent.itemProjector && ItemNBTHelper.hasKey((ItemStack)stack, (String)"multiblock")) {
                    this.renderSchematic(stack, (EntityPlayer)mc.field_71439_g, mc.field_71439_g.field_70170_p, event.getPartialTicks(), i == mc.field_71439_g.field_71071_by.field_70461_c || i == 10 && off);
                }
                GlStateManager.func_179121_F();
            }
        }
        if (mc.field_71439_g != null) {
            mainItem = mc.field_71439_g.func_184614_ca();
            secondItem = mc.field_71439_g.func_184592_cb();
            main = mainItem != null && mainItem.func_77973_b() == Item.func_150898_a((Block)IPContent.blockMetalDevice);
            boolean bl = off = secondItem != null && secondItem.func_77973_b() == Item.func_150898_a((Block)IPContent.blockMetalDevice);
            if (main || off) {
                BlockPos base = mc.field_71439_g.func_180425_c();
                for (int x = -16; x <= 16; ++x) {
                    for (int z = -16; z <= 16; ++z) {
                        for (int y = -16; y <= 16; ++y) {
                            Tuple<BlockPos, EnumFacing> target;
                            LubricatedHandler.ILubricationHandler handler;
                            BlockPos pos = base.func_177982_a(x, y, z);
                            TileEntity te = mc.field_71439_g.field_70170_p.func_175625_s(pos);
                            if (te == null || (handler = LubricatedHandler.getHandlerForTile(te)) == null || (target = handler.getGhostBlockPosition(mc.field_71439_g.field_70170_p, te)) == null) continue;
                            BlockPos targetPos = (BlockPos)target.func_76341_a();
                            EnumFacing targetFacing = (EnumFacing)target.func_76340_b();
                            if (!mc.field_71439_g.field_70170_p.func_180495_p(targetPos).func_177230_c().func_176200_f((IBlockAccess)mc.field_71439_g.field_70170_p, targetPos) || !mc.field_71439_g.field_70170_p.func_180495_p(targetPos.func_177984_a()).func_177230_c().func_176200_f((IBlockAccess)mc.field_71439_g.field_70170_p, targetPos.func_177984_a())) continue;
                            GlStateManager.func_179094_E();
                            float alpha = 0.5f;
                            ShaderUtil.alpha_static(alpha, mc.field_71439_g.field_70173_aa);
                            double px = TileEntityRendererDispatcher.field_147554_b;
                            double py = TileEntityRendererDispatcher.field_147555_c;
                            double pz = TileEntityRendererDispatcher.field_147552_d;
                            GlStateManager.func_179137_b((double)((double)targetPos.func_177958_n() - px), (double)((double)targetPos.func_177956_o() - py), (double)((double)targetPos.func_177952_p() - pz));
                            GlStateManager.func_179137_b((double)0.5, (double)-0.13, (double)0.5);
                            switch (targetFacing) {
                                case SOUTH: {
                                    GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                                    break;
                                }
                                case NORTH: {
                                    GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                                    break;
                                }
                                case WEST: {
                                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                                    break;
                                }
                                case EAST: {
                                    break;
                                }
                            }
                            GlStateManager.func_179137_b((double)0.02, (double)0.0, (double)0.019);
                            GlStateManager.func_179152_a((float)1.5384616f, (float)1.5384616f, (float)1.5384616f);
                            GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
                            ItemStack toRender = new ItemStack(Item.func_150898_a((Block)IPContent.blockMetalDevice));
                            ClientUtils.mc().func_175599_af().func_181564_a(toRender, ItemCameraTransforms.TransformType.FIXED);
                            ShaderUtil.releaseShader();
                            GlStateManager.func_179121_F();
                        }
                    }
                }
            }
        }
        GlStateManager.func_179121_F();
    }

    public void renderSchematic(ItemStack target, EntityPlayer player, World world, float partialTicks, boolean shouldRenderMoving) {
        Minecraft mc = ClientUtils.mc();
        MultiblockHandler.IMultiblock mb = ItemProjector.getMultiblock(ItemNBTHelper.getString((ItemStack)target, (String)"multiblock"));
        if (mb != null) {
            NBTTagCompound pos;
            ItemStack heldStack = player.func_184614_ca();
            int mh = mb.getStructureManual().length;
            int ml = mb.getStructureManual()[0].length;
            int mw = mb.getStructureManual()[0][0].length;
            int rotate = ItemProjector.getRotation(target);
            boolean flip = ItemProjector.getFlipped(target);
            int xd = rotate % 2 == 0 ? ml : mw;
            int zd = rotate % 2 == 0 ? mw : ml;
            Object hit = null;
            boolean isPlaced = false;
            if (ItemNBTHelper.hasKey((ItemStack)target, (String)"pos")) {
                pos = ItemNBTHelper.getTagCompound((ItemStack)target, (String)"pos");
                int x = pos.func_74762_e("x");
                int y = pos.func_74762_e("y");
                int z = pos.func_74762_e("z");
                hit = new BlockPos(x, y, z);
                isPlaced = true;
            } else if (shouldRenderMoving && ClientUtils.mc().field_71476_x != null && ClientUtils.mc().field_71476_x.field_72313_a == RayTraceResult.Type.BLOCK) {
                EnumFacing facing;
                pos = ClientUtils.mc().field_71476_x.func_178782_a();
                IBlockState state = world.func_180495_p((BlockPos)pos);
                hit = state.func_177230_c().func_176200_f((IBlockAccess)world, (BlockPos)pos) || ClientUtils.mc().field_71476_x.field_178784_b != EnumFacing.UP ? pos : pos.func_177982_a(0, 1, 0);
                Vec3d vec = mc.field_71439_g.func_70040_Z();
                EnumFacing enumFacing = Math.abs(vec.field_72449_c) > Math.abs(vec.field_72450_a) ? (vec.field_72449_c > 0.0 ? EnumFacing.SOUTH : EnumFacing.NORTH) : (facing = vec.field_72450_a > 0.0 ? EnumFacing.EAST : EnumFacing.WEST);
                if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
                    hit = hit.func_177982_a(-xd / 2, 0, 0);
                } else if (facing == EnumFacing.EAST || facing == EnumFacing.WEST) {
                    hit = hit.func_177982_a(0, 0, -zd / 2);
                }
                if (facing == EnumFacing.NORTH) {
                    hit = hit.func_177982_a(0, 0, -zd + 1);
                } else if (facing == EnumFacing.WEST) {
                    hit = hit.func_177982_a(-xd + 1, 0, 0);
                }
            }
            if (hit != null) {
                Object testEvent;
                int[] ids;
                boolean otherStateEqual;
                boolean stateEqual;
                IBlockState actualState;
                IBlockState state;
                ItemStack stack;
                IBlockState otherState;
                BlockPos actualPos;
                int zo;
                int xo;
                BlockPos blockPos;
                BlockPos pos2;
                int w;
                int l;
                boolean slicePerfect;
                int h;
                if (mb.getUniqueName().equals("IE:ExcavatorDemo")) {
                    hit = hit.func_177982_a(0, -2, 0);
                }
                double px = TileEntityRendererDispatcher.field_147554_b;
                double py = TileEntityRendererDispatcher.field_147555_c;
                double pz = TileEntityRendererDispatcher.field_147552_d;
                BlockRendererDispatcher blockRender = Minecraft.func_71410_x().func_175602_ab();
                GlStateManager.func_179137_b((double)((double)hit.func_177958_n() - px), (double)((double)hit.func_177956_o() - py), (double)((double)hit.func_177952_p() - pz));
                GlStateManager.func_179140_f();
                if (Minecraft.func_71379_u()) {
                    GlStateManager.func_179103_j((int)7425);
                } else {
                    GlStateManager.func_179103_j((int)7424);
                }
                ClientUtils.mc().func_110434_K().func_110577_a(TextureMap.field_110575_b);
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder buffer = tessellator.func_178180_c();
                float flicker = world.field_73012_v.nextInt(10) == 0 ? 0.75f : (world.field_73012_v.nextInt(20) == 0 ? 0.5f : 1.0f);
                boolean perfect = true;
                int idx = 0;
                for (h = 0; h < mh; ++h) {
                    slicePerfect = true;
                    for (l = 0; l < ml; ++l) {
                        for (w = 0; w < mw; ++w) {
                            pos2 = new BlockPos(l, h, w);
                            GlStateManager.func_179094_E();
                            if (mb.getStructureManual()[h][l][w] != null && !mb.getStructureManual()[h][l][w].func_190926_b()) {
                                blockPos = new BlockPos(0, 0, 0);
                                xo = l;
                                zo = w;
                                switch (rotate) {
                                    case 1: {
                                        zo = l;
                                        xo = mw - w - 1;
                                        break;
                                    }
                                    case 2: {
                                        xo = ml - l - 1;
                                        zo = mw - w - 1;
                                        break;
                                    }
                                    case 3: {
                                        zo = ml - l - 1;
                                        xo = w;
                                    }
                                }
                                if (rotate % 2 == 1) {
                                    xo = flip ? xo : mw - xo - 1;
                                } else {
                                    zo = flip ? zo : mw - zo - 1;
                                }
                                actualPos = hit.func_177982_a(xo, h, zo);
                                otherState = null;
                                if (!heldStack.func_190926_b() && heldStack.func_77973_b() instanceof ItemBlock) {
                                    otherState = ((ItemBlock)heldStack.func_77973_b()).func_179223_d().func_176203_a(heldStack.func_77952_i());
                                }
                                stack = mb.getStructureManual()[h][l][w];
                                state = mb.getBlockstateFromStack(idx, stack);
                                actualState = world.func_180495_p(actualPos);
                                stateEqual = actualState.equals(state);
                                otherStateEqual = otherState == null ? false : otherState.equals(state);
                                for (int id : ids = OreDictionary.getOreIDs((ItemStack)stack)) {
                                    String idS = OreDictionary.getOreName((int)id);
                                    if (!Utils.isOreBlockAt((World)world, (BlockPos)actualPos, (String)idS)) continue;
                                    stateEqual = true;
                                }
                                testEvent = (Object)new SchematicTestEvent(stateEqual, mb, idx, stack, world, actualPos, rotate, l, h, w);
                                MinecraftForge.EVENT_BUS.post((Event)testEvent);
                                stateEqual = ((SchematicTestEvent)((Object)testEvent)).isEqual();
                                if (!heldStack.func_190926_b() && otherState != null) {
                                    int[] ids2;
                                    int id;
                                    int[] nArray = ids2 = OreDictionary.getOreIDs((ItemStack)heldStack);
                                    id = nArray.length;
                                    for (int idS = 0; idS < id; ++idS) {
                                        int id2 = nArray[idS];
                                        for (int id3 : ids) {
                                            if (id3 != id2) continue;
                                            otherStateEqual = true;
                                        }
                                    }
                                }
                                boolean isEmpty = world.func_180495_p(actualPos).func_177230_c().func_176200_f((IBlockAccess)world, actualPos);
                                perfect &= stateEqual;
                                if (!stateEqual && isEmpty) {
                                    slicePerfect = false;
                                    float alpha = otherStateEqual ? 0.75f : 0.5f;
                                    ShaderUtil.alpha_static(flicker * alpha, (float)mc.field_71439_g.field_70173_aa + partialTicks);
                                    GlStateManager.func_179109_b((float)xo, (float)h, (float)zo);
                                    GlStateManager.func_179137_b((double)0.5, (double)0.5, (double)0.5);
                                    GlStateManager.func_179139_a((double)2.01, (double)2.01, (double)2.01);
                                    SchematicRenderBlockEvent renderEvent = new SchematicRenderBlockEvent(mb, idx, stack, world, rotate, l, h, w);
                                    if (!MinecraftForge.EVENT_BUS.post((Event)renderEvent)) {
                                        ItemStack toRender = renderEvent.getItemStack();
                                        ClientUtils.mc().func_175599_af().func_181564_a(toRender, ItemCameraTransforms.TransformType.FIXED);
                                    }
                                    ShaderUtil.releaseShader();
                                }
                            }
                            GlStateManager.func_179121_F();
                            ++idx;
                        }
                    }
                    if (!slicePerfect && isPlaced) break;
                }
                idx = 0;
                GlStateManager.func_179097_i();
                for (h = 0; h < mh; ++h) {
                    slicePerfect = true;
                    for (l = 0; l < ml; ++l) {
                        for (w = 0; w < mw; ++w) {
                            pos2 = new BlockPos(l, h, w);
                            GlStateManager.func_179094_E();
                            if (mb.getStructureManual()[h][l][w] != null && !mb.getStructureManual()[h][l][w].func_190926_b()) {
                                blockPos = new BlockPos(0, 0, 0);
                                xo = l;
                                zo = w;
                                switch (rotate) {
                                    case 1: {
                                        zo = l;
                                        xo = mw - w - 1;
                                        break;
                                    }
                                    case 2: {
                                        xo = ml - l - 1;
                                        zo = mw - w - 1;
                                        break;
                                    }
                                    case 3: {
                                        zo = ml - l - 1;
                                        xo = w;
                                    }
                                }
                                if (rotate % 2 == 1) {
                                    xo = flip ? xo : mw - xo - 1;
                                } else {
                                    zo = flip ? zo : mw - zo - 1;
                                }
                                actualPos = hit.func_177982_a(xo, h, zo);
                                otherState = null;
                                if (!heldStack.func_190926_b() && heldStack.func_77973_b() instanceof ItemBlock) {
                                    otherState = ((ItemBlock)heldStack.func_77973_b()).func_179223_d().func_176203_a(heldStack.func_77952_i());
                                }
                                stack = mb.getStructureManual()[h][l][w];
                                state = mb.getBlockstateFromStack(idx, stack);
                                actualState = world.func_180495_p(actualPos);
                                stateEqual = actualState.equals(state);
                                otherStateEqual = otherState == null ? false : otherState.equals(state);
                                ids = OreDictionary.getOreIDs((ItemStack)stack);
                                for (int id : ids) {
                                    String idS = OreDictionary.getOreName((int)id);
                                    if (!Utils.isOreBlockAt((World)world, (BlockPos)actualPos, (String)idS)) continue;
                                    stateEqual = true;
                                }
                                testEvent = new SchematicTestEvent(stateEqual, mb, idx, stack, world, actualPos, rotate, l, h, w);
                                MinecraftForge.EVENT_BUS.post((Event)testEvent);
                                stateEqual = ((SchematicTestEvent)((Object)testEvent)).isEqual();
                                if (!heldStack.func_190926_b() && otherState != null) {
                                    int[] ids2;
                                    for (int id2 : ids2 = OreDictionary.getOreIDs((ItemStack)heldStack)) {
                                        for (int id3 : ids) {
                                            if (id3 != id2) continue;
                                            otherStateEqual = true;
                                        }
                                    }
                                }
                                if (!stateEqual) {
                                    boolean isEmpty = world.func_180495_p(actualPos).func_177230_c().func_176200_f((IBlockAccess)world, actualPos);
                                    if (isEmpty) {
                                        slicePerfect = false;
                                    }
                                    if (!isEmpty || otherStateEqual) {
                                        GlStateManager.func_179094_E();
                                        GlStateManager.func_179090_x();
                                        GlStateManager.func_179147_l();
                                        GlStateManager.func_179129_p();
                                        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
                                        GlStateManager.func_179103_j((int)7425);
                                        float r = 1.0f;
                                        float g = !isEmpty ? 0.0f : 1.0f;
                                        float b = !isEmpty ? 0.0f : 1.0f;
                                        float alpha = 0.375f * flicker;
                                        GlStateManager.func_179137_b((double)((double)xo + 0.5), (double)((double)h + 0.5), (double)((double)zo + 0.5));
                                        GlStateManager.func_179139_a((double)1.01, (double)1.01, (double)1.01);
                                        GlStateManager.func_187441_d((float)2.0f);
                                        buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
                                        buffer.func_181662_b(-0.5, 0.5, -0.5).func_181666_a(r, g, b, alpha).func_181675_d();
                                        buffer.func_181662_b(0.5, 0.5, -0.5).func_181666_a(r, g, b, alpha).func_181675_d();
                                        buffer.func_181662_b(0.5, 0.5, -0.5).func_181666_a(r, g, b, alpha).func_181675_d();
                                        buffer.func_181662_b(0.5, 0.5, 0.5).func_181666_a(r, g, b, alpha).func_181675_d();
                                        buffer.func_181662_b(0.5, 0.5, 0.5).func_181666_a(r, g, b, alpha).func_181675_d();
                                        buffer.func_181662_b(-0.5, 0.5, 0.5).func_181666_a(r, g, b, alpha).func_181675_d();
                                        buffer.func_181662_b(-0.5, 0.5, 0.5).func_181666_a(r, g, b, alpha).func_181675_d();
                                        buffer.func_181662_b(-0.5, 0.5, -0.5).func_181666_a(r, g, b, alpha).func_181675_d();
                                        buffer.func_181662_b(-0.5, 0.5, -0.5).func_181666_a(r, g, b, alpha).func_181675_d();
                                        buffer.func_181662_b(-0.5, -0.5, -0.5).func_181666_a(r, g, b, alpha).func_181675_d();
                                        buffer.func_181662_b(0.5, 0.5, -0.5).func_181666_a(r, g, b, alpha).func_181675_d();
                                        buffer.func_181662_b(0.5, -0.5, -0.5).func_181666_a(r, g, b, alpha).func_181675_d();
                                        buffer.func_181662_b(-0.5, 0.5, 0.5).func_181666_a(r, g, b, alpha).func_181675_d();
                                        buffer.func_181662_b(-0.5, -0.5, 0.5).func_181666_a(r, g, b, alpha).func_181675_d();
                                        buffer.func_181662_b(0.5, 0.5, 0.5).func_181666_a(r, g, b, alpha).func_181675_d();
                                        buffer.func_181662_b(0.5, -0.5, 0.5).func_181666_a(r, g, b, alpha).func_181675_d();
                                        buffer.func_181662_b(-0.5, -0.5, -0.5).func_181666_a(r, g, b, alpha).func_181675_d();
                                        buffer.func_181662_b(0.5, -0.5, -0.5).func_181666_a(r, g, b, alpha).func_181675_d();
                                        buffer.func_181662_b(0.5, -0.5, -0.5).func_181666_a(r, g, b, alpha).func_181675_d();
                                        buffer.func_181662_b(0.5, -0.5, 0.5).func_181666_a(r, g, b, alpha).func_181675_d();
                                        buffer.func_181662_b(0.5, -0.5, 0.5).func_181666_a(r, g, b, alpha).func_181675_d();
                                        buffer.func_181662_b(-0.5, -0.5, 0.5).func_181666_a(r, g, b, alpha).func_181675_d();
                                        buffer.func_181662_b(-0.5, -0.5, 0.5).func_181666_a(r, g, b, alpha).func_181675_d();
                                        buffer.func_181662_b(-0.5, -0.5, -0.5).func_181666_a(r, g, b, alpha).func_181675_d();
                                        tessellator.func_78381_a();
                                        buffer.func_178969_c(0.0, 0.0, 0.0);
                                        GlStateManager.func_179103_j((int)7424);
                                        GlStateManager.func_179089_o();
                                        GlStateManager.func_179084_k();
                                        GlStateManager.func_179098_w();
                                        GlStateManager.func_179121_F();
                                    }
                                }
                            }
                            GlStateManager.func_179121_F();
                            ++idx;
                        }
                    }
                    if (!slicePerfect && isPlaced) break;
                }
                if (perfect) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179090_x();
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179129_p();
                    GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
                    GlStateManager.func_179103_j((int)7425);
                    float r = 0.0f;
                    float g = 1.0f;
                    float b = 0.0f;
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179152_a((float)xd, (float)mh, (float)zd);
                    GlStateManager.func_187441_d((float)2.0f);
                    buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
                    buffer.func_181662_b(0.0, 1.0, 0.0).func_181666_a(r, g, b, 0.375f).func_181675_d();
                    buffer.func_181662_b(1.0, 1.0, 0.0).func_181666_a(r, g, b, 0.375f).func_181675_d();
                    buffer.func_181662_b(1.0, 1.0, 0.0).func_181666_a(r, g, b, 0.375f).func_181675_d();
                    buffer.func_181662_b(1.0, 1.0, 1.0).func_181666_a(r, g, b, 0.375f).func_181675_d();
                    buffer.func_181662_b(1.0, 1.0, 1.0).func_181666_a(r, g, b, 0.375f).func_181675_d();
                    buffer.func_181662_b(0.0, 1.0, 1.0).func_181666_a(r, g, b, 0.375f).func_181675_d();
                    buffer.func_181662_b(0.0, 1.0, 1.0).func_181666_a(r, g, b, 0.375f).func_181675_d();
                    buffer.func_181662_b(0.0, 1.0, 0.0).func_181666_a(r, g, b, 0.375f).func_181675_d();
                    buffer.func_181662_b(0.0, 1.0, 0.0).func_181666_a(r, g, b, 0.375f).func_181675_d();
                    buffer.func_181662_b(0.0, 0.0, 0.0).func_181666_a(r, g, b, 0.375f).func_181675_d();
                    buffer.func_181662_b(1.0, 1.0, 0.0).func_181666_a(r, g, b, 0.375f).func_181675_d();
                    buffer.func_181662_b(1.0, 0.0, 0.0).func_181666_a(r, g, b, 0.375f).func_181675_d();
                    buffer.func_181662_b(0.0, 1.0, 1.0).func_181666_a(r, g, b, 0.375f).func_181675_d();
                    buffer.func_181662_b(0.0, 0.0, 1.0).func_181666_a(r, g, b, 0.375f).func_181675_d();
                    buffer.func_181662_b(1.0, 1.0, 1.0).func_181666_a(r, g, b, 0.375f).func_181675_d();
                    buffer.func_181662_b(1.0, 0.0, 1.0).func_181666_a(r, g, b, 0.375f).func_181675_d();
                    buffer.func_181662_b(0.0, 0.0, 0.0).func_181666_a(r, g, b, 0.375f).func_181675_d();
                    buffer.func_181662_b(1.0, 0.0, 0.0).func_181666_a(r, g, b, 0.375f).func_181675_d();
                    buffer.func_181662_b(1.0, 0.0, 0.0).func_181666_a(r, g, b, 0.375f).func_181675_d();
                    buffer.func_181662_b(1.0, 0.0, 1.0).func_181666_a(r, g, b, 0.375f).func_181675_d();
                    buffer.func_181662_b(1.0, 0.0, 1.0).func_181666_a(r, g, b, 0.375f).func_181675_d();
                    buffer.func_181662_b(0.0, 0.0, 1.0).func_181666_a(r, g, b, 0.375f).func_181675_d();
                    buffer.func_181662_b(0.0, 0.0, 1.0).func_181666_a(r, g, b, 0.375f).func_181675_d();
                    buffer.func_181662_b(0.0, 0.0, 0.0).func_181666_a(r, g, b, 0.375f).func_181675_d();
                    tessellator.func_78381_a();
                    buffer.func_178969_c(0.0, 0.0, 0.0);
                    GlStateManager.func_179103_j((int)7424);
                    GlStateManager.func_179089_o();
                    GlStateManager.func_179084_k();
                    GlStateManager.func_179098_w();
                    GlStateManager.func_179121_F();
                }
                RenderHelper.func_74518_a();
                GlStateManager.func_179101_C();
                GlStateManager.func_179147_l();
                RenderHelper.func_74518_a();
            }
        }
        GlStateManager.func_179126_j();
    }

    @SubscribeEvent
    public void handlePumpPlace(SchematicPlaceBlockPostEvent event) {
        ItemStack stack;
        MultiblockHandler.IMultiblock mb = event.getMultiblock();
        IBlockState state = event.getBlockState();
        if (event.getH() < mb.getStructureManual().length - 1 && (stack = mb.getStructureManual()[event.getH() + 1][event.getL()][event.getW()]) != null && !stack.func_190926_b() && state.func_177230_c() == IEContent.blockMetalDevice0 && state.func_177230_c().func_176201_c(state) == BlockTypes_MetalDevice0.FLUID_PUMP.getMeta() && stack.func_77952_i() == BlockTypes_MetalDevice0.FLUID_PUMP.getMeta() && stack.func_77973_b() == Item.func_150898_a((Block)IEContent.blockMetalDevice0)) {
            TileEntityFluidPump pump = (TileEntityFluidPump)event.getWorld().func_175625_s(event.getPos());
            pump.placeDummies(event.getPos(), state, EnumFacing.UP, 0.0f, 0.0f, 0.0f);
            event.getWorld().func_175656_a(event.getPos(), event.getBlockState());
        }
    }

    @SubscribeEvent
    public void handleConveyorPlace(SchematicPlaceBlockPostEvent event) {
        TileEntity te;
        MultiblockHandler.IMultiblock mb = event.getMultiblock();
        IBlockState state = event.getBlockState();
        if ((mb.getUniqueName().equals("IE:AutoWorkbench") || mb.getUniqueName().equals("IE:BottlingMachine") || mb.getUniqueName().equals("IE:Assembler") || mb.getUniqueName().equals("IE:BottlingMachine") || mb.getUniqueName().equals("IE:MetalPress")) && state.func_177230_c() == IEContent.blockConveyor && (te = event.getWorld().func_175625_s(event.getPos())) instanceof TileEntityConveyorBelt) {
            TileEntityConveyorBelt conveyor = (TileEntityConveyorBelt)te;
            ResourceLocation rl = new ResourceLocation("immersiveengineering", "conveyor");
            ConveyorHandler.IConveyorBelt subType = ConveyorHandler.getConveyor((ResourceLocation)rl, (TileEntity)conveyor);
            conveyor.setConveyorSubtype(subType);
            EnumFacing facing = ((TileEntityConveyorBelt)te).facing;
            if (mb.getUniqueName().equals("IE:AutoWorkbench") && (event.getW() != 1 || event.getL() != 2) || mb.getUniqueName().equals("IE:BottlingMachine")) {
                conveyor.setFacing(event.getRotate().func_176746_e());
            } else if (mb.getUniqueName().equals("IE:AutoWorkbench") && (event.getRotate() == EnumFacing.WEST || event.getRotate() == EnumFacing.EAST)) {
                conveyor.setFacing(event.getRotate().func_176734_d());
            } else {
                conveyor.setFacing(event.getRotate());
            }
            event.getWorld().func_175656_a(event.getPos(), event.getBlockState());
        }
    }

    @SubscribeEvent
    public void handleConveyorTest(SchematicTestEvent event) {
        MultiblockHandler.IMultiblock mb = event.getMultiblock();
        IBlockState state = event.getMultiblock().getBlockstateFromStack(event.getIndex(), event.getItemStack());
        if ((mb.getUniqueName().equals("IE:AutoWorkbench") || mb.getUniqueName().equals("IE:BottlingMachine") || mb.getUniqueName().equals("IE:Assembler") || mb.getUniqueName().equals("IE:BottlingMachine") || mb.getUniqueName().equals("IE:MetalPress")) && state.func_177230_c() == IEContent.blockConveyor) {
            TileEntity te = event.getWorld().func_175625_s(event.getPos());
            if (te instanceof TileEntityConveyorBelt) {
                ConveyorHandler.IConveyorBelt subtype = ((TileEntityConveyorBelt)te).getConveyorSubtype();
                if (subtype != null && subtype.getConveyorDirection() != ConveyorHandler.ConveyorDirection.HORIZONTAL) {
                    event.setIsEqual(false);
                    return;
                }
                EnumFacing facing = ((TileEntityConveyorBelt)te).facing;
                if (event.isEqual() && mb.getUniqueName().equals("IE:AutoWorkbench") && (event.getW() != 1 || event.getL() != 2) || mb.getUniqueName().equals("IE:BottlingMachine")) {
                    if (facing != event.getRotate().func_176746_e()) {
                        event.setIsEqual(false);
                        return;
                    }
                } else if (facing != event.getRotate()) {
                    event.setIsEqual(false);
                    return;
                }
            } else {
                event.setIsEqual(false);
                return;
            }
        }
        if (mb.getUniqueName().equals("IP:DistillationTower") && state.func_177230_c() == IEContent.blockMetalDecorationSlabs1 && event.getWorld().func_180495_p(event.getPos()).func_177230_c() == IEContent.blockMetalDecorationSlabs1) {
            event.setIsEqual(true);
        }
    }

    public boolean doesIntersect(EntityPlayer player, ItemStack target, BlockPos check) {
        MultiblockHandler.IMultiblock mb = ItemProjector.getMultiblock(ItemNBTHelper.getString((ItemStack)target, (String)"multiblock"));
        if (mb != null) {
            int mh = mb.getStructureManual().length;
            int ml = mb.getStructureManual()[0].length;
            int mw = mb.getStructureManual()[0][0].length;
            int rotate = ItemProjector.getRotation(target);
            boolean flip = ItemProjector.getFlipped(target);
            int xd = rotate % 2 == 0 ? ml : mw;
            int zd = rotate % 2 == 0 ? mw : ml;
            boolean isPlaced = false;
            if (ItemNBTHelper.hasKey((ItemStack)target, (String)"pos")) {
                NBTTagCompound pos = ItemNBTHelper.getTagCompound((ItemStack)target, (String)"pos");
                int x = pos.func_74762_e("x");
                int y = pos.func_74762_e("y");
                int z = pos.func_74762_e("z");
                BlockPos hit = new BlockPos(x, y, z);
                BlockPos end = hit.func_177982_a(xd, mh, zd);
                return check.func_177958_n() >= hit.func_177958_n() && check.func_177958_n() <= end.func_177958_n() && check.func_177956_o() >= hit.func_177956_o() && check.func_177956_o() <= end.func_177956_o() && check.func_177952_p() >= hit.func_177952_p() && check.func_177952_p() <= end.func_177952_p();
            }
        }
        return false;
    }

    @SubscribeEvent
    public void handleConveyorsAndPipes(SchematicRenderBlockEvent event) {
        IBlockState state;
        if (event.getMultiblock().getUniqueName().equals("IE:BottlingMachine") && event.getH() == 2) {
            event.setCanceled(true);
        }
        if ((state = event.getMultiblock().getBlockstateFromStack(event.getIndex(), event.getItemStack())).func_177230_c() == IEContent.blockMetalDevice1 && BlockTypes_MetalDevice1.values()[state.func_177230_c().func_176201_c(state)] == BlockTypes_MetalDevice1.FLUID_PIPE) {
            event.setItemStack(new ItemStack((Block)IPContent.blockDummy, 1, BlockTypes_Dummy.PIPE.getMeta()));
        } else if (state.func_177230_c() == IEContent.blockConveyor) {
            event.setItemStack(new ItemStack((Block)IPContent.blockDummy, 1, BlockTypes_Dummy.CONVEYOR.getMeta()));
        }
        EnumFacing rotate = event.getRotate();
        MultiblockHandler.IMultiblock mb = event.getMultiblock();
        if (state.func_177230_c() == IEContent.blockConveyor) {
            switch (rotate) {
                case WEST: {
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case NORTH: {
                    GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case SOUTH: {
                    GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
            }
            if (mb.getUniqueName().equals("IE:AutoWorkbench") && (event.getW() != 1 || event.getL() != 2) || mb.getUniqueName().equals("IE:BottlingMachine")) {
                GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else if (mb.getUniqueName().equals("IE:AutoWorkbench") && (rotate == EnumFacing.WEST || rotate == EnumFacing.EAST)) {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else if (state.func_177230_c() == IEContent.blockMetalDevice0 && BlockTypes_MetalDevice0.values()[state.func_177230_c().func_176201_c(state)] == BlockTypes_MetalDevice0.FLUID_PUMP) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.225f, (float)0.0f);
            GlStateManager.func_179152_a((float)0.9f, (float)0.9f, (float)0.9f);
        } else if (state.func_177230_c() == Blocks.field_150331_J) {
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (mb.getUniqueName().equals("IP:DistillationTower") && state.func_177230_c() == IEContent.blockMetalDecorationSlabs1) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.25f, (float)0.0f);
        }
    }

    @SubscribeEvent
    public void handleSlabPlace(SchematicPlaceBlockPostEvent event) {
        TileEntity te;
        MultiblockHandler.IMultiblock mb = event.getMultiblock();
        IBlockState state = event.getBlockState();
        if (mb.getUniqueName().equals("IP:DistillationTower") && (te = event.getWorld().func_175625_s(event.getPos())) instanceof TileEntityIESlab) {
            ((TileEntityIESlab)te).slabType = 1;
        }
    }
}

