/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla.crafting;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class CraftingManagerCS4 {
    private static final Map<ResourceLocation, CraftingManagerCS4> instances = Maps.newHashMap();
    private final List<IRecipe> recipes = Lists.newArrayList();

    public static CraftingManagerCS4 getInstance(ResourceLocation list) {
        if (!instances.containsKey(list)) {
            instances.put(list, new CraftingManagerCS4());
        }
        return instances.get(list);
    }

    public static List<IRecipe> getRecipes(ResourceLocation list) {
        if (list.toString().equals("minecraft:vanilla")) {
            return Lists.newArrayList((Iterator)CraftingManager.field_193380_a.iterator());
        }
        return CraftingManagerCS4.getInstance((ResourceLocation)list).recipes;
    }

    private static Iterable<IRecipe> getRecipesIterable(ResourceLocation list) {
        if (list.toString().equals("minecraft:vanilla")) {
            return CraftingManager.field_193380_a;
        }
        return CraftingManagerCS4.getInstance((ResourceLocation)list).recipes;
    }

    public static void addRecipe(ResourceLocation list, IRecipe recipe) {
        Preconditions.checkArgument((!list.toString().equals("minecraft:vanilla") ? 1 : 0) != 0, (Object)"Trying to add a recipe for the vanilla list.");
        CraftingManagerCS4.getRecipes(list).add(recipe);
    }

    public static ItemStack findMatchingRecipe(ResourceLocation list, InventoryCrafting craftMatrix, World worldIn) {
        return CraftingManagerCS4.findMatchingRecipe(CraftingManagerCS4.getRecipesIterable(list), craftMatrix, worldIn);
    }

    public static ItemStack findMatchingRecipe(Iterable<IRecipe> recipes, InventoryCrafting craftMatrix, World worldIn) {
        for (IRecipe irecipe : recipes) {
            if (!irecipe.func_77569_a(craftMatrix, worldIn)) continue;
            return irecipe.func_77572_b(craftMatrix);
        }
        return ItemStack.field_190927_a;
    }
}

