/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla.item;

import cubex2.cs4.plugins.vanilla.ContentItemFluidContainer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFluidContainer
extends net.minecraftforge.fluids.capability.ItemFluidContainer {
    private final ContentItemFluidContainer content;

    public ItemFluidContainer(ContentItemFluidContainer content) {
        super(content.capacity);
        this.content = content;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(@Nullable CreativeTabs tab, @Nonnull NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            subItems.add((Object)new ItemStack((Item)this));
            for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
                FluidStack fs;
                ItemStack stack;
                FluidHandlerItemStack fluidHandler;
                if (fluid.getName().equals("milk") || (fluidHandler = new FluidHandlerItemStack(stack = new ItemStack((Item)this), this.content.capacity)).fill(fs = new FluidStack(fluid, this.content.capacity), true) != fs.amount) continue;
                ItemStack filled = fluidHandler.getContainer();
                subItems.add((Object)filled);
            }
        }
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        FluidStack fluidStack = this.getFluid(stack);
        if (fluidStack == null) {
            return super.func_77653_i(stack);
        }
        String unloc = this.func_77657_g(stack);
        if (I18n.func_94522_b((String)(unloc + "." + fluidStack.getFluid().getName()))) {
            return I18n.func_74838_a((String)(unloc + "." + fluidStack.getFluid().getName()));
        }
        return I18n.func_74837_a((String)(unloc + ".filled.name"), (Object[])new Object[]{fluidStack.getLocalizedName()});
    }

    @Nullable
    public FluidStack getFluid(@Nonnull ItemStack container) {
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.func_179543_a("Fluid"));
    }

    @Nonnull
    public ItemStack getContainerItem(@Nonnull ItemStack itemStack) {
        return new ItemStack((Item)this);
    }

    public boolean hasContainerItem(@Nonnull ItemStack stack) {
        return true;
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public int getItemBurnTime(ItemStack itemStack) {
        return this.content.burnTime.get(itemStack.func_77960_j()).orElse(-1);
    }
}

