/*
 * Decompiled with CFR 0.152.
 */
package com.sosnitzka.taiga.traits;

import com.sosnitzka.taiga.util.Utils;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;

public class TraitCongenial
extends AbstractTrait {
    public TraitCongenial() {
        super(TraitCongenial.class.getSimpleName().toLowerCase().substring(5), TextFormatting.RED);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onEntityKill(LivingDeathEvent e) {
        if (e.getSource().func_76346_g() instanceof EntityPlayer && !e.getSource().func_76346_g().field_70170_p.field_72995_K && e.getEntity() instanceof EntityCreature && TinkerUtil.hasTrait((NBTTagCompound)TagUtil.getTagSafe((ItemStack)((EntityPlayer)e.getSource().func_76346_g()).func_184614_ca()), (String)this.identifier)) {
            ItemStack tool = ((EntityPlayer)e.getSource().func_76346_g()).func_184614_ca();
            String name = e.getEntity().func_70005_c_();
            NBTTagCompound tag = TagUtil.getExtraTag((ItemStack)tool);
            Utils.GeneralNBTData data = Utils.GeneralNBTData.read(tag);
            if (!data.name.isEmpty()) {
                return;
            }
            data.name = name;
            data.write(tag);
            TagUtil.setExtraTag((ItemStack)tool, (NBTTagCompound)tag);
        }
    }

    public float damage(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damage, float newDamage, boolean isCritical) {
        World w = player.func_130014_f_();
        if (!w.field_72995_K) {
            NBTTagCompound tag = TagUtil.getExtraTag((ItemStack)tool);
            Utils.GeneralNBTData data = Utils.GeneralNBTData.read(tag);
            if (data.name.isEmpty()) {
                return damage;
            }
            if (!data.name.equals(target.func_70005_c_())) {
                return damage / (float)(random.nextInt(5) + 5);
            }
            float x = 1.0f + random.nextFloat() * 9.0f;
            return damage * x;
        }
        return damage;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent e) {
        ItemStack tool = e.getItemStack();
        if (TinkerUtil.hasTrait((NBTTagCompound)TagUtil.getTagSafe((ItemStack)tool), (String)this.identifier)) {
            NBTTagCompound tag = TagUtil.getExtraTag((ItemStack)tool);
            Utils.GeneralNBTData data = Utils.GeneralNBTData.read(tag);
            if (data.name.isEmpty()) {
                e.getToolTip().add(TextFormatting.LIGHT_PURPLE + "Unbound");
            } else {
                e.getToolTip().add(TextFormatting.DARK_PURPLE + "Bound to: " + TextFormatting.LIGHT_PURPLE + data.name);
            }
        }
    }
}

