/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.models;

import forestry.api.core.IModelBaker;
import forestry.core.blocks.properties.UnlistedBlockAccess;
import forestry.core.blocks.properties.UnlistedBlockPos;
import forestry.core.models.ModelBlockCached;
import forestry.core.tiles.TileUtil;
import forestry.farming.blocks.BlockFarm;
import forestry.farming.blocks.EnumFarmBlockType;
import forestry.farming.models.EnumFarmBlockTexture;
import forestry.farming.tiles.TileFarm;
import java.util.Objects;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelFarmBlock
extends ModelBlockCached<BlockFarm, Key> {
    public ModelFarmBlock() {
        super(BlockFarm.class);
    }

    @Override
    protected Key getInventoryKey(ItemStack stack) {
        EnumFarmBlockTexture texture = EnumFarmBlockTexture.getFromCompound(stack.func_77978_p());
        EnumFarmBlockType type = EnumFarmBlockType.VALUES[stack.func_77952_i()];
        return new Key(texture, type);
    }

    @Override
    protected Key getWorldKey(IBlockState state) {
        IExtendedBlockState stateExtended = (IExtendedBlockState)state;
        IBlockAccess world = (IBlockAccess)stateExtended.getValue((IUnlistedProperty)UnlistedBlockAccess.BLOCKACCESS);
        BlockPos pos = (BlockPos)stateExtended.getValue((IUnlistedProperty)UnlistedBlockPos.POS);
        TileFarm farm = TileUtil.getTile(world, pos, TileFarm.class);
        EnumFarmBlockTexture texture = EnumFarmBlockTexture.BRICK;
        EnumFarmBlockType type = EnumFarmBlockType.PLAIN;
        if (farm != null) {
            texture = farm.getFarmBlockTexture();
            type = farm.getFarmBlockType();
        }
        return new Key(texture, type);
    }

    @Override
    protected void bakeBlock(BlockFarm blockFarm, Key key, IModelBaker baker, boolean inventory) {
        TextureAtlasSprite[] textures = ModelFarmBlock.getSprites(key.texture);
        baker.addBlockModel(null, textures, 0);
        baker.addBlockModel(null, ModelFarmBlock.getOverlaySprites(key.type), 0);
        baker.setParticleSprite(textures[0]);
    }

    private static TextureAtlasSprite[] getSprites(EnumFarmBlockTexture texture) {
        TextureAtlasSprite[] textures = new TextureAtlasSprite[]{EnumFarmBlockTexture.getSprite(texture, 0), EnumFarmBlockTexture.getSprite(texture, 1), EnumFarmBlockTexture.getSprite(texture, 2), EnumFarmBlockTexture.getSprite(texture, 3), EnumFarmBlockTexture.getSprite(texture, 4), EnumFarmBlockTexture.getSprite(texture, 5)};
        return textures;
    }

    private static TextureAtlasSprite[] getOverlaySprites(EnumFarmBlockType farmType) {
        TextureAtlasSprite[] textures = new TextureAtlasSprite[]{EnumFarmBlockType.getSprite(farmType, 0), EnumFarmBlockType.getSprite(farmType, 1), EnumFarmBlockType.getSprite(farmType, 2), EnumFarmBlockType.getSprite(farmType, 3), EnumFarmBlockType.getSprite(farmType, 4), EnumFarmBlockType.getSprite(farmType, 5)};
        return textures;
    }

    public static class Key {
        public final EnumFarmBlockTexture texture;
        public final EnumFarmBlockType type;
        private final int hashCode;

        public Key(EnumFarmBlockTexture texture, EnumFarmBlockType type) {
            this.texture = texture;
            this.type = type;
            this.hashCode = Objects.hash(new Object[]{texture, type});
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof Key)) {
                return false;
            }
            Key otherKey = (Key)other;
            return otherKey.texture == this.texture && otherKey.type == this.type;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

