/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.astronomy;

import asmodeuscore.api.space.ICelestialRegistry;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.IChildBody;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;

public class SpaceData {
    public final String rocket_tier = "rocket_tier";
    public final String rocket_engine = "rocket_engine";
    public final String rocket_count_fuel = "rocket_count_fuel";
    public final String second_passenger = "second_passenger";
    private static Map<String, Object> map = new HashMap<String, Object>();
    static HashMap<SolarSystem, List<CelestialBody>> solarSystemList = Maps.newHashMap();
    static HashMap<Planet, List<CelestialBody>> moonList = Maps.newHashMap();
    static int maxCelestialBodiesID = 0;
    static HashMap<String, CelestialBody> celestialbodies = Maps.newHashMap();
    static BiMap<String, Integer> celestialbodiesIDs = HashBiMap.create();

    public void addToMap(String name, Object obj) {
        map.put(name, obj);
    }

    public Map getMap() {
        return map;
    }

    public Object getValue(String name) {
        return map.get(name);
    }

    public static void refreshGalaxies() {
        GalaxyRegistry.refreshGalaxies();
        moonList.clear();
        solarSystemList.clear();
        for (CelestialBody body : SpaceData.getRegisteredCelestialBodies().values()) {
            if (!(body instanceof ICelestialRegistry)) continue;
            if (body instanceof IChildBody) {
                Planet planet = ((IChildBody)body).getParentPlanet();
                List<CelestialBody> listOfMoons = moonList.get(planet);
                if (listOfMoons == null) {
                    listOfMoons = new ArrayList<CelestialBody>();
                }
                listOfMoons.add(body);
                moonList.put(planet, listOfMoons);
                continue;
            }
            SolarSystem solarSystem = ((ICelestialRegistry)body).getParentSolarSystem();
            List<CelestialBody> planetList = solarSystemList.get(solarSystem);
            if (planetList == null) {
                planetList = new ArrayList<CelestialBody>();
            }
            planetList.add(body);
            solarSystemList.put(solarSystem, planetList);
        }
    }

    public static List<CelestialBody> getBodiesForSolarSystem(SolarSystem solarSystem) {
        List<CelestialBody> solarSystemListLocal = solarSystemList.get(solarSystem);
        if (solarSystemListLocal == null) {
            return new ArrayList<CelestialBody>();
        }
        return ImmutableList.copyOf(solarSystemListLocal);
    }

    public static List<CelestialBody> getMoonsForPlanet(Planet planet) {
        List<CelestialBody> moonListLocal = moonList.get(planet);
        if (moonListLocal == null) {
            return new ArrayList<CelestialBody>();
        }
        return ImmutableList.copyOf(moonListLocal);
    }

    public static boolean registerCelestialBody(CelestialBody body) {
        if (celestialbodiesIDs.containsKey((Object)body.getName())) {
            return false;
        }
        celestialbodies.put(body.getName(), body);
        celestialbodiesIDs.put((Object)body.getName(), (Object)(++maxCelestialBodiesID));
        return true;
    }

    public static Map<String, CelestialBody> getRegisteredCelestialBodies() {
        return ImmutableMap.copyOf(celestialbodies);
    }

    public static Map<String, Integer> getRegisteredCelestialBodiesIDs() {
        return ImmutableMap.copyOf(celestialbodiesIDs);
    }

    public static int getCelestialBodyID(String bodyName) {
        return (Integer)celestialbodiesIDs.get((Object)bodyName);
    }

    public static enum Engine_Type {
        FUEL_ENGINE(0, "fuel_engine"),
        ION_ENGINE(1, "ion_engine"),
        PLASMA_ENGINE(2, "plasma_engine"),
        SUBLIGHT_ENGINE(3, "sublight_engine"),
        BLACKHOLE_ENGINE(4, "blackhole_engine");

        String name;
        int id;
        private static final Engine_Type[] values;

        private Engine_Type(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int getID() {
            return this.id;
        }

        public static Engine_Type byID(int id) {
            return values[id % values.length];
        }

        static {
            values = Engine_Type.values();
        }
    }
}

