/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.preview.world.data;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import pregenerator.impl.client.preview.world.IHeightMap;
import pregenerator.impl.client.preview.world.data.IChunkData;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.misc.Tuple;

public class Evaluator {
    Map<Long, Tuple<IChunkData, Timer>> toEvaluate = new ConcurrentHashMap<Long, Tuple<IChunkData, Timer>>();

    public void addChunk(IChunkData data) {
        Tuple<IChunkData, Timer> entry = this.toEvaluate.get(FilePos.asLong(data.getX(), data.getZ()));
        if (entry == null) {
            entry = new Tuple<IChunkData, Timer>(data, new Timer());
            this.toEvaluate.put(FilePos.asLong(data.getX(), data.getZ()), entry);
        } else {
            entry.setFirst(data);
            entry.getSecond().reset();
        }
    }

    public List<IChunkData> tick(boolean forced, IHeightMap map) {
        ArrayList<IChunkData> finished = new ArrayList<IChunkData>();
        LinkedHashSet<Long> toRemove = new LinkedHashSet<Long>();
        for (Map.Entry<Long, Tuple<IChunkData, Timer>> subEntry : this.toEvaluate.entrySet()) {
            Tuple<IChunkData, Timer> entry = subEntry.getValue();
            if (this.processChunk(entry, map)) {
                if (!entry.getSecond().isTimeOut(forced)) continue;
                entry.getFirst().updateHeightMap(map);
                finished.add(entry.getFirst());
                toRemove.add(subEntry.getKey());
                continue;
            }
            finished.add(entry.getFirst());
            toRemove.add(subEntry.getKey());
        }
        for (Long value : toRemove) {
            this.toEvaluate.remove(value);
        }
        return finished;
    }

    private boolean processChunk(Tuple<IChunkData, Timer> entry, IHeightMap map) {
        IChunkData data = entry.getFirst();
        if (!this.canGenerate(data.getX(), data.getZ(), map)) {
            return true;
        }
        data.updateHeightMap(map);
        return false;
    }

    public boolean canGenerate(int x, int z, IHeightMap map) {
        return map.hasHeightsStored(x + 1, z) && map.hasHeightsStored(x, z + 1);
    }

    public void clear() {
        this.toEvaluate.clear();
    }

    public static class Timer {
        int time;

        public boolean isTimeOut(boolean forced) {
            ++this.time;
            return this.time >= 200 && forced;
        }

        public void reset() {
            this.time = 0;
        }
    }
}

