/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.trackerInfo;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pregenerator.base.api.misc.IRenderHelper;
import pregenerator.base.api.network.IReadableBuffer;
import pregenerator.base.api.network.IWriteableBuffer;
import pregenerator.impl.client.trackerInfo.TrackerEntry;
import pregenerator.impl.tracking.WorldTracker;

public class WorldUsage
extends TrackerEntry {
    Map<Integer, Long> mapping = new HashMap<Integer, Long>();

    public WorldUsage() {
        this.register();
    }

    @Override
    public String getName() {
        return "Worlds-Usage";
    }

    @Override
    public void writeServer(IWriteableBuffer buf) {
        List<WorldTracker> trackers = this.getTracker().getTracker();
        buf.writeShort(trackers.size());
        for (WorldTracker track : trackers) {
            buf.writeInt(track.getDimID());
            buf.writeLong(track.getAverage());
        }
    }

    @Override
    public void readClient(IReadableBuffer buf) {
        HashMap<Integer, Long> map = new HashMap<Integer, Long>();
        int size = buf.readShort();
        for (int i = 0; i < size; ++i) {
            int id = buf.readInt();
            long value = buf.readLong();
            map.put(id, value);
        }
        this.mapping = map;
    }

    @Override
    public int currentValue() {
        return 0;
    }

    @Override
    public int maxValue() {
        return 0;
    }

    @Override
    public int getYOffset() {
        return super.getYOffset() * this.mapping.size();
    }

    @Override
    public void render(int x, int y, float progress, int width, IRenderHelper helper) {
        for (Map.Entry<Integer, Long> entry : new HashMap<Integer, Long>(this.mapping).entrySet()) {
            long actual = entry.getValue();
            int value = this.getValue(actual);
            progress = this.clamp(0.0f, 1.0f, (float)value / 50.0f);
            int progresBar = (int)(progress * (float)width);
            helper.renderBar(x - width / 2, y, width, progresBar, "Dim " + entry.getKey() + ": " + value + " / 50 ms (" + actual / 1000L + " qs)");
            y += 6;
        }
    }

    public int getValue(long value) {
        return (int)(value / 1000L / 1000L);
    }

    public float clamp(float min, float max, float current) {
        return current < min ? min : (current > max ? max : current);
    }
}

