/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.integration;

import com.jaquadro.minecraft.chameleon.integration.IntegrationModule;
import com.jaquadro.minecraft.storagedrawers.api.StorageDrawersApi;
import com.jaquadro.minecraft.storagedrawers.api.event.DrawerPopulatedEvent;
import com.jaquadro.minecraft.storagedrawers.api.registry.IWailaTooltipHandler;
import com.jaquadro.minecraft.storagedrawers.api.render.IRenderLabel;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IEssentiaContainerItem;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.items.ItemsTC;

public class Thaumcraft
extends IntegrationModule {
    private Item[] aspectItems;

    public String getModID() {
        return "thaumcraft";
    }

    public void init() throws Throwable {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.aspectItems = new Item[]{ItemsTC.phial, ItemsTC.crystalEssence, ItemsTC.jarBrace, ItemsTC.label, Item.func_150898_a((Block)BlocksTC.jarNormal), Item.func_150898_a((Block)BlocksTC.jarVoid)};
        StorageDrawersApi.instance().renderRegistry().registerPreLabelRenderHandler(new LabelRenderHandler());
        StorageDrawersApi.instance().wailaRegistry().registerTooltipHandler(new WailaTooltipHandler());
    }

    public void postInit() {
    }

    @SubscribeEvent
    public void onDrawerPopulated(DrawerPopulatedEvent event) {
        IDrawer drawer = event.drawer;
        if (drawer.isEmpty()) {
            drawer.setExtendedData("aspect", null);
            return;
        }
        ItemStack protoStack = drawer.getStoredItemPrototype();
        for (Item item : this.aspectItems) {
            if (item != protoStack.func_77973_b()) continue;
            this.setDrawerAspect(drawer, protoStack);
            return;
        }
    }

    private void setDrawerAspect(IDrawer drawer, ItemStack itemStack) {
        IEssentiaContainerItem container;
        AspectList aspects;
        String aspectFilter;
        Aspect aspect;
        NBTTagCompound compound = itemStack.func_77978_p();
        if (compound != null && compound.func_74764_b("AspectFilter") && (aspect = Aspect.getAspect((String)(aspectFilter = compound.func_74779_i("AspectFilter")))) != null) {
            drawer.setExtendedData("aspect", aspect);
            return;
        }
        if (itemStack.func_77973_b() instanceof IEssentiaContainerItem && (aspects = (container = (IEssentiaContainerItem)itemStack.func_77973_b()).getAspects(itemStack)) != null && aspects.size() != 0) {
            drawer.setExtendedData("aspect", aspects.getAspects()[0]);
        }
    }

    private void renderQuad(BufferBuilder tessellator, int x, int y, int w, int h, int r, int g, int b, int a) {
        tessellator.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        tessellator.func_181662_b((double)(x + 0), (double)(y + 0), 0.0).func_187315_a(0.0, 0.0).func_181669_b(r, g, b, a).func_181675_d();
        tessellator.func_181662_b((double)(x + 0), (double)(y + h), 0.0).func_187315_a(0.0, 1.0).func_181669_b(r, g, b, a).func_181675_d();
        tessellator.func_181662_b((double)(x + w), (double)(y + h), 0.0).func_187315_a(1.0, 1.0).func_181669_b(r, g, b, a).func_181675_d();
        tessellator.func_181662_b((double)(x + w), (double)(y + 0), 0.0).func_187315_a(1.0, 0.0).func_181669_b(r, g, b, a).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    private class LabelRenderHandler
    implements IRenderLabel {
        private LabelRenderHandler() {
        }

        @Override
        public void render(TileEntity tileEntity, IDrawerGroup drawerGroup, int slot, float brightness, float partialTickTime) {
            IDrawer drawer = drawerGroup.getDrawer(slot);
            if (drawer == null) {
                return;
            }
            Object aspectObj = drawer.getExtendedData("aspect");
            if (!(aspectObj instanceof Aspect)) {
                return;
            }
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            BlockPos blockPos = tileEntity.func_174877_v().func_177963_a(0.5, 0.5, 0.5);
            double distance = Math.sqrt(blockPos.func_177951_i((Vec3i)player.func_180425_c()));
            if (distance > 10.0) {
                return;
            }
            Aspect aspect = (Aspect)aspectObj;
            int x = -4;
            int y = -4;
            int w = 8;
            int h = 8;
            if (drawerGroup.getDrawerCount() == 2) {
                x = -16;
                y = 0;
                w = 16;
                h = 16;
            }
            float alpha = 1.0f;
            if (distance > 3.0) {
                alpha = 1.0f - (float)((distance - 3.0) / 7.0);
            }
            int color = aspect.getColor();
            float r = color >> 16 & 0xFF;
            float g = color >> 8 & 0xFF;
            float b = color & 0xFF;
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179140_f();
            GlStateManager.func_179147_l();
            GlStateManager.func_179141_d();
            GlStateManager.func_179088_q();
            GlStateManager.func_179136_a((float)-1.0f, (float)-1.0f);
            ResourceLocation aspectResource = aspect.getImage();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(aspectResource);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder worldRenderer = tessellator.func_178180_c();
            Thaumcraft.this.renderQuad(worldRenderer, x, y, w, h, (int)r, (int)g, (int)b, (int)(alpha * 255.0f));
            GlStateManager.func_179113_r();
            GlStateManager.func_179118_c();
            GlStateManager.func_179084_k();
            GlStateManager.func_179145_e();
        }
    }

    private class WailaTooltipHandler
    implements IWailaTooltipHandler {
        private WailaTooltipHandler() {
        }

        @Override
        public String transformItemName(IDrawer drawer, String defaultName) {
            Object aspectObj = drawer.getExtendedData("aspect");
            if (!(aspectObj instanceof Aspect)) {
                return defaultName;
            }
            Aspect aspect = (Aspect)aspectObj;
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            return defaultName + " (" + aspect.getName() + ")";
        }
    }
}

